/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import mekanism.api.Coord4D;
import mekanism.common.IBoundingBlock;
import mekanism.common.Mekanism;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityWindTurbine
extends TileEntityGenerator
implements IBoundingBlock {
    public int angle;

    public TileEntityWindTurbine() {
        super("WindTurbine", 200000.0, MekanismGenerators.windGenerationMax * 2.0);
        this.inventory = new ItemStack[1];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.charge((int)0, (TileEntityElectricBlock)this);
            if (this.canOperate()) {
                this.setActive(true);
                this.setEnergy(this.electricityStored + MekanismGenerators.windGenerationMin * (double)this.getMultiplier());
            } else {
                this.setActive(false);
            }
        }
    }

    public float getMultiplier() {
        if (this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d + 4, this.field_145849_e)) {
            float minY = MekanismGenerators.windGenerationMinY;
            float maxY = MekanismGenerators.windGenerationMaxY;
            float minG = (float)MekanismGenerators.windGenerationMin;
            float maxG = (float)MekanismGenerators.windGenerationMax;
            float slope = (maxG - minG) / (maxY - minY);
            float intercept = minG - slope * minY;
            float clampedY = Math.min(maxY, Math.max(minY, (float)(this.field_145848_d + 4)));
            float toGen = slope * clampedY + intercept;
            return toGen / minG;
        }
        return 0.0f;
    }

    @Override
    public float getVolumeMultiplier() {
        return 1.5f;
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"getStored", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getMultiplier"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.output};
            }
            case 2: {
                return new Object[]{this.MAX_ELECTRICITY};
            }
            case 3: {
                return new Object[]{this.MAX_ELECTRICITY - this.electricityStored};
            }
            case 4: {
                return new Object[]{Float.valueOf(this.getMultiplier())};
            }
        }
        Mekanism.logger.error("Attempted to call unknown method with computer ID " + computer.getID());
        return null;
    }

    @Override
    public boolean canOperate() {
        return this.electricityStored < this.MAX_ELECTRICITY && this.getMultiplier() > 0.0f && MekanismUtils.canFunction((TileEntity)this);
    }

    public void onPlace() {
        MekanismUtils.makeBoundingBlock((World)this.field_145850_b, (int)this.field_145851_c, (int)(this.field_145848_d + 1), (int)this.field_145849_e, (Coord4D)Coord4D.get((TileEntity)this));
        MekanismUtils.makeBoundingBlock((World)this.field_145850_b, (int)this.field_145851_c, (int)(this.field_145848_d + 2), (int)this.field_145849_e, (Coord4D)Coord4D.get((TileEntity)this));
        MekanismUtils.makeBoundingBlock((World)this.field_145850_b, (int)this.field_145851_c, (int)(this.field_145848_d + 3), (int)this.field_145849_e, (Coord4D)Coord4D.get((TileEntity)this));
        MekanismUtils.makeBoundingBlock((World)this.field_145850_b, (int)this.field_145851_c, (int)(this.field_145848_d + 4), (int)this.field_145849_e, (Coord4D)Coord4D.get((TileEntity)this));
    }

    public void onBreak() {
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e);
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e);
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d + 4, this.field_145849_e);
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }
}

