/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common;

import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import mekanism.api.MekanismConfig;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.generators.common.inventory.container.ContainerBioGenerator;
import mekanism.generators.common.inventory.container.ContainerGasGenerator;
import mekanism.generators.common.inventory.container.ContainerHeatGenerator;
import mekanism.generators.common.inventory.container.ContainerNeutronCapture;
import mekanism.generators.common.inventory.container.ContainerReactorController;
import mekanism.generators.common.inventory.container.ContainerSolarGenerator;
import mekanism.generators.common.inventory.container.ContainerWindTurbine;
import mekanism.generators.common.tile.TileEntityAdvancedSolarGenerator;
import mekanism.generators.common.tile.TileEntityBioGenerator;
import mekanism.generators.common.tile.TileEntityGasGenerator;
import mekanism.generators.common.tile.TileEntityHeatGenerator;
import mekanism.generators.common.tile.TileEntitySolarGenerator;
import mekanism.generators.common.tile.TileEntityWindTurbine;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import mekanism.generators.common.tile.reactor.TileEntityReactorFrame;
import mekanism.generators.common.tile.reactor.TileEntityReactorGlass;
import mekanism.generators.common.tile.reactor.TileEntityReactorLaserFocusMatrix;
import mekanism.generators.common.tile.reactor.TileEntityReactorLogicAdapter;
import mekanism.generators.common.tile.reactor.TileEntityReactorNeutronCapture;
import mekanism.generators.common.tile.reactor.TileEntityReactorPort;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class GeneratorsCommonProxy {
    public static int GENERATOR_RENDER_ID = RenderingRegistry.getNextAvailableRenderId();

    public void registerRegularTileEntities() {
        GameRegistry.registerTileEntity(TileEntityReactorFrame.class, (String)"ReactorFrame");
        GameRegistry.registerTileEntity(TileEntityReactorGlass.class, (String)"ReactorGlass");
        GameRegistry.registerTileEntity(TileEntityReactorLaserFocusMatrix.class, (String)"ReactorLaserFocus");
        GameRegistry.registerTileEntity(TileEntityReactorNeutronCapture.class, (String)"ReactorNeutronCapture");
        GameRegistry.registerTileEntity(TileEntityReactorPort.class, (String)"ReactorPort");
        GameRegistry.registerTileEntity(TileEntityReactorLogicAdapter.class, (String)"ReactorLogicAdapter");
    }

    public void registerSpecialTileEntities() {
        GameRegistry.registerTileEntity(TileEntityAdvancedSolarGenerator.class, (String)"AdvancedSolarGenerator");
        GameRegistry.registerTileEntity(TileEntitySolarGenerator.class, (String)"SolarGenerator");
        GameRegistry.registerTileEntity(TileEntityBioGenerator.class, (String)"BioGenerator");
        GameRegistry.registerTileEntity(TileEntityHeatGenerator.class, (String)"HeatGenerator");
        GameRegistry.registerTileEntity(TileEntityGasGenerator.class, (String)"GasGenerator");
        GameRegistry.registerTileEntity(TileEntityWindTurbine.class, (String)"WindTurbine");
        GameRegistry.registerTileEntity(TileEntityReactorController.class, (String)"ReactorController");
    }

    public void registerRenderInformation() {
    }

    public void loadConfiguration() {
        MekanismConfig.generators.advancedSolarGeneration = Mekanism.configuration.get("generation", "AdvancedSolarGeneration", 300.0).getDouble(300.0);
        MekanismConfig.generators.bioGeneration = Mekanism.configuration.get("generation", "BioGeneration", 350.0).getDouble(350.0);
        MekanismConfig.generators.heatGeneration = Mekanism.configuration.get("generation", "HeatGeneration", 150.0).getDouble(150.0);
        MekanismConfig.generators.heatGenerationLava = Mekanism.configuration.get("generation", "HeatGenerationLava", 5.0).getDouble(5.0);
        MekanismConfig.generators.heatGenerationNether = Mekanism.configuration.get("generation", "HeatGenerationNether", 100.0).getDouble(100.0);
        MekanismConfig.generators.solarGeneration = Mekanism.configuration.get("generation", "SolarGeneration", 50.0).getDouble(50.0);
        this.loadWindConfiguration();
        if (Mekanism.configuration.hasChanged()) {
            Mekanism.configuration.save();
        }
    }

    private void loadWindConfiguration() {
        if (Mekanism.configuration.hasKey("generation", "WindGeneration")) {
            double legacyWindGeneration = Mekanism.configuration.get("generation", "WindGeneration", 60.0).getDouble(60.0);
            double windGenerationMax = legacyWindGeneration * 8.0;
            Mekanism.configuration.getCategory("generation").remove((Object)"WindGeneration");
            MekanismConfig.generators.windGenerationMin = Mekanism.configuration.get("generation", "WindGenerationMin", legacyWindGeneration).getDouble(legacyWindGeneration);
            MekanismConfig.generators.windGenerationMax = Mekanism.configuration.get("generation", "WindGenerationMax", windGenerationMax).getDouble(windGenerationMax);
        } else {
            MekanismConfig.generators.windGenerationMin = Mekanism.configuration.get("generation", "WindGenerationMin", 60.0).getDouble(60.0);
            MekanismConfig.generators.windGenerationMax = Mekanism.configuration.get("generation", "WindGenerationMax", 480.0).getDouble(480.0);
        }
        int minY = Mekanism.configuration.get("generation", "WindGenerationMinY", 24).getInt(24);
        int maxY = Mekanism.configuration.get("generation", "WindGenerationMaxY", 255).getInt(255);
        MekanismConfig.generators.windGenerationMinY = minY;
        MekanismConfig.generators.windGenerationMaxY = Math.max(minY + 1, maxY);
    }

    public Object getClientGui(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public Container getServerGui(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        switch (ID) {
            case 0: {
                return new ContainerHeatGenerator(player.field_71071_by, (TileEntityHeatGenerator)tileEntity);
            }
            case 1: {
                return new ContainerSolarGenerator(player.field_71071_by, (TileEntitySolarGenerator)tileEntity);
            }
            case 3: {
                return new ContainerGasGenerator(player.field_71071_by, (TileEntityGasGenerator)tileEntity);
            }
            case 4: {
                return new ContainerBioGenerator(player.field_71071_by, (TileEntityBioGenerator)tileEntity);
            }
            case 5: {
                return new ContainerWindTurbine(player.field_71071_by, (TileEntityWindTurbine)tileEntity);
            }
            case 10: {
                return new ContainerReactorController(player.field_71071_by, (TileEntityReactorController)tileEntity);
            }
            case 11: 
            case 12: 
            case 13: {
                return new ContainerNull(player, (TileEntityContainerBlock)tileEntity);
            }
            case 14: {
                return new ContainerNeutronCapture(player.field_71071_by, (TileEntityReactorNeutronCapture)tileEntity);
            }
            case 15: {
                return new ContainerNull(player, (TileEntityContainerBlock)tileEntity);
            }
        }
        return null;
    }
}

