/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.client.model.ModelBioGenerator;
import mekanism.generators.common.tile.TileEntityBioGenerator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderBioGenerator
extends TileEntitySpecialRenderer {
    private ModelBioGenerator model = new ModelBioGenerator();
    private Map<ForgeDirection, MekanismRenderer.DisplayInteger[]> energyDisplays = new HashMap<ForgeDirection, MekanismRenderer.DisplayInteger[]>();
    private static final int stages = 40;

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float partialTick) {
        this.renderAModelAt((TileEntityBioGenerator)tileEntity, x, y, z, partialTick);
    }

    private void renderAModelAt(TileEntityBioGenerator tileEntity, double x, double y, double z, float partialTick) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        this.func_147499_a(MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.RENDER, (String)"BioGenerator.png"));
        switch (tileEntity.facing) {
            case 2: {
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 3: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 4: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 5: {
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.model.render(0.0625f);
        GL11.glPopMatrix();
        if (tileEntity.bioFuelSlot.fluidStored > 0) {
            this.push();
            MekanismRenderer.glowOn();
            GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
            this.func_147499_a(MekanismRenderer.getBlocksTexture());
            this.getDisplayList(ForgeDirection.getOrientation((int)tileEntity.facing))[tileEntity.getScaledFuelLevel(39)].render();
            MekanismRenderer.glowOff();
            this.pop();
        }
    }

    private MekanismRenderer.DisplayInteger[] getDisplayList(ForgeDirection side) {
        if (this.energyDisplays.containsKey(side)) {
            return this.energyDisplays.get(side);
        }
        MekanismRenderer.DisplayInteger[] displays = new MekanismRenderer.DisplayInteger[40];
        MekanismRenderer.Model3D model3D = new MekanismRenderer.Model3D();
        model3D.baseBlock = Blocks.field_150355_j;
        model3D.setTexture(MekanismRenderer.energyIcon);
        for (int i = 0; i < 40; ++i) {
            displays[i] = MekanismRenderer.DisplayInteger.createAndStart();
            switch (side) {
                case NORTH: {
                    model3D.minZ = 0.1875;
                    model3D.maxZ = 0.4375;
                    model3D.minX = 0.375;
                    model3D.maxX = 0.625;
                    model3D.minY = 0.125;
                    model3D.maxY = 0.125 + (double)((float)i / 40.0f) * 0.34375;
                    break;
                }
                case SOUTH: {
                    model3D.minZ = 0.5625;
                    model3D.maxZ = 0.8125;
                    model3D.minX = 0.375;
                    model3D.maxX = 0.625;
                    model3D.minY = 0.125;
                    model3D.maxY = 0.125 + (double)((float)i / 40.0f) * 0.34375;
                    break;
                }
                case WEST: {
                    model3D.minX = 0.1875;
                    model3D.maxX = 0.4375;
                    model3D.minZ = 0.375;
                    model3D.maxZ = 0.625;
                    model3D.minY = 0.125;
                    model3D.maxY = 0.125 + (double)((float)i / 40.0f) * 0.34375;
                    break;
                }
                case EAST: {
                    model3D.minX = 0.5625;
                    model3D.maxX = 0.8125;
                    model3D.minZ = 0.375;
                    model3D.maxZ = 0.625;
                    model3D.minY = 0.125;
                    model3D.maxY = 0.125 + (double)((float)i / 40.0f) * 0.34375;
                }
            }
            MekanismRenderer.renderObject((MekanismRenderer.Model3D)model3D);
            MekanismRenderer.DisplayInteger cfr_ignored_0 = displays[i];
            MekanismRenderer.DisplayInteger.endList();
        }
        this.energyDisplays.put(side, displays);
        return displays;
    }

    private void pop() {
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void push() {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glBlendFunc((int)770, (int)771);
    }
}

