/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.block;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.common.CTMData;
import mekanism.common.CommonProxy;
import mekanism.common.ItemAttacher;
import mekanism.common.Mekanism;
import mekanism.common.base.IBlockCTM;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.GeneratorsBlocks;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import mekanism.generators.common.tile.reactor.TileEntityReactorFrame;
import mekanism.generators.common.tile.reactor.TileEntityReactorGlass;
import mekanism.generators.common.tile.reactor.TileEntityReactorLaserFocusMatrix;
import mekanism.generators.common.tile.reactor.TileEntityReactorLogicAdapter;
import mekanism.generators.common.tile.reactor.TileEntityReactorNeutronCapture;
import mekanism.generators.common.tile.reactor.TileEntityReactorPort;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockReactor
extends BlockContainer
implements IBlockCTM {
    public IIcon[][] icons = new IIcon[16][16];
    public CTMData[][] ctms = new CTMData[16][2];

    public BlockReactor() {
        super(Material.field_151573_f);
        this.func_149711_c(3.5f);
        this.func_149752_b(8.0f);
        this.func_149647_a((CreativeTabs)Mekanism.tabMekanism);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        if (this == GeneratorsBlocks.Reactor) {
            this.ctms[0][0] = new CTMData("ctm/ReactorFrame", (Block)this, Arrays.asList(0, 1, 2, 3, 4)).addSideOverride(ForgeDirection.UP, "ctm/ReactorControllerOff").registerIcons(register);
            this.ctms[0][1] = new CTMData("ctm/ReactorFrame", (Block)this, Arrays.asList(0, 1, 2, 3, 4)).addSideOverride(ForgeDirection.UP, "ctm/ReactorControllerOn").registerIcons(register);
            this.ctms[1][0] = new CTMData("ctm/ReactorFrame", (Block)this, Arrays.asList(0, 1, 2, 3, 4)).registerIcons(register);
            this.ctms[2][0] = new CTMData("ctm/ReactorNeutronCapture", (Block)this, Arrays.asList(0, 1, 2, 3, 4)).registerIcons(register);
            this.ctms[3][0] = new CTMData("ctm/ReactorPort", (Block)this, Arrays.asList(0, 1, 2, 3, 4)).registerIcons(register);
            this.ctms[4][0] = new CTMData("ctm/ReactorLogicAdapter", (Block)this, Arrays.asList(0, 1, 2, 3, 4)).registerIcons(register);
            this.icons[0][0] = this.ctms[0][0].sideOverrides[1].icon;
            this.icons[0][1] = this.ctms[0][1].sideOverrides[1].icon;
            this.icons[0][2] = this.ctms[0][0].mainTextureData.icon;
            this.icons[1][0] = this.ctms[1][0].mainTextureData.icon;
            this.icons[2][0] = this.ctms[2][0].mainTextureData.icon;
            this.icons[3][0] = this.ctms[3][0].mainTextureData.icon;
            this.icons[4][0] = this.ctms[4][0].mainTextureData.icon;
        } else if (this == GeneratorsBlocks.ReactorGlass) {
            this.ctms[0][0] = new CTMData("ctm/ReactorGlass", (Block)this, Arrays.asList(0, 1)).registerIcons(register);
            this.ctms[1][0] = new CTMData("ctm/ReactorLaserFocus", (Block)this, Arrays.asList(1, 0)).registerIcons(register);
            this.icons[0][0] = this.ctms[0][0].mainTextureData.icon;
            this.icons[1][0] = this.ctms[1][0].mainTextureData.icon;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (this == GeneratorsBlocks.Reactor) {
            if (meta == 0) {
                return this.icons[0][side == 1 ? 0 : 2];
            }
            return this.icons[meta][0];
        }
        if (this == GeneratorsBlocks.ReactorGlass) {
            return this.icons[meta][0];
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.func_72805_g(x, y, z);
        if (this == GeneratorsBlocks.Reactor) {
            if (metadata == 0) {
                if (side == 1) {
                    return MekanismUtils.isActive((IBlockAccess)world, (int)x, (int)y, (int)z) ? this.icons[0][1] : this.icons[0][0];
                }
                return this.icons[0][2];
            }
            return this.icons[metadata][0];
        }
        if (this == GeneratorsBlocks.ReactorGlass) {
            return this.icons[metadata][0];
        }
        return null;
    }

    public int func_149692_a(int i) {
        return i;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_147438_o(x, y, z)) instanceof TileEntityBasicBlock) {
            ((TileEntityBasicBlock)tileEntity).onNeighborChange(block);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityplayer, int facing, float playerX, float playerY, float playerZ) {
        if (ItemAttacher.canAttach((ItemStack)entityplayer.func_71045_bC())) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        TileEntityElectricBlock tileEntity = (TileEntityElectricBlock)world.func_147438_o(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        if (entityplayer.func_71045_bC() != null && MekanismUtils.isBCWrench((Item)entityplayer.func_71045_bC().func_77973_b()) && !entityplayer.func_71045_bC().func_77977_a().contains("omniwrench")) {
            if (entityplayer.func_70093_af()) {
                this.dismantleBlock(world, x, y, z, false);
                return true;
            }
            ((IToolWrench)entityplayer.func_71045_bC().func_77973_b()).wrenchUsed(entityplayer, x, y, z);
            int change = 0;
            switch (tileEntity.facing) {
                case 3: {
                    change = 5;
                    break;
                }
                case 5: {
                    change = 2;
                    break;
                }
                case 2: {
                    change = 4;
                    break;
                }
                case 4: {
                    change = 3;
                }
            }
            tileEntity.setFacing((short)change);
            world.func_147459_d(x, y, z, (Block)this);
            return true;
        }
        if (tileEntity instanceof TileEntityReactorController && !entityplayer.func_70093_af()) {
            entityplayer.openGui((Object)MekanismGenerators.instance, ReactorBlockType.get((Block)this, (int)metadata).guiId, world, x, y, z);
            return true;
        }
        if (tileEntity instanceof TileEntityReactorLogicAdapter && !entityplayer.func_70093_af()) {
            entityplayer.openGui((Object)MekanismGenerators.instance, ReactorBlockType.get((Block)this, (int)metadata).guiId, world, x, y, z);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativetabs, List list) {
        for (ReactorBlockType type : ReactorBlockType.values()) {
            if (type.typeBlock != this || type == ReactorBlockType.NEUTRON_CAPTURE) continue;
            list.add(new ItemStack(item, 1, type.meta));
        }
    }

    public TileEntity createTileEntity(World world, int metadata) {
        ReactorBlockType type = ReactorBlockType.get((Block)this, metadata);
        if (type != null) {
            return type.create();
        }
        return null;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149701_w() {
        return this == GeneratorsBlocks.Reactor ? 0 : 1;
    }

    public int func_149645_b() {
        return CommonProxy.CTM_RENDER_ID;
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!world.field_72995_K && tileEntity instanceof TileEntityBasicBlock) {
            ((TileEntityBasicBlock)tileEntity).onAdded();
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return null;
    }

    public CTMData getCTMData(IBlockAccess world, int x, int y, int z, int meta) {
        if (this.ctms[meta][1] != null && MekanismUtils.isActive((IBlockAccess)world, (int)x, (int)y, (int)z)) {
            return this.ctms[meta][1];
        }
        return this.ctms[meta][0];
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        Coord4D obj = new Coord4D(x, y, z).getFromSide(ForgeDirection.getOrientation((int)side).getOpposite());
        if (this == GeneratorsBlocks.ReactorGlass) {
            int metadata = obj.getMetadata(world);
            switch (metadata) {
                case 0: 
                case 1: {
                    return this.ctms[metadata][0].shouldRenderSide(world, x, y, z, side);
                }
            }
            return super.func_149646_a(world, x, y, z, side);
        }
        return super.func_149646_a(world, x, y, z, side);
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityReactorLogicAdapter) {
            return ((TileEntityReactorLogicAdapter)tile).checkMode() ? 15 : 0;
        }
        return 0;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        ReactorBlockType type = ReactorBlockType.get((Block)this, world.func_72805_g(x, y, z));
        switch (type) {
            case FRAME: 
            case PORT: 
            case ADAPTER: {
                return true;
            }
        }
        return false;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        ReactorBlockType type = ReactorBlockType.get((Block)this, world.func_72805_g(x, y, z));
        switch (type) {
            case ADAPTER: {
                return true;
            }
        }
        return false;
    }

    public ItemStack dismantleBlock(World world, int x, int y, int z, boolean returnBlock) {
        ItemStack itemStack = new ItemStack((Block)this, 1, world.func_72805_g(x, y, z));
        world.func_147468_f(x, y, z);
        if (!returnBlock) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + motionX, (double)y + motionY, (double)z + motionZ, itemStack);
            world.func_72838_d((Entity)entityItem);
        }
        return itemStack;
    }

    public static enum ReactorBlockType {
        CONTROLLER(GeneratorsBlocks.Reactor, 0, "ReactorController", 10, TileEntityReactorController.class),
        FRAME(GeneratorsBlocks.Reactor, 1, "ReactorFrame", -1, TileEntityReactorFrame.class),
        NEUTRON_CAPTURE(GeneratorsBlocks.Reactor, 2, "ReactorNeutronCapturePlate", 14, TileEntityReactorNeutronCapture.class),
        PORT(GeneratorsBlocks.Reactor, 3, "ReactorPort", -1, TileEntityReactorPort.class),
        ADAPTER(GeneratorsBlocks.Reactor, 4, "ReactorLogicAdapter", 15, TileEntityReactorLogicAdapter.class),
        GLASS(GeneratorsBlocks.ReactorGlass, 0, "ReactorGlass", -1, TileEntityReactorGlass.class),
        LASER_FOCUS_MATRIX(GeneratorsBlocks.ReactorGlass, 1, "ReactorLaserFocusMatrix", -1, TileEntityReactorLaserFocusMatrix.class);

        public Block typeBlock;
        public int meta;
        public String name;
        public int guiId;
        public Class<? extends TileEntity> tileEntityClass;

        private ReactorBlockType(Block b, int i, String s, int j, Class<? extends TileEntityElectricBlock> tileClass) {
            this.typeBlock = b;
            this.meta = i;
            this.name = s;
            this.guiId = j;
            this.tileEntityClass = tileClass;
        }

        public static ReactorBlockType get(Block block, int meta) {
            for (ReactorBlockType type : ReactorBlockType.values()) {
                if (type.typeBlock != block || type.meta != meta) continue;
                return type;
            }
            return null;
        }

        public static ReactorBlockType get(ItemStack stack) {
            return ReactorBlockType.get(Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77960_j());
        }

        public TileEntity create() {
            try {
                return this.tileEntityClass.newInstance();
            }
            catch (Exception e) {
                Mekanism.logger.error("Unable to indirectly create tile entity.");
                e.printStackTrace();
                return null;
            }
        }

        public String getDescription() {
            return LangUtils.localize((String)("tooltip." + this.name));
        }

        public ItemStack getStack() {
            return new ItemStack(this.typeBlock, 1, this.meta);
        }
    }
}

