/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.turbine;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.api.Range4D;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.Mekanism;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.multiblock.UpdateProtocol;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import mekanism.generators.common.content.turbine.TurbineCache;
import mekanism.generators.common.content.turbine.TurbineUpdateProtocol;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityTurbineCasing
extends TileEntityMultiblock<SynchronizedTurbineData>
implements IStrictEnergyStorage {
    public TileEntityTurbineCasing() {
        this("TurbineCasing");
    }

    public TileEntityTurbineCasing(String name) {
        super(name);
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K && this.structure != null) {
            if (((SynchronizedTurbineData)this.structure).fluidStored != null && ((SynchronizedTurbineData)this.structure).fluidStored.amount <= 0) {
                ((SynchronizedTurbineData)this.structure).fluidStored = null;
                this.func_70296_d();
            }
            if (this.isRendering) {
                ((SynchronizedTurbineData)this.structure).lastSteamInput = ((SynchronizedTurbineData)this.structure).newSteamInput;
                ((SynchronizedTurbineData)this.structure).newSteamInput = 0;
                int stored = ((SynchronizedTurbineData)this.structure).fluidStored != null ? ((SynchronizedTurbineData)this.structure).fluidStored.amount : 0;
                double proportion = (double)stored / (double)((SynchronizedTurbineData)this.structure).getFluidCapacity();
                double flowRate = 0.0;
                if (stored > 0 && this.getEnergy() < ((SynchronizedTurbineData)this.structure).getEnergyCapacity()) {
                    double energyMultiplier = MekanismConfig.general.maxEnergyPerSteam / 28.0 * (double)Math.min(((SynchronizedTurbineData)this.structure).blades, ((SynchronizedTurbineData)this.structure).coils * MekanismConfig.generators.turbineBladesPerCoil);
                    double rate = (double)((SynchronizedTurbineData)this.structure).lowerVolume * ((double)((SynchronizedTurbineData)this.structure).getDispersers() * MekanismConfig.generators.turbineDisperserGasFlow);
                    double origRate = rate = Math.min(rate, (double)((SynchronizedTurbineData)this.structure).vents * MekanismConfig.generators.turbineVentGasFlow);
                    rate = Math.min(Math.min((double)stored, rate), (this.getMaxEnergy() - this.getEnergy()) / energyMultiplier) * proportion;
                    flowRate = rate / origRate;
                    this.setEnergy(this.getEnergy() + (double)((int)rate) * energyMultiplier);
                    ((SynchronizedTurbineData)this.structure).fluidStored.amount = (int)((double)((SynchronizedTurbineData)this.structure).fluidStored.amount - rate);
                    ((SynchronizedTurbineData)this.structure).clientFlow = (int)rate;
                    if (((SynchronizedTurbineData)this.structure).fluidStored.amount == 0) {
                        ((SynchronizedTurbineData)this.structure).fluidStored = null;
                    }
                } else {
                    ((SynchronizedTurbineData)this.structure).clientFlow = 0;
                }
                float newRotation = (float)flowRate;
                boolean needsRotationUpdate = false;
                if (Math.abs(newRotation - ((SynchronizedTurbineData)this.structure).clientRotation) > 0.001f) {
                    ((SynchronizedTurbineData)this.structure).clientRotation = newRotation;
                    needsRotationUpdate = true;
                }
                if (((SynchronizedTurbineData)this.structure).needsRenderUpdate() || needsRotationUpdate) {
                    this.sendPacketToRenderer();
                }
                ((SynchronizedTurbineData)this.structure).prevFluid = ((SynchronizedTurbineData)this.structure).fluidStored != null ? ((SynchronizedTurbineData)this.structure).fluidStored.copy() : null;
            }
        }
    }

    public String func_145825_b() {
        return LangUtils.localize((String)"gui.industrialTurbine");
    }

    public boolean onActivate(EntityPlayer player) {
        if (!player.func_70093_af() && this.structure != null) {
            Mekanism.packetHandler.sendToReceivers((IMessage)new PacketTileEntity.TileEntityMessage(Coord4D.get((TileEntity)this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get((TileEntity)this)));
            player.openGui((Object)MekanismGenerators.instance, 6, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    public double getEnergy() {
        return this.structure != null ? ((SynchronizedTurbineData)this.structure).electricityStored : 0.0;
    }

    public double getMaxEnergy() {
        return ((SynchronizedTurbineData)this.structure).getEnergyCapacity();
    }

    public void setEnergy(double energy) {
        if (this.structure != null) {
            ((SynchronizedTurbineData)this.structure).electricityStored = Math.max(Math.min(energy, this.getMaxEnergy()), 0.0);
            MekanismUtils.saveChunk((TileEntity)this);
        }
    }

    public int getScaledFluidLevel(int i) {
        if (((SynchronizedTurbineData)this.structure).getFluidCapacity() == 0 || ((SynchronizedTurbineData)this.structure).fluidStored == null) {
            return 0;
        }
        return ((SynchronizedTurbineData)this.structure).fluidStored.amount * i / ((SynchronizedTurbineData)this.structure).getFluidCapacity();
    }

    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        if (this.structure != null) {
            data.add(((SynchronizedTurbineData)this.structure).volume);
            data.add(((SynchronizedTurbineData)this.structure).lowerVolume);
            data.add(((SynchronizedTurbineData)this.structure).vents);
            data.add(((SynchronizedTurbineData)this.structure).blades);
            data.add(((SynchronizedTurbineData)this.structure).coils);
            data.add(((SynchronizedTurbineData)this.structure).getDispersers());
            data.add(((SynchronizedTurbineData)this.structure).electricityStored);
            data.add(((SynchronizedTurbineData)this.structure).clientFlow);
            data.add(((SynchronizedTurbineData)this.structure).lastSteamInput);
            if (((SynchronizedTurbineData)this.structure).fluidStored != null) {
                data.add(1);
                data.add(((SynchronizedTurbineData)this.structure).fluidStored.getFluidID());
                data.add(((SynchronizedTurbineData)this.structure).fluidStored.amount);
            } else {
                data.add(0);
            }
            if (this.isRendering) {
                ((SynchronizedTurbineData)this.structure).complex.write(data);
                data.add(Float.valueOf(((SynchronizedTurbineData)this.structure).clientRotation));
            }
        }
        return data;
    }

    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (this.field_145850_b.field_72995_K && this.clientHasStructure) {
            ((SynchronizedTurbineData)this.structure).volume = dataStream.readInt();
            ((SynchronizedTurbineData)this.structure).lowerVolume = dataStream.readInt();
            ((SynchronizedTurbineData)this.structure).vents = dataStream.readInt();
            ((SynchronizedTurbineData)this.structure).blades = dataStream.readInt();
            ((SynchronizedTurbineData)this.structure).coils = dataStream.readInt();
            ((SynchronizedTurbineData)this.structure).clientDispersers = dataStream.readInt();
            ((SynchronizedTurbineData)this.structure).electricityStored = dataStream.readDouble();
            ((SynchronizedTurbineData)this.structure).clientFlow = dataStream.readInt();
            ((SynchronizedTurbineData)this.structure).lastSteamInput = dataStream.readInt();
            ((SynchronizedTurbineData)this.structure).fluidStored = dataStream.readInt() == 1 ? new FluidStack(FluidRegistry.getFluid((int)dataStream.readInt()), dataStream.readInt()) : null;
            if (this.isRendering) {
                ((SynchronizedTurbineData)this.structure).complex = Coord4D.read((ByteBuf)dataStream);
                ((SynchronizedTurbineData)this.structure).clientRotation = dataStream.readFloat();
                SynchronizedTurbineData.clientRotationMap.put(((SynchronizedTurbineData)this.structure).inventoryID, Float.valueOf(((SynchronizedTurbineData)this.structure).clientRotation));
            }
        }
    }

    protected SynchronizedTurbineData getNewStructure() {
        return new SynchronizedTurbineData();
    }

    public MultiblockCache<SynchronizedTurbineData> getNewCache() {
        return new TurbineCache();
    }

    protected UpdateProtocol<SynchronizedTurbineData> getProtocol() {
        return new TurbineUpdateProtocol(this);
    }

    public MultiblockManager<SynchronizedTurbineData> getManager() {
        return MekanismGenerators.turbineManager;
    }
}

