/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.turbine;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyTile;
import java.util.EnumSet;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.common.base.IEnergyWrapper;
import mekanism.common.util.CableUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import mekanism.generators.common.content.turbine.TurbineFluidTank;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="IC2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="IC2"), @Optional.Interface(iface="ic2.api.tile.IEnergyStorage", modid="IC2")})
public class TileEntityTurbineValve
extends TileEntityTurbineCasing
implements IFluidHandler,
IEnergyWrapper {
    public boolean ic2Registered = false;
    public TurbineFluidTank fluidTank = new TurbineFluidTank(this);

    public TileEntityTurbineValve() {
        super("TurbineValve");
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.ic2Registered && MekanismUtils.useIC2()) {
            this.register();
        }
        if (!this.field_145850_b.field_72995_K && this.structure != null) {
            double prev = this.getEnergy();
            CableUtils.emit((IEnergyWrapper)this);
        }
    }

    public EnumSet<ForgeDirection> getOutputtingSides() {
        if (this.structure != null) {
            EnumSet<ForgeDirection> set = EnumSet.allOf(ForgeDirection.class);
            set.remove(ForgeDirection.UNKNOWN);
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                if (!((SynchronizedTurbineData)this.structure).locations.contains(Coord4D.get((TileEntity)this).getFromSide(side))) continue;
                set.remove(side);
            }
            return set;
        }
        return EnumSet.noneOf(ForgeDirection.class);
    }

    public EnumSet<ForgeDirection> getConsumingSides() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    public boolean canUpdate() {
        return true;
    }

    @Optional.Method(modid="IC2")
    public void register() {
        TileEntity registered;
        if (!this.field_145850_b.field_72995_K && (registered = EnergyNet.instance.getTileEntity(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) != this) {
            if (registered instanceof IEnergyTile) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)registered));
            } else if (registered == null) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
                this.ic2Registered = true;
            }
        }
    }

    @Optional.Method(modid="IC2")
    public void deregister() {
        TileEntity registered;
        if (!this.field_145850_b.field_72995_K && (registered = EnergyNet.instance.getTileEntity(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) instanceof IEnergyTile) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)registered));
        }
    }

    public double getMaxOutput() {
        return this.structure != null ? ((SynchronizedTurbineData)this.structure).getEnergyCapacity() : 0.0;
    }

    public void onAdded() {
        super.onAdded();
        if (MekanismUtils.useIC2()) {
            this.register();
        }
    }

    public void onChunkUnload() {
        if (MekanismUtils.useIC2()) {
            this.deregister();
        }
        super.onChunkUnload();
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (MekanismUtils.useIC2()) {
            this.deregister();
        }
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (this.getOutputtingSides().contains(from)) {
            double toSend = Math.min(this.getEnergy(), Math.min(this.getMaxOutput(), (double)maxExtract * MekanismConfig.general.FROM_TE));
            if (!simulate) {
                this.setEnergy(this.getEnergy() - toSend);
            }
            return (int)Math.round(toSend * MekanismConfig.general.TO_TE);
        }
        return 0;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return this.structure != null;
    }

    public int getEnergyStored(ForgeDirection from) {
        return (int)Math.round(this.getEnergy() * MekanismConfig.general.TO_TE);
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return (int)Math.round(this.getMaxEnergy() * MekanismConfig.general.TO_TE);
    }

    @Optional.Method(modid="IC2")
    public int getSinkTier() {
        return 4;
    }

    @Optional.Method(modid="IC2")
    public int getSourceTier() {
        return 4;
    }

    @Optional.Method(modid="IC2")
    public void setStored(int energy) {
        this.setEnergy((double)energy * MekanismConfig.general.FROM_IC2);
    }

    @Optional.Method(modid="IC2")
    public int addEnergy(int amount) {
        return (int)Math.round(this.getEnergy() * MekanismConfig.general.TO_IC2);
    }

    @Optional.Method(modid="IC2")
    public boolean isTeleporterCompatible(ForgeDirection side) {
        return this.canOutputTo(side);
    }

    public boolean canOutputTo(ForgeDirection side) {
        return this.getOutputtingSides().contains(side);
    }

    @Optional.Method(modid="IC2")
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return false;
    }

    @Optional.Method(modid="IC2")
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return this.getOutputtingSides().contains(direction) && receiver instanceof IEnergyConductor;
    }

    @Optional.Method(modid="IC2")
    public int getStored() {
        return (int)Math.round(this.getEnergy() * MekanismConfig.general.TO_IC2);
    }

    @Optional.Method(modid="IC2")
    public int getCapacity() {
        return (int)Math.round(this.getMaxEnergy() * MekanismConfig.general.TO_IC2);
    }

    @Optional.Method(modid="IC2")
    public int getOutput() {
        return (int)Math.round(this.getMaxOutput() * MekanismConfig.general.TO_IC2);
    }

    @Optional.Method(modid="IC2")
    public double getDemandedEnergy() {
        return 0.0;
    }

    @Optional.Method(modid="IC2")
    public double getOfferedEnergy() {
        return Math.min(this.getEnergy(), this.getMaxOutput()) * MekanismConfig.general.TO_IC2;
    }

    public boolean canReceiveEnergy(ForgeDirection side) {
        return false;
    }

    @Optional.Method(modid="IC2")
    public double getOutputEnergyUnitsPerTick() {
        return this.getMaxOutput() * MekanismConfig.general.TO_IC2;
    }

    @Optional.Method(modid="IC2")
    public double injectEnergy(ForgeDirection direction, double amount, double voltage) {
        return amount;
    }

    @Optional.Method(modid="IC2")
    public void drawEnergy(double amount) {
        if (this.structure != null) {
            double toDraw = Math.min(amount * MekanismConfig.general.FROM_IC2, this.getMaxOutput());
            this.setEnergy(Math.max(this.getEnergy() - toDraw, 0.0));
        }
    }

    public double transferEnergyToAcceptor(ForgeDirection side, double amount) {
        return 0.0;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] fluidTankInfoArray;
        if (!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) {
            FluidTankInfo[] fluidTankInfoArray2 = new FluidTankInfo[1];
            fluidTankInfoArray = fluidTankInfoArray2;
            fluidTankInfoArray2[0] = this.fluidTank.getInfo();
        } else {
            fluidTankInfoArray = PipeUtils.EMPTY;
        }
        return fluidTankInfoArray;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int filled = this.fluidTank.fill(resource, doFill);
        if (this.structure != null && doFill) {
            ((SynchronizedTurbineData)this.structure).newSteamInput += filled;
        }
        return filled;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.structure != null && ((SynchronizedTurbineData)this.structure).fluidStored != null && resource.getFluid() == ((SynchronizedTurbineData)this.structure).fluidStored.getFluid()) {
            return this.fluidTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.structure != null) {
            return this.fluidTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (fluid == FluidRegistry.getFluid((String)"steam")) {
            return !this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure;
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return !this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure;
    }

    @Override
    public String func_145825_b() {
        return LangUtils.localize((String)"gui.industrialTurbine");
    }
}

