/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;

public class ChemicalPair {
    public GasStack leftGas;
    public GasStack rightGas;

    public ChemicalPair(GasStack left, GasStack right) {
        this.leftGas = left;
        this.rightGas = right;
    }

    public boolean isValid() {
        return this.leftGas != null && this.rightGas != null;
    }

    public boolean meetsInput(ChemicalPair input) {
        return this.meets(input) || this.meets(input.swap());
    }

    public ChemicalPair swap() {
        return new ChemicalPair(this.rightGas, this.leftGas);
    }

    public void draw(GasTank leftTank, GasTank rightTank) {
        if (this.meets(new ChemicalPair(leftTank.getGas(), rightTank.getGas()))) {
            leftTank.draw(this.leftGas.amount, true);
            rightTank.draw(this.rightGas.amount, true);
        } else if (this.meets(new ChemicalPair(rightTank.getGas(), leftTank.getGas()))) {
            leftTank.draw(this.rightGas.amount, true);
            rightTank.draw(this.leftGas.amount, true);
        }
    }

    public boolean containsType(GasStack stack) {
        if (stack == null || stack.amount == 0) {
            return false;
        }
        return stack.isGasEqual(this.leftGas) || stack.isGasEqual(this.rightGas);
    }

    private boolean meets(ChemicalPair input) {
        if (input == null || !input.isValid()) {
            return false;
        }
        if (input.leftGas.getGas() != this.leftGas.getGas() || input.rightGas.getGas() != this.rightGas.getGas()) {
            return false;
        }
        return input.leftGas.amount >= this.leftGas.amount && input.rightGas.amount >= this.rightGas.amount;
    }

    public ChemicalPair copy() {
        return new ChemicalPair(this.leftGas.copy(), this.rightGas.copy());
    }
}

