/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import mekanism.api.StackUtils;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class PressurizedReactants {
    private ItemStack theSolid;
    private FluidStack theFluid;
    private GasStack theGas;

    public PressurizedReactants(ItemStack solid, FluidStack fluid, GasStack gas) {
        this.theSolid = solid;
        this.theFluid = fluid;
        this.theGas = gas;
    }

    public boolean isValid() {
        return this.theSolid != null && this.theFluid != null && this.theGas != null;
    }

    public void use(ItemStack item, FluidTank fluidTank, GasTank gasTank) {
        if (this.meets(new PressurizedReactants(item, fluidTank.getFluid(), gasTank.getGas()))) {
            item.field_77994_a -= this.theSolid.field_77994_a;
            fluidTank.drain(this.theFluid.amount, true);
            gasTank.draw(this.theGas.amount, true);
        }
    }

    public boolean containsType(ItemStack stack) {
        if (stack == null || stack.field_77994_a == 0) {
            return false;
        }
        return StackUtils.equalsWildcard(stack, this.theSolid);
    }

    public boolean containsType(FluidStack stack) {
        if (stack == null || stack.amount == 0) {
            return false;
        }
        return stack.isFluidEqual(this.theFluid);
    }

    public boolean containsType(GasStack stack) {
        if (stack == null || stack.amount == 0) {
            return false;
        }
        return stack.isGasEqual(this.theGas);
    }

    public boolean meetsInput(ItemStack itemStack, FluidStack fluidStack, GasStack gasStack) {
        return this.meets(new PressurizedReactants(itemStack, fluidStack, gasStack));
    }

    private boolean meets(PressurizedReactants input) {
        if (input == null || !input.isValid()) {
            return false;
        }
        if (!(StackUtils.equalsWildcard(input.theSolid, this.theSolid) && input.theFluid.isFluidEqual(this.theFluid) && input.theGas.isGasEqual(this.theGas))) {
            return false;
        }
        return input.theSolid.field_77994_a >= this.theSolid.field_77994_a && input.theFluid.amount >= this.theFluid.amount && input.theGas.amount >= this.theGas.amount;
    }

    public PressurizedReactants copy() {
        return new PressurizedReactants(this.theSolid.func_77946_l(), this.theFluid.copy(), this.theGas.copy());
    }

    public ItemStack getSolid() {
        return this.theSolid;
    }

    public FluidStack getFluid() {
        return this.theFluid;
    }

    public GasStack getGas() {
        return this.theGas;
    }
}

