/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.ListUtils;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.OreGas;
import mekanism.client.gui.GuiConfigurationTab;
import mekanism.client.gui.GuiEnergyInfo;
import mekanism.client.gui.GuiGasGauge;
import mekanism.client.gui.GuiGauge;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.GuiPowerBar;
import mekanism.client.gui.GuiProgress;
import mekanism.client.gui.GuiRedstoneControl;
import mekanism.client.gui.GuiSlot;
import mekanism.client.gui.GuiUpgradeManagement;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerChemicalCrystallizer;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityChemicalCrystallizer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiChemicalCrystallizer
extends GuiMekanism {
    public TileEntityChemicalCrystallizer tileEntity;
    public Gas prevGas;
    public ItemStack renderStack;
    public int stackSwitch = 0;
    public int stackIndex = 0;
    public List<ItemStack> iterStacks = new ArrayList<ItemStack>();

    public GuiChemicalCrystallizer(InventoryPlayer inventory, TileEntityChemicalCrystallizer tentity) {
        super(tentity, new ContainerChemicalCrystallizer(inventory, tentity));
        this.tileEntity = tentity;
        this.guiElements.add(new GuiRedstoneControl(this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalCrystallizer.png")));
        this.guiElements.add(new GuiUpgradeManagement(this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalCrystallizer.png")));
        this.guiElements.add(new GuiPowerBar((IGuiWrapper)this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalCrystallizer.png"), 160, 23));
        this.guiElements.add(new GuiConfigurationTab(this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalCrystallizer.png")));
        this.guiElements.add(new GuiEnergyInfo(new GuiEnergyInfo.IInfoHandler(){

            @Override
            public List<String> getInfo() {
                String multiplier = MekanismUtils.getEnergyDisplay(MekanismUtils.getEnergyPerTick(GuiChemicalCrystallizer.this.tileEntity, GuiChemicalCrystallizer.this.tileEntity.ENERGY_USAGE));
                return ListUtils.asList("Using: " + multiplier + "/t", "Needed: " + MekanismUtils.getEnergyDisplay(GuiChemicalCrystallizer.this.tileEntity.getMaxEnergy() - GuiChemicalCrystallizer.this.tileEntity.getEnergy()));
            }
        }, (IGuiWrapper)this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalCrystallizer.png")));
        this.guiElements.add(new GuiGasGauge(new GuiGasGauge.IGasInfoHandler(){

            @Override
            public GasTank getTank() {
                return GuiChemicalCrystallizer.this.tileEntity.inputTank;
            }
        }, GuiGauge.Type.STANDARD, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalCrystallizer.png"), 5, 4));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.EXTRA, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalCrystallizer.png"), 5, 64).with(GuiSlot.SlotOverlay.PLUS));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.POWER, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalCrystallizer.png"), 154, 4).with(GuiSlot.SlotOverlay.POWER));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.OUTPUT, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalCrystallizer.png"), 130, 56));
        this.guiElements.add(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return GuiChemicalCrystallizer.this.tileEntity.getScaledProgress();
            }
        }, GuiProgress.ProgressBar.LARGE_RIGHT, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalCrystallizer.png"), 51, 60));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146289_q.func_78276_b(this.tileEntity.func_145825_b(), 37, 4, 0x404040);
        if (this.tileEntity.inputTank.getGas() != null) {
            this.field_146289_q.func_78276_b(this.tileEntity.inputTank.getGas().getGas().getLocalizedName(), 29, 15, 52480);
            if (this.tileEntity.inputTank.getGas().getGas() instanceof OreGas) {
                this.field_146289_q.func_78276_b("(" + ((OreGas)this.tileEntity.inputTank.getGas().getGas()).getOreName() + ")", 29, 24, 52480);
            }
        }
        if (this.renderStack != null) {
            try {
                GL11.glPushMatrix();
                GL11.glEnable((int)2896);
                field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), this.renderStack, 131, 14);
                GL11.glDisable((int)2896);
                GL11.glPopMatrix();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalCrystallizer.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        super.func_146976_a(partialTick, mouseX, mouseY);
    }

    private Gas getInputGas() {
        return this.tileEntity.inputTank.getGas() != null ? this.tileEntity.inputTank.getGas().getGas() : null;
    }

    private void resetStacks() {
        this.iterStacks.clear();
        this.renderStack = null;
        this.stackSwitch = 0;
        this.stackIndex = -1;
    }

    @Override
    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        if (button == 0) {
            int xAxis = x - (this.field_146294_l - this.field_146999_f) / 2;
            int yAxis = y - (this.field_146295_m - this.field_147000_g) / 2;
            if (xAxis > 24 && xAxis < 42 && yAxis > 56 && yAxis < 64) {
                ArrayList<Integer> data = new ArrayList<Integer>();
                data.add(0);
                Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
                SoundHandler.playSound("gui.button.press");
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.prevGas != this.getInputGas()) {
            this.prevGas = this.getInputGas();
            boolean reset = false;
            if (this.prevGas == null || !(this.prevGas instanceof OreGas) || !((OreGas)this.prevGas).isClean()) {
                reset = true;
                this.resetStacks();
            }
            if (!reset) {
                OreGas gas = (OreGas)this.prevGas;
                String oreDictName = "ore" + gas.getName().substring(5);
                this.updateStackList(oreDictName);
            }
        }
        if (this.stackSwitch > 0) {
            --this.stackSwitch;
        }
        if (this.stackSwitch == 0 && this.iterStacks != null && this.iterStacks.size() > 0) {
            this.stackSwitch = 20;
            if (this.stackIndex == -1 || this.stackIndex == this.iterStacks.size() - 1) {
                this.stackIndex = 0;
            } else if (this.stackIndex < this.iterStacks.size() - 1) {
                ++this.stackIndex;
            }
            this.renderStack = this.iterStacks.get(this.stackIndex);
        } else if (this.iterStacks != null && this.iterStacks.size() == 0) {
            this.renderStack = null;
        }
    }

    private void updateStackList(String oreName) {
        if (this.iterStacks == null) {
            this.iterStacks = new ArrayList<ItemStack>();
        } else {
            this.iterStacks.clear();
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (String s : OreDictionary.getOreNames()) {
            if (oreName.equals(s) || oreName.equals("*")) {
                keys.add(s);
                continue;
            }
            if (oreName.endsWith("*") && !oreName.startsWith("*")) {
                if (!s.startsWith(oreName.substring(0, oreName.length() - 1))) continue;
                keys.add(s);
                continue;
            }
            if (oreName.startsWith("*") && !oreName.endsWith("*")) {
                if (!s.endsWith(oreName.substring(1))) continue;
                keys.add(s);
                continue;
            }
            if (!oreName.startsWith("*") || !oreName.endsWith("*") || !s.contains(oreName.substring(1, oreName.length() - 1))) continue;
            keys.add(s);
        }
        for (String key : keys) {
            for (ItemStack stack : OreDictionary.getOres((String)key)) {
                ItemStack toAdd = stack.func_77946_l();
                if (this.iterStacks.contains(stack) || !(toAdd.func_77973_b() instanceof ItemBlock)) continue;
                this.iterStacks.add(stack.func_77946_l());
            }
        }
        this.stackSwitch = 0;
        this.stackIndex = -1;
    }
}

