/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import codechicken.lib.vec.Rectangle4i;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mekanism.client.gui.IGuiWrapper;
import mekanism.common.ObfuscatedNames;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public abstract class GuiElement {
    protected static Minecraft mc = Minecraft.func_71410_x();
    protected ResourceLocation RESOURCE;
    public IGuiWrapper guiObj;
    public ResourceLocation defaultLocation;

    public GuiElement(ResourceLocation resource, IGuiWrapper gui, ResourceLocation def) {
        this.RESOURCE = resource;
        this.guiObj = gui;
        this.defaultLocation = def;
    }

    protected void displayTooltip(String s, int xAxis, int yAxis) {
        this.guiObj.displayTooltip(s, xAxis, yAxis);
    }

    protected void displayTooltips(List<String> list, int xAxis, int yAxis) {
        this.guiObj.displayTooltips(list, xAxis, yAxis);
    }

    protected void offsetX(int xSize) {
        if (this.guiObj instanceof GuiContainer) {
            try {
                int size = (Integer)MekanismUtils.getPrivateValue(this.guiObj, GuiContainer.class, ObfuscatedNames.GuiContainer_xSize);
                MekanismUtils.setPrivateValue(this.guiObj, size + xSize, GuiContainer.class, ObfuscatedNames.GuiContainer_xSize);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void offsetY(int ySize) {
        if (this.guiObj instanceof GuiContainer) {
            try {
                int size = (Integer)MekanismUtils.getPrivateValue(this.guiObj, GuiContainer.class, ObfuscatedNames.GuiContainer_ySize);
                MekanismUtils.setPrivateValue(this.guiObj, size + ySize, GuiContainer.class, ObfuscatedNames.GuiContainer_ySize);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void offsetLeft(int guiLeft) {
        if (this.guiObj instanceof GuiContainer) {
            try {
                int left = (Integer)MekanismUtils.getPrivateValue(this.guiObj, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
                System.out.println(left + " " + guiLeft);
                MekanismUtils.setPrivateValue(this.guiObj, left + guiLeft, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void offsetTop(int guiTop) {
        if (this.guiObj instanceof GuiContainer) {
            try {
                int top = (Integer)MekanismUtils.getPrivateValue(this.guiObj, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
                MekanismUtils.setPrivateValue(this.guiObj, top + guiTop, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected FontRenderer getFontRenderer() {
        return this.guiObj.getFont();
    }

    public abstract Rectangle4i getBounds(int var1, int var2);

    public abstract void renderBackground(int var1, int var2, int var3, int var4);

    public abstract void renderForeground(int var1, int var2);

    public abstract void preMouseClicked(int var1, int var2, int var3);

    public abstract void mouseClicked(int var1, int var2, int var3);
}

