/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import codechicken.lib.vec.Rectangle4i;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.gui.GuiGauge;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public class GuiEnergyGauge
extends GuiGauge {
    IEnergyInfoHandler infoHandler;

    public GuiEnergyGauge(IEnergyInfoHandler handler, GuiGauge.Type type, IGuiWrapper gui, ResourceLocation def, int x, int y) {
        super(type, gui, def, x, y);
        this.infoHandler = handler;
    }

    @Override
    public Rectangle4i getBounds(int guiWidth, int guiHeight) {
        return new Rectangle4i(guiWidth - 26, guiHeight + 6, 26, 26);
    }

    @Override
    public int getScaledLevel() {
        return (int)(this.infoHandler.getEnergyStorage().getEnergy() * (double)(this.height - 2) / this.infoHandler.getEnergyStorage().getMaxEnergy());
    }

    @Override
    public IIcon getIcon() {
        return MekanismRenderer.energyIcon;
    }

    @Override
    public String getTooltipText() {
        return this.infoHandler.getEnergyStorage().getEnergy() > 0.0 ? MekanismUtils.getEnergyDisplay(this.infoHandler.getEnergyStorage().getEnergy()) : MekanismUtils.localize("gui.empty");
    }

    public static interface IEnergyInfoHandler {
        public IStrictEnergyStorage getEnergyStorage();
    }
}

