/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import mekanism.client.gui.GuiGauge;
import mekanism.client.gui.IGuiWrapper;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidTank;

public class GuiFluidGauge
extends GuiGauge<Fluid> {
    IFluidInfoHandler infoHandler;

    public GuiFluidGauge(IFluidInfoHandler handler, GuiGauge.Type type, IGuiWrapper gui, ResourceLocation def, int x, int y) {
        super(type, gui, def, x, y);
        this.infoHandler = handler;
    }

    public static GuiFluidGauge getDummy(GuiGauge.Type type, IGuiWrapper gui, ResourceLocation def, int x, int y) {
        GuiFluidGauge gauge = new GuiFluidGauge(null, type, gui, def, x, y);
        gauge.dummy = true;
        return gauge;
    }

    @Override
    public int getScaledLevel() {
        if (this.dummy) {
            return this.height - 2;
        }
        return this.infoHandler.getTank().getFluid() != null ? this.infoHandler.getTank().getFluidAmount() * (this.height - 2) / this.infoHandler.getTank().getCapacity() : 0;
    }

    @Override
    public IIcon getIcon() {
        if (this.dummy) {
            return ((Fluid)this.dummyType).getIcon();
        }
        return this.infoHandler.getTank().getFluid().getFluid().getIcon();
    }

    @Override
    public String getTooltipText() {
        if (this.dummy) {
            return ((Fluid)this.dummyType).getLocalizedName();
        }
        return this.infoHandler.getTank().getFluid() != null ? this.infoHandler.getTank().getFluid().getFluid().getLocalizedName(this.infoHandler.getTank().getFluid()) + ": " + this.infoHandler.getTank().getFluidAmount() + "mB" : MekanismUtils.localize("gui.empty");
    }

    public static interface IFluidInfoHandler {
        public FluidTank getTank();
    }
}

