/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import mekanism.api.gas.Gas;
import mekanism.api.gas.GasTank;
import mekanism.client.gui.GuiGauge;
import mekanism.client.gui.IGuiWrapper;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public class GuiGasGauge
extends GuiGauge<Gas> {
    IGasInfoHandler infoHandler;

    public GuiGasGauge(IGasInfoHandler handler, GuiGauge.Type type, IGuiWrapper gui, ResourceLocation def, int x, int y) {
        super(type, gui, def, x, y);
        this.infoHandler = handler;
    }

    public static GuiGasGauge getDummy(GuiGauge.Type type, IGuiWrapper gui, ResourceLocation def, int x, int y) {
        GuiGasGauge gauge = new GuiGasGauge(null, type, gui, def, x, y);
        gauge.dummy = true;
        return gauge;
    }

    @Override
    public int getScaledLevel() {
        if (this.dummy) {
            return this.height - 2;
        }
        return this.infoHandler.getTank().getGas() != null ? this.infoHandler.getTank().getStored() * (this.height - 2) / this.infoHandler.getTank().getMaxGas() : 0;
    }

    @Override
    public IIcon getIcon() {
        if (this.dummy) {
            return ((Gas)this.dummyType).getIcon();
        }
        return this.infoHandler.getTank() != null && this.infoHandler.getTank().getGas() != null && this.infoHandler.getTank().getGas().getGas() != null ? this.infoHandler.getTank().getGas().getGas().getIcon() : null;
    }

    @Override
    public String getTooltipText() {
        if (this.dummy) {
            return ((Gas)this.dummyType).getLocalizedName();
        }
        return this.infoHandler.getTank().getGas() != null ? this.infoHandler.getTank().getGas().getGas().getLocalizedName() + ": " + this.infoHandler.getTank().getStored() : MekanismUtils.localize("gui.empty");
    }

    public static interface IGasInfoHandler {
        public GasTank getTank();
    }
}

