/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import codechicken.lib.vec.Rectangle4i;
import mekanism.client.gui.GuiElement;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public abstract class GuiGauge<T>
extends GuiElement {
    protected int xLocation;
    protected int yLocation;
    protected int width;
    protected int height;
    protected int number;
    protected boolean dummy;
    protected T dummyType;

    public GuiGauge(Type type, IGuiWrapper gui, ResourceLocation def, int x, int y) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, type.textureLocation), gui, def);
        this.xLocation = x;
        this.yLocation = y;
        this.width = type.width;
        this.height = type.height;
        this.number = type.number;
    }

    public abstract int getScaledLevel();

    public abstract IIcon getIcon();

    public abstract String getTooltipText();

    @Override
    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        GuiGauge.mc.field_71446_o.func_110577_a(this.RESOURCE);
        this.guiObj.drawTexturedRect(guiWidth + this.xLocation, guiHeight + this.yLocation, 0, 0, this.width, this.height);
        if (!this.dummy) {
            this.renderScale(xAxis, yAxis, guiWidth, guiHeight);
        }
        GuiGauge.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    public void renderScale(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        if (this.getScaledLevel() == 0 || this.getIcon() == null) {
            this.guiObj.drawTexturedRect(guiWidth + this.xLocation, guiHeight + this.yLocation, this.width, 0, this.width, this.height);
            return;
        }
        int scale = this.getScaledLevel();
        int start = 0;
        while (scale > 0) {
            int renderRemaining = 0;
            if (scale > 16) {
                renderRemaining = 16;
                scale -= 16;
            } else {
                renderRemaining = scale;
                scale = 0;
            }
            GuiGauge.mc.field_71446_o.func_110577_a(MekanismRenderer.getBlocksTexture());
            for (int i = 0; i < this.number; ++i) {
                this.guiObj.drawTexturedRectFromIcon(guiWidth + this.xLocation + 16 * i + 1, guiHeight + this.yLocation + this.height - renderRemaining - start - 1, this.getIcon(), 16, renderRemaining);
            }
            start += 16;
            if (renderRemaining != 0 && scale != 0) continue;
            break;
        }
        GuiGauge.mc.field_71446_o.func_110577_a(this.RESOURCE);
        this.guiObj.drawTexturedRect(guiWidth + this.xLocation, guiHeight + this.yLocation, this.width, 0, this.width, this.height);
    }

    @Override
    public void renderForeground(int xAxis, int yAxis) {
        if (xAxis >= this.xLocation + 1 && xAxis <= this.xLocation + this.width - 1 && yAxis >= this.yLocation + 1 && yAxis <= this.yLocation + this.height - 1) {
            this.guiObj.displayTooltip(this.getTooltipText(), xAxis, yAxis);
        }
    }

    @Override
    public void preMouseClicked(int xAxis, int yAxis, int button) {
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
    }

    public void setDummyType(T type) {
        this.dummyType = type;
    }

    @Override
    public Rectangle4i getBounds(int guiWidth, int guiHeight) {
        return new Rectangle4i(guiWidth + this.xLocation, guiHeight + this.yLocation, this.width, this.height);
    }

    public static enum Type {
        STANDARD(18, 60, 1, "GuiGaugeStandard.png"),
        WIDE(66, 50, 4, "GuiGaugeWide.png"),
        SMALL(18, 30, 1, "GuiGaugeSmall.png");

        public int width;
        public int height;
        public int number;
        public String textureLocation;

        private Type(int w, int h, int n2, String t) {
            this.width = w;
            this.height = h;
            this.number = n2;
            this.textureLocation = t;
        }
    }
}

