/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.GuiRedstoneControl;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.OreDictCache;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.network.PacketLogisticalSorterGui;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.transporter.TItemStackFilter;
import mekanism.common.transporter.TMaterialFilter;
import mekanism.common.transporter.TModIDFilter;
import mekanism.common.transporter.TOreDictFilter;
import mekanism.common.transporter.TransporterFilter;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiLogisticalSorter
extends GuiMekanism {
    public TileEntityLogisticalSorter tileEntity;
    public boolean isDragging = false;
    public int dragOffset = 0;
    public int stackSwitch = 0;
    public Map<TOreDictFilter, StackData> oreDictStacks = new HashMap<TOreDictFilter, StackData>();
    public Map<TModIDFilter, StackData> modIDStacks = new HashMap<TModIDFilter, StackData>();
    public float scroll;

    public GuiLogisticalSorter(EntityPlayer player, TileEntityLogisticalSorter tentity) {
        super(new ContainerNull(player, tentity));
        this.tileEntity = tentity;
        this.guiElements.add(new GuiRedstoneControl(this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiLogisticalSorter.png")));
    }

    public int getScroll() {
        return Math.max(Math.min((int)(this.scroll * 123.0f), 123), 0);
    }

    public int getFilterIndex() {
        if (this.tileEntity.filters.size() <= 4) {
            return 0;
        }
        return (int)((float)this.tileEntity.filters.size() * this.scroll - 4.0f / (float)this.tileEntity.filters.size() * this.scroll);
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.stackSwitch > 0) {
            --this.stackSwitch;
        }
        if (this.stackSwitch == 0) {
            for (Map.Entry<TOreDictFilter, StackData> entry : this.oreDictStacks.entrySet()) {
                if (entry.getValue().iterStacks == null || entry.getValue().iterStacks.size() <= 0) continue;
                if (entry.getValue().stackIndex == -1 || entry.getValue().stackIndex == entry.getValue().iterStacks.size() - 1) {
                    entry.getValue().stackIndex = 0;
                } else if (entry.getValue().stackIndex < entry.getValue().iterStacks.size() - 1) {
                    ++entry.getValue().stackIndex;
                }
                entry.getValue().renderStack = entry.getValue().iterStacks.get(entry.getValue().stackIndex);
            }
            for (Map.Entry<TransporterFilter, StackData> entry : this.modIDStacks.entrySet()) {
                if (entry.getValue().iterStacks == null || entry.getValue().iterStacks.size() <= 0) continue;
                if (entry.getValue().stackIndex == -1 || entry.getValue().stackIndex == entry.getValue().iterStacks.size() - 1) {
                    entry.getValue().stackIndex = 0;
                } else if (entry.getValue().stackIndex < entry.getValue().iterStacks.size() - 1) {
                    ++entry.getValue().stackIndex;
                }
                entry.getValue().renderStack = entry.getValue().iterStacks.get(entry.getValue().stackIndex);
            }
            this.stackSwitch = 20;
        } else {
            for (Map.Entry<TOreDictFilter, StackData> entry : this.oreDictStacks.entrySet()) {
                if (entry.getValue().iterStacks == null || entry.getValue().iterStacks.size() != 0) continue;
                entry.getValue().renderStack = null;
            }
            for (Map.Entry<TransporterFilter, StackData> entry : this.modIDStacks.entrySet()) {
                if (entry.getValue().iterStacks == null || entry.getValue().iterStacks.size() != 0) continue;
                entry.getValue().renderStack = null;
            }
        }
        HashSet<TOreDictFilter> oreDictFilters = new HashSet<TOreDictFilter>();
        HashSet<TModIDFilter> hashSet = new HashSet<TModIDFilter>();
        for (int i = 0; i < 4; ++i) {
            if (this.tileEntity.filters.get(this.getFilterIndex() + i) instanceof TOreDictFilter) {
                oreDictFilters.add((TOreDictFilter)this.tileEntity.filters.get(this.getFilterIndex() + i));
                continue;
            }
            if (!(this.tileEntity.filters.get(this.getFilterIndex() + i) instanceof TModIDFilter)) continue;
            hashSet.add((TModIDFilter)this.tileEntity.filters.get(this.getFilterIndex() + i));
        }
        for (TransporterFilter filter : this.tileEntity.filters) {
            if (filter instanceof TOreDictFilter && !oreDictFilters.contains(filter)) {
                if (!this.oreDictStacks.containsKey(filter)) continue;
                this.oreDictStacks.remove(filter);
                continue;
            }
            if (!(filter instanceof TModIDFilter) || hashSet.contains(filter) || !this.modIDStacks.containsKey(filter)) continue;
            this.modIDStacks.remove(filter);
        }
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int button) {
        super.func_73864_a(mouseX, mouseY, button);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (button == 0) {
            if (xAxis >= 154 && xAxis <= 166 && yAxis >= this.getScroll() + 18 && yAxis <= this.getScroll() + 18 + 15) {
                this.dragOffset = yAxis - (this.getScroll() + 18);
                this.isDragging = true;
            }
            for (int i = 0; i < 4; ++i) {
                if (this.tileEntity.filters.get(this.getFilterIndex() + i) == null) continue;
                int yStart = i * 29 + 18;
                if (xAxis < 56 || xAxis > 152 || yAxis < yStart || yAxis > yStart + 29) continue;
                TransporterFilter filter = this.tileEntity.filters.get(this.getFilterIndex() + i);
                if (filter instanceof TItemStackFilter) {
                    SoundHandler.playSound("gui.button.press");
                    Mekanism.packetHandler.sendToServer(new PacketLogisticalSorterGui.LogisticalSorterGuiMessage(PacketLogisticalSorterGui.SorterGuiPacket.SERVER_INDEX, Coord4D.get(this.tileEntity), 1, this.getFilterIndex() + i, 0));
                    continue;
                }
                if (filter instanceof TOreDictFilter) {
                    SoundHandler.playSound("gui.button.press");
                    Mekanism.packetHandler.sendToServer(new PacketLogisticalSorterGui.LogisticalSorterGuiMessage(PacketLogisticalSorterGui.SorterGuiPacket.SERVER_INDEX, Coord4D.get(this.tileEntity), 2, this.getFilterIndex() + i, 0));
                    continue;
                }
                if (filter instanceof TMaterialFilter) {
                    SoundHandler.playSound("gui.button.press");
                    Mekanism.packetHandler.sendToServer(new PacketLogisticalSorterGui.LogisticalSorterGuiMessage(PacketLogisticalSorterGui.SorterGuiPacket.SERVER_INDEX, Coord4D.get(this.tileEntity), 3, this.getFilterIndex() + i, 0));
                    continue;
                }
                if (!(filter instanceof TModIDFilter)) continue;
                SoundHandler.playSound("gui.button.press");
                Mekanism.packetHandler.sendToServer(new PacketLogisticalSorterGui.LogisticalSorterGuiMessage(PacketLogisticalSorterGui.SorterGuiPacket.SERVER_INDEX, Coord4D.get(this.tileEntity), 5, this.getFilterIndex() + i, 0));
            }
            if (xAxis >= 12 && xAxis <= 26 && yAxis >= 110 && yAxis <= 124) {
                ArrayList<Integer> data = new ArrayList<Integer>();
                data.add(1);
                Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
                SoundHandler.playSound("gui.button.press");
            }
            if (xAxis >= 12 && xAxis <= 26 && yAxis >= 84 && yAxis <= 98) {
                ArrayList<Integer> data = new ArrayList<Integer>();
                data.add(2);
                Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
                SoundHandler.playSound("gui.button.press");
            }
        }
        if (Keyboard.isKeyDown((int)42) && button == 0) {
            button = 2;
        }
        if (xAxis >= 13 && xAxis <= 29 && yAxis >= 137 && yAxis <= 153) {
            ArrayList<Integer> data = new ArrayList<Integer>();
            data.add(0);
            data.add(button);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
            SoundHandler.playSound("mekanism:etc.Ding");
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int button, long ticks) {
        super.func_146273_a(mouseX, mouseY, button, ticks);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (this.isDragging) {
            this.scroll = Math.min(Math.max((float)(yAxis - 18 - this.dragOffset) / 123.0f, 0.0f), 1.0f);
        }
    }

    protected void func_146286_b(int x, int y, int type) {
        super.func_146286_b(x, y, type);
        if (type == 0 && this.isDragging) {
            this.dragOffset = 0;
            this.isDragging = false;
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, guiWidth + 56, guiHeight + 136, 96, 20, MekanismUtils.localize("gui.newFilter")));
    }

    protected void func_146284_a(GuiButton guibutton) {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == 0) {
            Mekanism.packetHandler.sendToServer(new PacketLogisticalSorterGui.LogisticalSorterGuiMessage(PacketLogisticalSorterGui.SorterGuiPacket.SERVER, Coord4D.get(this.tileEntity), 4, 0, 0));
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146289_q.func_78276_b(this.tileEntity.func_145825_b(), 43, 6, 0x404040);
        this.field_146289_q.func_78276_b(MekanismUtils.localize("gui.filters") + ":", 11, 19, 52480);
        this.field_146289_q.func_78276_b("T: " + this.tileEntity.filters.size(), 11, 28, 52480);
        this.field_146289_q.func_78276_b("RR:", 12, 74, 52480);
        this.field_146289_q.func_78276_b(MekanismUtils.localize("gui." + (this.tileEntity.roundRobin ? "on" : "off")), 27, 86, 52480);
        this.field_146289_q.func_78276_b(MekanismUtils.localize("gui.logisticalSorter.auto") + ":", 12, 100, 52480);
        this.field_146289_q.func_78276_b(MekanismUtils.localize("gui." + (this.tileEntity.autoEject ? "on" : "off")), 27, 112, 52480);
        this.field_146289_q.func_78276_b(MekanismUtils.localize("gui.logisticalSorter.default") + ":", 12, 126, 52480);
        for (int i = 0; i < 4; ++i) {
            TransporterFilter itemFilter;
            if (this.tileEntity.filters.get(this.getFilterIndex() + i) == null) continue;
            TransporterFilter filter = this.tileEntity.filters.get(this.getFilterIndex() + i);
            int yStart = i * 29 + 18;
            if (filter instanceof TItemStackFilter) {
                itemFilter = (TItemStackFilter)filter;
                if (itemFilter.itemType != null) {
                    GL11.glPushMatrix();
                    GL11.glEnable((int)2896);
                    field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), itemFilter.itemType, 59, yStart + 3);
                    GL11.glDisable((int)2896);
                    GL11.glPopMatrix();
                }
                this.field_146289_q.func_78276_b(MekanismUtils.localize("gui.itemFilter"), 78, yStart + 2, 0x404040);
                this.field_146289_q.func_78276_b(filter.color != null ? filter.color.getName() : MekanismUtils.localize("gui.none"), 78, yStart + 11, 0x404040);
                continue;
            }
            if (filter instanceof TOreDictFilter) {
                TOreDictFilter oreFilter = (TOreDictFilter)filter;
                if (!this.oreDictStacks.containsKey(oreFilter)) {
                    this.updateStackList(oreFilter);
                }
                if (this.oreDictStacks.get((Object)filter).renderStack != null) {
                    try {
                        GL11.glPushMatrix();
                        GL11.glEnable((int)2896);
                        field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), this.oreDictStacks.get((Object)filter).renderStack, 59, yStart + 3);
                        GL11.glDisable((int)2896);
                        GL11.glPopMatrix();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                this.field_146289_q.func_78276_b(MekanismUtils.localize("gui.oredictFilter"), 78, yStart + 2, 0x404040);
                this.field_146289_q.func_78276_b(filter.color != null ? filter.color.getName() : MekanismUtils.localize("gui.none"), 78, yStart + 11, 0x404040);
                continue;
            }
            if (filter instanceof TMaterialFilter) {
                itemFilter = (TMaterialFilter)filter;
                if (((TMaterialFilter)itemFilter).materialItem != null) {
                    GL11.glPushMatrix();
                    GL11.glEnable((int)2896);
                    field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), ((TMaterialFilter)itemFilter).materialItem, 59, yStart + 3);
                    GL11.glDisable((int)2896);
                    GL11.glPopMatrix();
                }
                this.field_146289_q.func_78276_b(MekanismUtils.localize("gui.materialFilter"), 78, yStart + 2, 0x404040);
                this.field_146289_q.func_78276_b(filter.color != null ? filter.color.getName() : MekanismUtils.localize("gui.none"), 78, yStart + 11, 0x404040);
                continue;
            }
            if (!(filter instanceof TModIDFilter)) continue;
            TModIDFilter modFilter = (TModIDFilter)filter;
            if (!this.modIDStacks.containsKey(modFilter)) {
                this.updateStackList(modFilter);
            }
            if (this.modIDStacks.get((Object)filter).renderStack != null) {
                try {
                    GL11.glPushMatrix();
                    GL11.glEnable((int)2896);
                    field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), this.modIDStacks.get((Object)filter).renderStack, 59, yStart + 3);
                    GL11.glDisable((int)2896);
                    GL11.glPopMatrix();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.field_146289_q.func_78276_b(MekanismUtils.localize("gui.modIDFilter"), 78, yStart + 2, 0x404040);
            this.field_146289_q.func_78276_b(filter.color != null ? filter.color.getName() : MekanismUtils.localize("gui.none"), 78, yStart + 11, 0x404040);
        }
        if (this.tileEntity.color != null) {
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)32826);
            this.field_146297_k.func_110434_K().func_110577_a(MekanismRenderer.getBlocksTexture());
            field_146296_j.func_94149_a(13, 137, MekanismRenderer.getColorIcon(this.tileEntity.color), 16, 16);
            GL11.glDisable((int)2896);
            GL11.glPopMatrix();
        }
        if (xAxis >= 13 && xAxis <= 29 && yAxis >= 137 && yAxis <= 153) {
            if (this.tileEntity.color != null) {
                this.func_146279_a(this.tileEntity.color.getName(), xAxis, yAxis);
            } else {
                this.func_146279_a(MekanismUtils.localize("gui.none"), xAxis, yAxis);
            }
        }
        if (xAxis >= 12 && xAxis <= 26 && yAxis >= 110 && yAxis <= 124) {
            this.func_146279_a(MekanismUtils.localize("gui.autoEject"), xAxis, yAxis);
        }
        if (xAxis >= 12 && xAxis <= 26 && yAxis >= 84 && yAxis <= 98) {
            this.func_146279_a(MekanismUtils.localize("gui.logisticalSorter.roundRobin"), xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        super.func_146976_a(partialTick, mouseX, mouseY);
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiLogisticalSorter.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_73729_b(guiWidth + 154, guiHeight + 18 + this.getScroll(), 232, 0, 12, 15);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        for (int i = 0; i < 4; ++i) {
            boolean mouseOver;
            if (this.tileEntity.filters.get(this.getFilterIndex() + i) == null) continue;
            TransporterFilter filter = this.tileEntity.filters.get(this.getFilterIndex() + i);
            int yStart = i * 29 + 18;
            boolean bl = mouseOver = xAxis >= 56 && xAxis <= 152 && yAxis >= yStart && yAxis <= yStart + 29;
            if (filter instanceof TItemStackFilter) {
                MekanismRenderer.color(EnumColor.INDIGO, 1.0f, 2.5f);
            } else if (filter instanceof TOreDictFilter) {
                MekanismRenderer.color(EnumColor.BRIGHT_GREEN, 1.0f, 2.5f);
            } else if (filter instanceof TMaterialFilter) {
                MekanismRenderer.color(EnumColor.PURPLE, 1.0f, 4.0f);
            } else if (filter instanceof TModIDFilter) {
                MekanismRenderer.color(EnumColor.PINK, 1.0f, 2.5f);
            }
            this.func_73729_b(guiWidth + 56, guiHeight + yStart, mouseOver ? 0 : 96, 166, 96, 29);
            MekanismRenderer.resetColor();
        }
        if (xAxis >= 12 && xAxis <= 26 && yAxis >= 110 && yAxis <= 124) {
            this.func_73729_b(guiWidth + 12, guiHeight + 110, 176, 0, 14, 14);
        } else {
            this.func_73729_b(guiWidth + 12, guiHeight + 110, 176, 14, 14, 14);
        }
        if (xAxis >= 12 && xAxis <= 26 && yAxis >= 84 && yAxis <= 98) {
            this.func_73729_b(guiWidth + 12, guiHeight + 84, 190, 0, 14, 14);
        } else {
            this.func_73729_b(guiWidth + 12, guiHeight + 84, 190, 14, 14, 14);
        }
    }

    private void updateStackList(TOreDictFilter filter) {
        if (!this.oreDictStacks.containsKey(filter)) {
            this.oreDictStacks.put(filter, new StackData());
        }
        this.oreDictStacks.get((Object)filter).iterStacks = OreDictCache.getOreDictStacks(filter.oreDictName, false);
        this.stackSwitch = 0;
        this.func_73876_c();
        this.oreDictStacks.get((Object)filter).stackIndex = -1;
    }

    private void updateStackList(TModIDFilter filter) {
        if (!this.modIDStacks.containsKey(filter)) {
            this.modIDStacks.put(filter, new StackData());
        }
        this.modIDStacks.get((Object)filter).iterStacks = OreDictCache.getModIDStacks(filter.modID, false);
        this.stackSwitch = 0;
        this.func_73876_c();
        this.modIDStacks.get((Object)filter).stackIndex = -1;
    }

    public static class StackData {
        public List<ItemStack> iterStacks;
        public int stackIndex;
        public ItemStack renderStack;
    }
}

