/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mekanism.client.gui.GuiElement;
import mekanism.client.gui.IGuiWrapper;
import mekanism.common.IInvConfiguration;
import mekanism.common.SideData;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.tile.TileEntityContainerBlock;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public abstract class GuiMekanism
extends GuiContainer
implements IGuiWrapper {
    public Set<GuiElement> guiElements = new HashSet<GuiElement>();
    private TileEntityContainerBlock tileEntity;

    public GuiMekanism(Container container) {
        super(container);
    }

    public GuiMekanism(TileEntityContainerBlock tile, Container container) {
        super(container);
        this.tileEntity = tile;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        for (GuiElement element : this.guiElements) {
            element.renderForeground(xAxis, yAxis);
        }
        if (this.tileEntity instanceof IInvConfiguration) {
            SideData data;
            ItemStack stack;
            Slot hovering = null;
            for (int i = 0; i < this.field_147002_h.field_75151_b.size(); ++i) {
                Slot slot = (Slot)this.field_147002_h.field_75151_b.get(i);
                if (!this.func_146981_a(slot, mouseX, mouseY)) continue;
                hovering = slot;
                break;
            }
            if ((stack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o()) != null && stack.func_77973_b() instanceof ItemConfigurator && hovering != null && (data = this.getFromSlot(hovering)) != null) {
                this.func_146279_a(data.color.getName(), xAxis, yAxis);
            }
        }
    }

    private SideData getFromSlot(Slot slot) {
        if (slot.field_75222_d < this.tileEntity.func_70302_i_()) {
            IInvConfiguration config = (IInvConfiguration)((Object)this.tileEntity);
            for (SideData data : config.getSideData()) {
                for (int id : data.availableSlots) {
                    if (id != slot.getSlotIndex()) continue;
                    return data;
                }
            }
        }
        return null;
    }

    protected boolean func_146981_a(Slot slot, int mouseX, int mouseY) {
        return this.func_146978_c(slot.field_75223_e, slot.field_75221_f, 16, 16, mouseX, mouseY);
    }

    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        int xAxis = mouseX - guiWidth;
        int yAxis = mouseY - guiHeight;
        for (GuiElement element : this.guiElements) {
            element.renderBackground(xAxis, yAxis, guiWidth, guiHeight);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) {
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        for (GuiElement element : this.guiElements) {
            element.preMouseClicked(xAxis, yAxis, button);
        }
        super.func_73864_a(mouseX, mouseY, button);
        for (GuiElement element : this.guiElements) {
            element.mouseClicked(xAxis, yAxis, button);
        }
    }

    protected void func_146279_a(String text, int x, int y) {
        this.func_146283_a(Arrays.asList(text), x, y);
    }

    protected void func_146283_a(List list, int x, int y) {
        GL11.glPushAttrib((int)8256);
        super.func_146283_a(list, x, y);
        GL11.glPopAttrib();
    }

    @Override
    public void drawTexturedRect(int x, int y, int u, int v, int w, int h) {
        this.func_73729_b(x, y, u, v, w, h);
    }

    @Override
    public void drawTexturedRectFromIcon(int x, int y, IIcon icon, int w, int h) {
        this.func_94065_a(x, y, icon, w, h);
    }

    @Override
    public void displayTooltip(String s, int x, int y) {
        this.func_146279_a(s, x, y);
    }

    @Override
    public void displayTooltips(List<String> list, int xAxis, int yAxis) {
        this.func_146283_a(list, xAxis, yAxis);
    }

    @Override
    public FontRenderer getFont() {
        return this.field_146289_q;
    }

    public void handleMouse(Slot slot, int slotIndex, int button, int modifier) {
        this.func_146984_a(slot, slotIndex, button, modifier);
    }

    public int getXPos() {
        return (this.field_146294_l - this.field_146999_f) / 2;
    }

    public int getYPos() {
        return (this.field_146295_m - this.field_147000_g) / 2;
    }

    protected FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }
}

