/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.gas.GasStack;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerSalinationController;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntitySalinationController;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiSalinationController
extends GuiMekanism {
    public TileEntitySalinationController tileEntity;

    public GuiSalinationController(InventoryPlayer inventory, TileEntitySalinationController tentity) {
        super(tentity, new ContainerSalinationController(inventory, tentity));
        this.tileEntity = tentity;
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146289_q.func_78276_b(MekanismUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 4, 0x404040);
        this.field_146289_q.func_78276_b(this.getStruct(), 50, 21, 52480);
        this.field_146289_q.func_78276_b("Height: " + this.tileEntity.height, 50, 30, 52480);
        this.field_146289_q.func_78276_b("Mult: " + this.getTempMult(), 50, 39, 52480);
        this.field_146289_q.func_78276_b("Max: " + this.getMaxTemp(), 50, 48, 52480);
        if (xAxis >= 7 && xAxis <= 23 && yAxis >= 14 && yAxis <= 72) {
            this.func_146279_a(this.tileEntity.waterTank.getFluid() != null ? this.tileEntity.waterTank.getFluid().getFluid().getLocalizedName() + ": " + this.tileEntity.waterTank.getFluidAmount() : MekanismUtils.localize("gui.empty"), xAxis, yAxis);
        }
        if (xAxis >= 153 && xAxis <= 169 && yAxis >= 14 && yAxis <= 72) {
            this.func_146279_a(this.tileEntity.brineTank.getFluid() != null ? this.tileEntity.brineTank.getFluid().getFluid().getLocalizedName() + ": " + this.tileEntity.brineTank.getFluidAmount() : MekanismUtils.localize("gui.empty"), xAxis, yAxis);
        }
        if (xAxis >= 49 && xAxis <= 127 && yAxis >= 64 && yAxis <= 72) {
            this.func_146279_a(this.getTemp(), xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    private String getStruct() {
        if (this.tileEntity.structured) {
            return "Structured";
        }
        if (!this.tileEntity.structured) {
            if (this.tileEntity.controllerConflict) {
                return "Conflict";
            }
            return "Incomplete";
        }
        return null;
    }

    private String getTemp() {
        float temp = (float)Math.round(this.tileEntity.getTemperature() * 200.0f * 10.0f) / 10.0f;
        return temp + " F";
    }

    private String getMaxTemp() {
        float temp = (float)Math.round(this.tileEntity.getMaxTemperature() * 200.0f * 10.0f) / 10.0f;
        return temp + " F";
    }

    private String getTempMult() {
        float temp = (float)Math.round(this.tileEntity.getTempMultiplier() * 10.0f) / 10.0f;
        return temp + "x";
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        super.func_146976_a(partialTick, mouseX, mouseY);
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiSalinationController.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        int xAxis = mouseX - guiWidth;
        int yAxis = mouseY - guiHeight;
        if (this.tileEntity.getScaledWaterLevel(58) > 0) {
            this.displayGauge(7, 14, this.tileEntity.getScaledWaterLevel(58), this.tileEntity.waterTank.getFluid(), null);
        }
        if (this.tileEntity.getScaledBrineLevel(58) > 0) {
            this.displayGauge(153, 14, this.tileEntity.getScaledBrineLevel(58), this.tileEntity.brineTank.getFluid(), null);
        }
        int displayInt = this.tileEntity.getScaledTempLevel(78);
        this.func_73729_b(guiWidth + 49, guiHeight + 64, 176, 59, displayInt, 8);
        if (xAxis >= 48 && xAxis <= 128 && yAxis >= 5 && yAxis <= 17) {
            this.func_73729_b(guiWidth + 48, guiHeight + 5, 176, 79, 80, 12);
        } else {
            this.func_73729_b(guiWidth + 48, guiHeight + 5, 176, 67, 80, 12);
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        if (button == 0) {
            int xAxis = x - (this.field_146294_l - this.field_146999_f) / 2;
            int yAxis = y - (this.field_146295_m - this.field_147000_g) / 2;
            if (xAxis >= 48 && xAxis <= 128 && yAxis >= 5 && yAxis <= 17) {
                ArrayList<Integer> data = new ArrayList<Integer>();
                data.add(0);
                Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
                SoundHandler.playSound("gui.button.press");
            }
        }
    }

    public void displayGauge(int xPos, int yPos, int scale, FluidStack fluid, GasStack gas) {
        int renderRemaining;
        if (fluid == null && gas == null) {
            return;
        }
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        int start = 0;
        do {
            renderRemaining = 0;
            if (scale > 16) {
                renderRemaining = 16;
                scale -= 16;
            } else {
                renderRemaining = scale;
                scale = 0;
            }
            this.field_146297_k.field_71446_o.func_110577_a(MekanismRenderer.getBlocksTexture());
            if (fluid != null) {
                this.func_94065_a(guiWidth + xPos, guiHeight + yPos + 58 - renderRemaining - start, fluid.getFluid().getIcon(), 16, 16 - (16 - renderRemaining));
            } else if (gas != null) {
                this.func_94065_a(guiWidth + xPos, guiHeight + yPos + 58 - renderRemaining - start, gas.getGas().getIcon(), 16, 16 - (16 - renderRemaining));
            }
            start += 16;
        } while (renderRemaining != 0 && scale != 0);
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiSalinationController.png"));
        this.func_73729_b(guiWidth + xPos, guiHeight + yPos, 176, 0, 16, 59);
    }
}

