/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.common.item.ItemSeismicReader;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidBlock;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiSeismicReader
extends GuiScreen {
    private World worldObj;
    public ItemStack itemStack;
    public int scroll;
    public int prevMouseY;
    public Coord4D pos;
    public boolean prevMouseDown;
    public boolean isDragging;
    public List<SeismicType> seismicCalculation;
    public int scrollStartX;
    public int scrollStartY;
    protected int xSize;
    protected int ySize;

    public GuiSeismicReader(Coord4D coord, ItemStack stack) {
        this.worldObj = Minecraft.func_71410_x().field_71441_e;
        this.isDragging = false;
        this.seismicCalculation = new ArrayList<SeismicType>();
        this.scrollStartX = 10;
        this.scrollStartY = 12;
        this.xSize = 118;
        this.ySize = 166;
        this.pos = coord;
        this.pos.yCoord = Math.min(255, this.pos.yCoord);
        this.itemStack = stack;
        this.calculate();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiSeismicReader.png"));
        int guiWidth = (this.field_146294_l - this.xSize) / 2;
        int guiHeight = (this.field_146295_m - this.ySize) / 2;
        int xAxis = mouseX - guiWidth;
        int yAxis = mouseY - guiHeight;
        if (Mouse.isButtonDown((int)0)) {
            if (!this.isDragging && xAxis >= 10 && xAxis <= 48 && yAxis >= 12 && yAxis <= 154) {
                if (!this.prevMouseDown) {
                    this.prevMouseDown = true;
                } else {
                    int mouseDiff = this.prevMouseY - yAxis;
                    this.scroll = Math.max(0, Math.min(this.scroll + mouseDiff, this.calcMaxScroll()));
                }
            }
            int maxScroll = this.calcMaxScroll();
            if (!this.isDragging && maxScroll > 0 && xAxis >= 49 && xAxis <= 53 && yAxis >= this.getScrollButtonY() && yAxis <= this.getScrollButtonY() + 4 && !this.prevMouseDown) {
                this.prevMouseDown = true;
                this.isDragging = true;
            }
            if (this.isDragging) {
                int relY = Math.max(13, Math.min(149, yAxis)) - 13;
                this.scroll = this.calcScrollFromButton(relY);
            }
            this.prevMouseY = yAxis;
        } else {
            this.prevMouseDown = false;
            this.isDragging = false;
        }
        this.func_73729_b(guiWidth + this.scrollStartX, guiHeight + this.scrollStartY, this.xSize, 13, 38, 142);
        this.drawChartLayer(guiWidth, guiHeight);
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.xSize, this.ySize);
        this.func_73729_b(guiWidth + this.scrollStartX + 38 + 1, guiHeight + this.getScrollButtonY(), this.xSize, 0, 4, 4);
        this.field_146289_q.func_78276_b(MekanismUtils.localize("gui.seismicReader.short"), guiWidth + 62, guiHeight + 18, 0);
        this.field_146289_q.func_78276_b(MekanismUtils.localize("gui.seismicReader.solids"), guiWidth + 70, guiHeight + 40, 0x404040);
        this.field_146289_q.func_78276_b(MekanismUtils.localize("gui.seismicReader.fluids"), guiWidth + 70, guiHeight + 62, 0x404040);
        this.field_146289_q.func_78276_b(MekanismUtils.localize("gui.empty"), guiWidth + 70, guiHeight + 78, 0x404040);
        this.field_146289_q.func_78276_b(MekanismUtils.localize("gui.seismicReader.reading"), guiWidth + 62, guiHeight + 114, 52480);
        this.field_146289_q.func_78276_b(MekanismUtils.localize("gui.energy") + ":", guiWidth + 62, guiHeight + 132, 52480);
        this.field_146289_q.func_78276_b(MekanismUtils.getEnergyDisplay(this.getEnergy()), guiWidth + 62, guiHeight + 141, 52480);
        super.func_73863_a(mouseX, mouseY, partialTick);
    }

    public double getEnergy() {
        return ((ItemSeismicReader)this.itemStack.func_77973_b()).getEnergy(this.itemStack);
    }

    public void drawChartLayer(int guiWidth, int guiHeight) {
        if (this.scroll <= 5) {
            this.func_73729_b(guiWidth + this.scrollStartX, guiHeight + this.scrollStartY + 5 - this.scroll, this.xSize, 4, 38, 1);
        }
        int amount = Math.min(71 + Math.min(0, this.scroll / 2 - 3), this.pos.yCoord);
        int start = this.pos.yCoord - this.scroll / 2 + Math.min(3, this.scroll / 2);
        int yStart = this.scrollStartY + Math.max(0, 6 - this.scroll);
        this.drawScale(guiWidth, guiHeight, amount, start, yStart, this.scroll % 2 == 1);
        if (this.calcMaxScroll() > 0 && this.scroll == this.calcMaxScroll()) {
            this.func_73729_b(guiWidth + this.scrollStartX, guiHeight + this.scrollStartY + 142 - 1, this.xSize, 4, 38, 1);
        } else if (this.calcMaxScroll() <= 0) {
            int dist = yStart + amount * 2;
            this.func_73729_b(guiWidth + this.scrollStartX, guiHeight + dist, this.xSize, 4, 38, 1);
        }
    }

    public void drawScale(int guiWidth, int guiHeight, int amount, int start, int yStart, boolean half) {
        int index;
        int starting = 0;
        int toRender = amount;
        int nextRender = guiHeight + yStart;
        if (half) {
            ++starting;
        }
        if (this.scroll < 6) {
            nextRender += half ? 1 : 0;
        }
        if (start % 4 != 0) {
            this.func_73729_b(guiWidth + 30, nextRender, this.xSize, 5 + (starting += (4 - start % 4) * 2), 3, 8 - starting);
            toRender -= (8 - starting) / 2;
            nextRender += 8 - starting;
            if (!this.seismicCalculation.isEmpty()) {
                int rendered = 8 - starting + (half && this.scroll > 6 ? 1 : 0);
                int nextY = guiHeight + yStart - (half && this.scroll > 6 ? 1 : 0);
                this.seismicCalculation.get(start - 1).render(this, this.xSize, guiWidth, nextY);
                if (rendered > 2) {
                    this.seismicCalculation.get(start - 2).render(this, this.xSize, guiWidth, nextY + 2);
                }
                if (rendered > 4) {
                    this.seismicCalculation.get(start - 3).render(this, this.xSize, guiWidth, nextY + 4);
                }
            }
        } else {
            nextRender -= half ? 1 : 0;
        }
        while (toRender >= 4) {
            this.func_73729_b(guiWidth + 30, nextRender, this.xSize, 5, 3, 8);
            index = start - (amount - (toRender -= 4));
            if ((index - 1) % 2 == 0) {
                --index;
            }
            if (index % 8 == 0 && this.pos.yCoord - index > 6) {
                int yPos = nextRender + 2;
                if (index == 0) {
                    yPos -= 2;
                }
                this.field_146289_q.func_78276_b(Integer.toString(index), guiWidth + 28 - this.field_146289_q.func_78256_a(Integer.toString(index)), yPos, 0xFFFFFF);
                this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiSeismicReader.png"));
            }
            if (!this.seismicCalculation.isEmpty()) {
                this.seismicCalculation.get(index + 3).render(this, this.xSize, guiWidth, nextRender);
                this.seismicCalculation.get(index + 2).render(this, this.xSize, guiWidth, nextRender + 2);
                this.seismicCalculation.get(index + 1).render(this, this.xSize, guiWidth, nextRender + 4);
                this.seismicCalculation.get(index + 0).render(this, this.xSize, guiWidth, nextRender + 6);
            }
            nextRender += 8;
        }
        if (toRender > 0) {
            this.func_73729_b(guiWidth + 30, nextRender, this.xSize, 5, 3, toRender * 2);
            if (!this.seismicCalculation.isEmpty()) {
                index = start - (amount - toRender);
                if ((index - 1) % 2 == 0) {
                    --index;
                }
                if (index - 1 >= 0) {
                    this.seismicCalculation.get(index - 1).render(this, this.xSize, guiWidth, nextRender);
                }
                if (toRender > 1 && index - 2 >= 0) {
                    this.seismicCalculation.get(index - 2).render(this, this.xSize, guiWidth, nextRender + 2);
                }
                if (toRender > 2 && index - 3 >= 0) {
                    this.seismicCalculation.get(index - 3).render(this, this.xSize, guiWidth, nextRender + 4);
                }
            }
        }
    }

    public int getScrollButtonY() {
        int max = this.calcMaxScroll();
        if (max == 0) {
            return this.scrollStartY + 1;
        }
        return this.scrollStartY + 1 + (int)((float)this.scroll / (float)max * 136.0f);
    }

    public int calcScrollFromButton(int relButtonY) {
        return (int)((float)relButtonY / 136.0f * (float)this.calcMaxScroll());
    }

    public int calcMaxScroll() {
        int ret = 6;
        ret += this.pos.yCoord * 2;
        ++ret;
        return ret -= 142;
    }

    public void calculate() {
        this.seismicCalculation.clear();
        for (int y = 1; y <= this.pos.yCoord; ++y) {
            Fluid fluid;
            Coord4D coord = new Coord4D(this.pos.xCoord, y, this.pos.zCoord, this.pos.dimensionId);
            if (coord.isAirBlock((IBlockAccess)this.worldObj)) {
                this.seismicCalculation.add(SeismicType.EMPTY);
                continue;
            }
            Block block = coord.getBlock((IBlockAccess)this.worldObj);
            int meta = coord.getMetadata((IBlockAccess)this.worldObj);
            if (block == Blocks.field_150349_c) {
                this.seismicCalculation.add(SeismicType.GRASS);
                continue;
            }
            if (block == Blocks.field_150346_d) {
                this.seismicCalculation.add(SeismicType.DIRT);
                continue;
            }
            if (block == Blocks.field_150348_b) {
                this.seismicCalculation.add(SeismicType.STONE);
                continue;
            }
            if (block == Blocks.field_150357_h) {
                this.seismicCalculation.add(SeismicType.BEDROCK);
                continue;
            }
            if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
                this.seismicCalculation.add(SeismicType.WATER);
                continue;
            }
            if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
                this.seismicCalculation.add(SeismicType.LAVA);
                continue;
            }
            if (block instanceof IFluidBlock && (fluid = ((IFluidBlock)block).getFluid()) != null) {
                String name = fluid.getName().toLowerCase();
                if (name.equals("water")) {
                    this.seismicCalculation.add(SeismicType.WATER);
                    continue;
                }
                if (name.equals("lava")) {
                    this.seismicCalculation.add(SeismicType.LAVA);
                    continue;
                }
                if (name.equals("oil")) {
                    this.seismicCalculation.add(SeismicType.OIL);
                    continue;
                }
            }
            List<String> oreDictNames = MekanismUtils.getOreDictName(new ItemStack(block, 1, meta));
            boolean foundName = false;
            if (oreDictNames != null && !oreDictNames.isEmpty()) {
                for (String s : oreDictNames) {
                    if (!s.trim().startsWith("ore")) continue;
                    this.seismicCalculation.add(SeismicType.ORE);
                    foundName = true;
                    break;
                }
            }
            if (foundName) continue;
            this.seismicCalculation.add(SeismicType.OTHER);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public static enum SeismicType {
        GRASS,
        DIRT,
        OTHER,
        ORE,
        STONE,
        BEDROCK,
        WATER,
        LAVA,
        OIL,
        EMPTY;


        public void render(GuiSeismicReader gui, int xSize, int guiWidth, int y) {
            gui.func_73729_b(guiWidth + 33, y, xSize, 155 + this.ordinal() * 2, 4, 2);
        }
    }
}

