/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerFilter;
import mekanism.common.network.PacketEditFilter;
import mekanism.common.network.PacketLogisticalSorterGui;
import mekanism.common.network.PacketNewFilter;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.transporter.TMaterialFilter;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiTMaterialFilter
extends GuiMekanism {
    public TileEntityLogisticalSorter tileEntity;
    public boolean isNew = false;
    public TMaterialFilter origFilter;
    public TMaterialFilter filter = new TMaterialFilter();
    public String status = (Object)((Object)EnumColor.DARK_GREEN) + MekanismUtils.localize("gui.allOK");
    public int ticker;

    public GuiTMaterialFilter(EntityPlayer player, TileEntityLogisticalSorter tentity, int index) {
        super(new ContainerFilter(player.field_71071_by, tentity));
        this.tileEntity = tentity;
        this.origFilter = (TMaterialFilter)this.tileEntity.filters.get(index);
        this.filter = ((TMaterialFilter)this.tileEntity.filters.get(index)).clone();
    }

    public GuiTMaterialFilter(EntityPlayer player, TileEntityLogisticalSorter tentity) {
        super(new ContainerFilter(player.field_71071_by, tentity));
        this.tileEntity = tentity;
        this.isNew = true;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, guiWidth + 27, guiHeight + 62, 60, 20, MekanismUtils.localize("gui.save")));
        this.field_146292_n.add(new GuiButton(1, guiWidth + 89, guiHeight + 62, 60, 20, MekanismUtils.localize("gui.delete")));
        if (this.isNew) {
            ((GuiButton)this.field_146292_n.get((int)1)).field_146124_l = false;
        }
    }

    protected void func_146284_a(GuiButton guibutton) {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == 0) {
            if (this.filter.materialItem != null) {
                if (this.isNew) {
                    Mekanism.packetHandler.sendToServer(new PacketNewFilter.NewFilterMessage(Coord4D.get(this.tileEntity), this.filter));
                } else {
                    Mekanism.packetHandler.sendToServer(new PacketEditFilter.EditFilterMessage(Coord4D.get(this.tileEntity), false, this.origFilter, this.filter));
                }
                Mekanism.packetHandler.sendToServer(new PacketLogisticalSorterGui.LogisticalSorterGuiMessage(PacketLogisticalSorterGui.SorterGuiPacket.SERVER, Coord4D.get(this.tileEntity), 0, 0, 0));
            } else if (this.filter.materialItem == null) {
                this.status = (Object)((Object)EnumColor.DARK_RED) + MekanismUtils.localize("gui.itemFilter.noItem");
                this.ticker = 20;
            }
        } else if (guibutton.field_146127_k == 1) {
            Mekanism.packetHandler.sendToServer(new PacketEditFilter.EditFilterMessage(Coord4D.get(this.tileEntity), true, this.origFilter, null));
            Mekanism.packetHandler.sendToServer(new PacketLogisticalSorterGui.LogisticalSorterGuiMessage(PacketLogisticalSorterGui.SorterGuiPacket.SERVER, Coord4D.get(this.tileEntity), 0, 0, 0));
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146289_q.func_78276_b((this.isNew ? MekanismUtils.localize("gui.new") : MekanismUtils.localize("gui.edit")) + " " + MekanismUtils.localize("gui.materialFilter"), 43, 6, 0x404040);
        this.field_146289_q.func_78276_b(MekanismUtils.localize("gui.status") + ": " + this.status, 35, 20, 52480);
        this.field_146289_q.func_78276_b(MekanismUtils.localize("gui.materialFilter.details") + ":", 35, 32, 52480);
        if (this.filter.materialItem != null) {
            this.field_146289_q.func_78276_b(this.filter.materialItem.func_82833_r(), 35, 41, 52480);
        }
        if (this.filter.materialItem != null) {
            GL11.glPushMatrix();
            GL11.glEnable((int)2896);
            field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), this.filter.materialItem, 12, 19);
            GL11.glDisable((int)2896);
            GL11.glPopMatrix();
        }
        if (this.filter.color != null) {
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)32826);
            this.field_146297_k.func_110434_K().func_110577_a(MekanismRenderer.getBlocksTexture());
            field_146296_j.func_94149_a(12, 44, MekanismRenderer.getColorIcon(this.filter.color), 16, 16);
            GL11.glDisable((int)2896);
            GL11.glPopMatrix();
        }
        if (xAxis >= 12 && xAxis <= 28 && yAxis >= 44 && yAxis <= 60) {
            if (this.filter.color != null) {
                this.func_146279_a(this.filter.color.getName(), xAxis, yAxis);
            } else {
                this.func_146279_a(MekanismUtils.localize("gui.none"), xAxis, yAxis);
            }
        }
        super.func_146979_b(mouseX, mouseY);
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.ticker > 0) {
            --this.ticker;
        } else {
            this.status = (Object)((Object)EnumColor.DARK_GREEN) + MekanismUtils.localize("gui.allOK");
        }
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        super.func_146976_a(partialTick, mouseX, mouseY);
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiTMaterialFilter.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (xAxis >= 5 && xAxis <= 16 && yAxis >= 5 && yAxis <= 16) {
            this.func_73729_b(guiWidth + 5, guiHeight + 5, 176, 0, 11, 11);
        } else {
            this.func_73729_b(guiWidth + 5, guiHeight + 5, 176, 11, 11, 11);
        }
        if (xAxis >= 12 && xAxis <= 28 && yAxis >= 19 && yAxis <= 35) {
            GL11.glPushMatrix();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int x = guiWidth + 12;
            int y = guiHeight + 19;
            this.func_73733_a(x, y, x + 16, y + 16, -2130706433, -2130706433);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            GL11.glPopMatrix();
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) {
        super.func_73864_a(mouseX, mouseY, button);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (button == 0) {
            if (xAxis >= 5 && xAxis <= 16 && yAxis >= 5 && yAxis <= 16) {
                SoundHandler.playSound("gui.button.press");
                Mekanism.packetHandler.sendToServer(new PacketLogisticalSorterGui.LogisticalSorterGuiMessage(PacketLogisticalSorterGui.SorterGuiPacket.SERVER, Coord4D.get(this.tileEntity), this.isNew ? 4 : 0, 0, 0));
            }
            if (xAxis >= 12 && xAxis <= 28 && yAxis >= 19 && yAxis <= 35) {
                ItemStack stack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
                if (stack != null && !Keyboard.isKeyDown((int)42)) {
                    if (stack.func_77973_b() instanceof ItemBlock && Block.func_149634_a((Item)stack.func_77973_b()) != Blocks.field_150357_h) {
                        this.filter.materialItem = stack.func_77946_l();
                        this.filter.materialItem.field_77994_a = 1;
                    }
                } else if (stack == null && Keyboard.isKeyDown((int)42)) {
                    this.filter.materialItem = null;
                }
                SoundHandler.playSound("gui.button.press");
            }
        }
        if (Keyboard.isKeyDown((int)42) && button == 0) {
            button = 2;
        }
        if (xAxis >= 12 && xAxis <= 28 && yAxis >= 44 && yAxis <= 60) {
            SoundHandler.playSound("mekanism:etc.Ding");
            if (button == 0) {
                this.filter.color = TransporterUtils.increment(this.filter.color);
            } else if (button == 1) {
                this.filter.color = TransporterUtils.decrement(this.filter.color);
            } else if (button == 2) {
                this.filter.color = null;
            }
        }
    }
}

