/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import codechicken.lib.vec.Rectangle4i;
import mekanism.api.Coord4D;
import mekanism.client.gui.GuiElement;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.sound.SoundHandler;
import mekanism.common.IUpgradeTile;
import mekanism.common.Mekanism;
import mekanism.common.network.PacketRemoveUpgrade;
import mekanism.common.util.MekanismUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class GuiUpgradeManagement
extends GuiElement {
    TileEntity tileEntity;

    public GuiUpgradeManagement(IGuiWrapper gui, TileEntity tile, ResourceLocation def) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, "GuiUpgradeManagement.png"), gui, def);
        this.tileEntity = tile;
    }

    @Override
    public Rectangle4i getBounds(int guiWidth, int guiHeight) {
        return new Rectangle4i(guiWidth + 176, guiHeight + 6, 26, 63);
    }

    @Override
    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        GuiUpgradeManagement.mc.field_71446_o.func_110577_a(this.RESOURCE);
        this.guiObj.drawTexturedRect(guiWidth + 176, guiHeight + 6, 0, 0, 26, 63);
        IUpgradeTile upgradeTile = (IUpgradeTile)this.tileEntity;
        int displayInt = upgradeTile.getComponent().getScaledUpgradeProgress(14);
        this.guiObj.drawTexturedRect(guiWidth + 180, guiHeight + 30, 26, 0, 10, displayInt);
        GuiUpgradeManagement.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void renderForeground(int xAxis, int yAxis) {
        GuiUpgradeManagement.mc.field_71446_o.func_110577_a(this.RESOURCE);
        IUpgradeTile upgradeTile = (IUpgradeTile)this.tileEntity;
        if (this.getFontRenderer() != null) {
            this.getFontRenderer().func_78276_b("S:" + (upgradeTile.getSpeedMultiplier(new Object[0]) + 1) + "x", 179, 47, 0x404040);
            this.getFontRenderer().func_78276_b("E:" + (upgradeTile.getEnergyMultiplier(new Object[0]) + 1) + "x", 179, 57, 0x404040);
        }
        if (xAxis >= 179 && xAxis <= 198 && yAxis >= 47 && yAxis <= 54) {
            this.displayTooltip(MekanismUtils.localize("gui.removeSpeedUpgrade"), xAxis, yAxis);
        }
        if (xAxis >= 179 && xAxis <= 198 && yAxis >= 57 && yAxis <= 64) {
            this.displayTooltip(MekanismUtils.localize("gui.removeEnergyUpgrade"), xAxis, yAxis);
        }
        GuiUpgradeManagement.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void preMouseClicked(int xAxis, int yAxis, int button) {
        if (xAxis >= 180 && xAxis <= 196 && yAxis >= 11 && yAxis <= 27) {
            this.offsetX(26);
        }
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
        if (xAxis >= 179 && xAxis <= 198 && yAxis >= 47 && yAxis <= 54) {
            SoundHandler.playSound("gui.button.press");
            Mekanism.packetHandler.sendToServer(new PacketRemoveUpgrade.RemoveUpgradeMessage(Coord4D.get(this.tileEntity), 0));
        }
        if (xAxis >= 179 && xAxis <= 198 && yAxis >= 57 && yAxis <= 64) {
            SoundHandler.playSound("gui.button.press");
            Mekanism.packetHandler.sendToServer(new PacketRemoveUpgrade.RemoveUpgradeMessage(Coord4D.get(this.tileEntity), 1));
        }
        if (xAxis >= 180 && xAxis <= 196 && yAxis >= 11 && yAxis <= 27) {
            this.offsetX(-26);
        }
    }
}

