/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.AdvancedInput;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.client.gui.GuiElement;
import mekanism.client.gui.GuiPowerBar;
import mekanism.client.gui.GuiProgress;
import mekanism.client.gui.GuiSlot;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.nei.BaseRecipeHandler;
import mekanism.common.ObfuscatedNames;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public abstract class AdvancedMachineRecipeHandler
extends BaseRecipeHandler {
    private int ticksPassed;

    public abstract String getRecipeId();

    public abstract Set<Map.Entry<AdvancedInput, ItemStack>> getRecipes();

    public abstract List<ItemStack> getFuelStacks(Gas var1);

    public abstract GuiProgress.ProgressBar getProgressType();

    @Override
    public void addGuiElements() {
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.INPUT, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 55, 16));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.POWER, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 30, 34).with(GuiSlot.SlotOverlay.POWER));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.EXTRA, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 55, 52));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.OUTPUT_LARGE, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 111, 30));
        this.guiElements.add(new GuiPowerBar((IGuiWrapper)this, new GuiPowerBar.IPowerInfoHandler(){

            @Override
            public double getLevel() {
                return AdvancedMachineRecipeHandler.this.ticksPassed <= 20 ? (double)((float)AdvancedMachineRecipeHandler.this.ticksPassed / 20.0f) : 1.0;
            }
        }, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 164, 15));
        this.guiElements.add(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return AdvancedMachineRecipeHandler.this.ticksPassed >= 40 ? (double)((float)((AdvancedMachineRecipeHandler.this.ticksPassed - 40) % 20) / 20.0f) : 0.0;
            }
        }, this.getProgressType(), this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 77, 37));
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)12, (int)0, (int)28, (int)5, (int)144, (int)68);
        for (GuiElement e : this.guiElements) {
            e.renderBackground(0, 0, -16, -5);
        }
    }

    public void drawExtras(int i) {
        CachedIORecipe recipe = (CachedIORecipe)((Object)this.arecipes.get(i));
        if (recipe.input.gasType != null && this.ticksPassed >= 20) {
            int displayInt = this.ticksPassed < 40 ? (this.ticksPassed - 20) * 12 / 20 : 12;
            this.displayGauge(45, 44 - displayInt, 6, displayInt, new GasStack(recipe.input.gasType, 1));
        }
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticksPassed;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(63, 34, 24, 7), this.getRecipeId(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<AdvancedInput, ItemStack> irecipe : this.getRecipes()) {
                this.arecipes.add(new CachedIORecipe(irecipe, this.getFuelStacks(irecipe.getKey().gasType)));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<AdvancedInput, ItemStack> irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.getValue(), (ItemStack)result)) continue;
            this.arecipes.add(new CachedIORecipe(irecipe, this.getFuelStacks(irecipe.getKey().gasType)));
        }
    }

    public String getGuiTexture() {
        return "mekanism:gui/GuiAdvancedMachine.png";
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("gas") && ingredients.length == 1 && ingredients[0] instanceof GasStack) {
            for (Map.Entry<AdvancedInput, ItemStack> irecipe : this.getRecipes()) {
                if (irecipe.getKey().gasType != ((GasStack)ingredients[0]).getGas()) continue;
                this.arecipes.add(new CachedIORecipe(irecipe, this.getFuelStacks(irecipe.getKey().gasType)));
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Map.Entry<AdvancedInput, ItemStack> irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.getKey().itemStack, (ItemStack)ingredient)) continue;
            this.arecipes.add(new CachedIORecipe(irecipe, this.getFuelStacks(irecipe.getKey().gasType)));
        }
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        Point point = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipe);
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft) - offset.x;
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop) - offset.y;
        if (xAxis >= 45 && xAxis <= 51 && yAxis >= 33 && yAxis <= 45) {
            currenttip.add(((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).input.gasType.getLocalizedName());
        }
        return super.handleTooltip(gui, currenttip, recipe);
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        Point point = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipe);
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft) - offset.x;
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop) - offset.y;
        GasStack stack = null;
        if (xAxis >= 45 && xAxis <= 51 && yAxis >= 33 && yAxis <= 45) {
            stack = new GasStack(((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).input.gasType, 1);
        }
        if (stack != null && (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe") ? this.doGasLookup(stack, false) : keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage") && this.doGasLookup(stack, true))) {
            return true;
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        Point point = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipe);
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft) - offset.x;
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop) - offset.y;
        GasStack stack = null;
        if (xAxis >= 45 && xAxis <= 51 && yAxis >= 33 && yAxis <= 45) {
            stack = new GasStack(((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).input.gasType, 1);
        }
        if (stack != null && (button == 0 ? this.doGasLookup(stack, false) : button == 1 && this.doGasLookup(stack, true))) {
            return true;
        }
        return super.mouseClicked(gui, button, recipe);
    }

    public class CachedIORecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public List<ItemStack> fuelStacks;
        public AdvancedInput input;
        public PositionedStack outputStack;

        public PositionedStack getIngredient() {
            return new PositionedStack((Object)this.input.itemStack, 40, 12);
        }

        public PositionedStack getResult() {
            return this.outputStack;
        }

        public PositionedStack getOtherStack() {
            return new PositionedStack((Object)this.fuelStacks.get(AdvancedMachineRecipeHandler.this.cycleticks / 40 % this.fuelStacks.size()), 40, 48);
        }

        public CachedIORecipe(AdvancedInput adv, ItemStack output, List<ItemStack> fuels) {
            super((TemplateRecipeHandler)AdvancedMachineRecipeHandler.this);
            this.input = adv;
            this.outputStack = new PositionedStack((Object)output, 100, 30);
            this.fuelStacks = fuels;
        }

        public CachedIORecipe(Map.Entry recipe, List<ItemStack> fuels) {
            this((AdvancedInput)recipe.getKey(), (ItemStack)recipe.getValue(), fuels);
        }
    }
}

