/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.ChemicalPair;
import mekanism.api.gas.GasStack;
import mekanism.client.gui.GuiChemicalInfuser;
import mekanism.client.nei.BaseRecipeHandler;
import mekanism.common.ObfuscatedNames;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.inventory.GuiContainer;
import org.lwjgl.opengl.GL11;

public class ChemicalInfuserRecipeHandler
extends BaseRecipeHandler {
    private int ticksPassed;
    public static int xOffset = 5;
    public static int yOffset = 3;

    public String getRecipeName() {
        return MekanismUtils.localize("tile.MachineBlock2.ChemicalInfuser.name");
    }

    public String getOverlayIdentifier() {
        return "chemicalinfuser";
    }

    public String getGuiTexture() {
        return "mekanism:gui/nei/GuiChemicalInfuser.png";
    }

    public Class getGuiClass() {
        return GuiChemicalInfuser.class;
    }

    public String getRecipeId() {
        return "mekanism.chemicalinfuser";
    }

    public Set<Map.Entry<ChemicalPair, GasStack>> getRecipes() {
        return RecipeHandler.Recipe.CHEMICAL_INFUSER.get().entrySet();
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)-2, (int)0, (int)3, (int)yOffset, (int)170, (int)80);
    }

    public void drawExtras(int i) {
        CachedIORecipe recipe = (CachedIORecipe)((Object)this.arecipes.get(i));
        GuiDraw.drawTexturedModalRect((int)(47 - xOffset), (int)(39 - yOffset), (int)176, (int)71, (int)28, (int)8);
        GuiDraw.drawTexturedModalRect((int)(101 - xOffset), (int)(39 - yOffset), (int)176, (int)63, (int)28, (int)8);
        if (recipe.chemicalInput.leftGas != null) {
            this.displayGauge(58, 26 - xOffset, 14 - yOffset, 176, 4, 58, null, recipe.chemicalInput.leftGas);
        }
        if (recipe.outputStack != null) {
            this.displayGauge(58, 80 - xOffset, 5 - yOffset, 176, 4, 58, null, recipe.outputStack);
        }
        if (recipe.chemicalInput.rightGas != null) {
            this.displayGauge(58, 134 - xOffset, 14 - yOffset, 176, 4, 58, null, recipe.chemicalInput.rightGas);
        }
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticksPassed;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(47 - xOffset, 39 - yOffset, 28, 8), this.getRecipeId(), new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(101 - xOffset, 39 - yOffset, 28, 8), this.getRecipeId(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<ChemicalPair, GasStack> irecipe : this.getRecipes()) {
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else if (outputId.equals("gas") && results.length == 1 && results[0] instanceof GasStack) {
            for (Map.Entry<ChemicalPair, GasStack> irecipe : this.getRecipes()) {
                if (!((GasStack)results[0]).isGasEqual(irecipe.getValue())) continue;
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("gas") && ingredients.length == 1 && ingredients[0] instanceof GasStack) {
            for (Map.Entry<ChemicalPair, GasStack> irecipe : this.getRecipes()) {
                if (!irecipe.getKey().containsType((GasStack)ingredients[0])) continue;
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        Point point = GuiDraw.getMousePosition();
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
        if (xAxis >= 26 && xAxis <= 42 && yAxis >= 27 && yAxis <= 85) {
            currenttip.add(((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).chemicalInput.leftGas.getGas().getLocalizedName());
        } else if (xAxis >= 80 && xAxis <= 96 && yAxis >= 18 && yAxis <= 76) {
            currenttip.add(((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).outputStack.getGas().getLocalizedName());
        } else if (xAxis >= 134 && xAxis <= 150 && yAxis >= 27 && yAxis <= 85) {
            currenttip.add(((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).chemicalInput.rightGas.getGas().getLocalizedName());
        }
        return super.handleTooltip(gui, currenttip, recipe);
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        Point point = GuiDraw.getMousePosition();
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
        GasStack stack = null;
        if (xAxis >= 26 && xAxis <= 42 && yAxis >= 27 && yAxis <= 85) {
            stack = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).chemicalInput.leftGas;
        } else if (xAxis >= 80 && xAxis <= 96 && yAxis >= 18 && yAxis <= 76) {
            stack = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).outputStack;
        } else if (xAxis >= 134 && xAxis <= 150 && yAxis >= 27 && yAxis <= 85) {
            stack = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).chemicalInput.rightGas;
        }
        if (stack != null && (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe") ? this.doGasLookup(stack, false) : keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage") && this.doGasLookup(stack, true))) {
            return true;
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        Point point = GuiDraw.getMousePosition();
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
        GasStack stack = null;
        if (xAxis >= 26 && xAxis <= 42 && yAxis >= 27 && yAxis <= 85) {
            stack = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).chemicalInput.leftGas;
        } else if (xAxis >= 80 && xAxis <= 96 && yAxis >= 18 && yAxis <= 76) {
            stack = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).outputStack;
        } else if (xAxis >= 134 && xAxis <= 150 && yAxis >= 27 && yAxis <= 85) {
            stack = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).chemicalInput.rightGas;
        }
        if (stack != null && (button == 0 ? this.doGasLookup(stack, false) : button == 1 && this.doGasLookup(stack, true))) {
            return true;
        }
        return super.mouseClicked(gui, button, recipe);
    }

    public int recipiesPerPage() {
        return 1;
    }

    @Override
    public void addGuiElements() {
    }

    public class CachedIORecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ChemicalPair chemicalInput;
        public GasStack outputStack;

        public PositionedStack getResult() {
            return null;
        }

        public CachedIORecipe(ChemicalPair input, GasStack output) {
            super((TemplateRecipeHandler)ChemicalInfuserRecipeHandler.this);
            this.chemicalInput = input;
            this.outputStack = output;
        }

        public CachedIORecipe(Map.Entry recipe) {
            this((ChemicalPair)recipe.getKey(), (GasStack)recipe.getValue());
        }
    }
}

