/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.gas.GasStack;
import mekanism.client.gui.GuiChemicalOxidizer;
import mekanism.client.gui.GuiElement;
import mekanism.client.gui.GuiGasGauge;
import mekanism.client.gui.GuiGauge;
import mekanism.client.gui.GuiProgress;
import mekanism.client.gui.GuiSlot;
import mekanism.client.nei.BaseRecipeHandler;
import mekanism.common.ObfuscatedNames;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ChemicalOxidizerRecipeHandler
extends BaseRecipeHandler {
    private int ticksPassed;
    public GuiGasGauge gasOutput;
    public static int xOffset = 5;
    public static int yOffset = 12;

    @Override
    public void addGuiElements() {
        this.gasOutput = GuiGasGauge.getDummy(GuiGauge.Type.STANDARD, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalOxidizer.png"), 133, 13);
        this.guiElements.add(this.gasOutput);
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.NORMAL, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalOxidizer.png"), 154, 4).with(GuiSlot.SlotOverlay.POWER));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.NORMAL, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalOxidizer.png"), 25, 35));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.NORMAL, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalOxidizer.png"), 154, 24).with(GuiSlot.SlotOverlay.PLUS));
        this.guiElements.add(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return ChemicalOxidizerRecipeHandler.this.ticksPassed >= 20 ? (double)((float)((ChemicalOxidizerRecipeHandler.this.ticksPassed - 20) % 20) / 20.0f) : 0.0;
            }
        }, GuiProgress.ProgressBar.LARGE_RIGHT, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalOxidizer.png"), 62, 39));
    }

    public String getRecipeName() {
        return MekanismUtils.localize("tile.MachineBlock2.ChemicalOxidizer.name");
    }

    public String getOverlayIdentifier() {
        return "chemicaloxidizer";
    }

    public String getGuiTexture() {
        return "mekanism:gui/GuiChemicalOxidizer.png";
    }

    public Class getGuiClass() {
        return GuiChemicalOxidizer.class;
    }

    public String getRecipeId() {
        return "mekanism.chemicaloxidizer";
    }

    public Set<Map.Entry<ItemStack, GasStack>> getRecipes() {
        return RecipeHandler.Recipe.CHEMICAL_OXIDIZER.get().entrySet();
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)xOffset, (int)yOffset, (int)147, (int)62);
        for (GuiElement e : this.guiElements) {
            e.renderBackground(0, 0, -xOffset, -yOffset);
        }
    }

    public void drawExtras(int i) {
        CachedIORecipe recipe = (CachedIORecipe)((Object)this.arecipes.get(i));
        if (recipe.outputStack != null) {
            this.gasOutput.setDummyType(recipe.outputStack.getGas());
            this.gasOutput.renderScale(0, 0, -xOffset, -yOffset);
        }
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticksPassed;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(64 - xOffset, 40 - yOffset, 48, 8), this.getRecipeId(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<ItemStack, GasStack> irecipe : this.getRecipes()) {
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else if (outputId.equals("gas") && results.length == 1 && results[0] instanceof GasStack) {
            for (Map.Entry<ItemStack, GasStack> irecipe : this.getRecipes()) {
                if (!((GasStack)results[0]).isGasEqual(irecipe.getValue())) continue;
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        Point point = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipe);
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft) - offset.x;
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop) - offset.y;
        if (xAxis >= 129 && xAxis <= 145 && yAxis >= 3 && yAxis <= 61) {
            currenttip.add(((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).outputStack.getGas().getLocalizedName());
        }
        return super.handleTooltip(gui, currenttip, recipe);
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        Point point = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipe);
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft) - offset.x;
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop) - offset.y;
        if (xAxis >= 129 && xAxis <= 145 && yAxis >= 3 && yAxis <= 61) {
            GasStack stack = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).outputStack;
            if (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe") ? this.doGasLookup(stack, false) : keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage") && this.doGasLookup(stack, true)) {
                return true;
            }
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        Point point = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipe);
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft) - offset.x;
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop) - offset.y;
        if (xAxis >= 129 && xAxis <= 145 && yAxis >= 3 && yAxis <= 61) {
            GasStack stack = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).outputStack;
            if (button == 0 ? this.doGasLookup(stack, false) : button == 1 && this.doGasLookup(stack, true)) {
                return true;
            }
        }
        return super.mouseClicked(gui, button, recipe);
    }

    public int recipiesPerPage() {
        return 2;
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Map.Entry<ItemStack, GasStack> irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.getKey(), (ItemStack)ingredient)) continue;
            this.arecipes.add(new CachedIORecipe(irecipe));
        }
    }

    public class CachedIORecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public PositionedStack inputStack;
        public GasStack outputStack;

        public PositionedStack getIngredient() {
            return this.inputStack;
        }

        public PositionedStack getResult() {
            return null;
        }

        public CachedIORecipe(ItemStack input, GasStack output) {
            super((TemplateRecipeHandler)ChemicalOxidizerRecipeHandler.this);
            this.inputStack = new PositionedStack((Object)input, 26 - xOffset, 36 - yOffset);
            this.outputStack = output;
        }

        public CachedIORecipe(Map.Entry recipe) {
            this((ItemStack)recipe.getKey(), (GasStack)recipe.getValue());
        }
    }
}

