/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.ShapedRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mekanism.api.energy.IEnergizedItem;
import mekanism.api.gas.IGasItem;
import mekanism.common.IEnergyCube;
import mekanism.common.IFactory;
import mekanism.common.block.BlockMachine;
import mekanism.common.recipe.MekanismRecipe;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;

public class MekanismRecipeHandler
extends ShapedRecipeHandler {
    public String getRecipeName() {
        return "Mekanism " + MekanismUtils.localize("recipe.mekanismShaped");
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("crafting") && ((Object)((Object)this)).getClass() == MekanismRecipeHandler.class) {
            List allrecipes = CraftingManager.func_77594_a().func_77592_b();
            for (IRecipe irecipe : allrecipes) {
                if (!(irecipe instanceof MekanismRecipe)) continue;
                MekanismRecipe energyRecipe = (MekanismRecipe)irecipe;
                CachedEnergyRecipe recipe = new CachedEnergyRecipe(energyRecipe.width, energyRecipe.height, energyRecipe.getInput(), energyRecipe.func_77571_b());
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        List allrecipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe irecipe : allrecipes) {
            if (!(irecipe instanceof MekanismRecipe) || !MekanismRecipeHandler.areItemsEqual(irecipe.func_77571_b(), result)) continue;
            MekanismRecipe energyRecipe = (MekanismRecipe)irecipe;
            CachedEnergyRecipe recipe = new CachedEnergyRecipe(energyRecipe.width, energyRecipe.height, energyRecipe.getInput(), energyRecipe.func_77571_b());
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List allrecipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe irecipe : allrecipes) {
            MekanismRecipe energyRecipe;
            CachedEnergyRecipe recipe;
            if (!(irecipe instanceof MekanismRecipe) || !(recipe = new CachedEnergyRecipe(energyRecipe.width, energyRecipe.height, (energyRecipe = (MekanismRecipe)irecipe).getInput(), energyRecipe.func_77571_b())).contains(recipe.ingredients, ingredient)) continue;
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public static boolean areItemsEqual(ItemStack target, ItemStack input) {
        if (target == null && input != null || target != null && input == null) {
            return false;
        }
        if (target == null && input == null) {
            return true;
        }
        if (target.func_77973_b() != input.func_77973_b()) {
            return false;
        }
        if (!(target.func_77973_b() instanceof IEnergizedItem || input.func_77973_b() instanceof IEnergizedItem || target.func_77973_b() instanceof IGasItem || input.func_77973_b() instanceof IGasItem)) {
            if (target.func_77960_j() != input.func_77960_j() && target.func_77960_j() != Short.MAX_VALUE) {
                return false;
            }
        } else {
            if (target.func_77973_b() instanceof IEnergizedItem && input.func_77973_b() instanceof IEnergizedItem && ((IEnergizedItem)target.func_77973_b()).isMetadataSpecific(target) && ((IEnergizedItem)input.func_77973_b()).isMetadataSpecific(input) && target.func_77960_j() != input.func_77960_j() && target.func_77960_j() != Short.MAX_VALUE) {
                return false;
            }
            if (target.func_77973_b() instanceof IGasItem && input.func_77973_b() instanceof IGasItem && ((IGasItem)target.func_77973_b()).isMetadataSpecific(target) && ((IGasItem)input.func_77973_b()).isMetadataSpecific(input) && target.func_77960_j() != input.func_77960_j() && target.func_77960_j() != Short.MAX_VALUE) {
                return false;
            }
            if (target.func_77973_b() instanceof IEnergyCube && input.func_77973_b() instanceof IEnergyCube ? ((IEnergyCube)target.func_77973_b()).getEnergyCubeTier(target) != ((IEnergyCube)input.func_77973_b()).getEnergyCubeTier(input) : target.func_77973_b() instanceof IFactory && input.func_77973_b() instanceof IFactory && MekanismRecipeHandler.isFactory(target) && MekanismRecipeHandler.isFactory(input) && ((IFactory)target.func_77973_b()).getRecipeType(target) != ((IFactory)input.func_77973_b()).getRecipeType(input)) {
                return false;
            }
        }
        return true;
    }

    private static boolean isFactory(ItemStack stack) {
        return BlockMachine.MachineType.get(stack) == BlockMachine.MachineType.BASIC_FACTORY || BlockMachine.MachineType.get(stack) == BlockMachine.MachineType.ADVANCED_FACTORY || BlockMachine.MachineType.get(stack) == BlockMachine.MachineType.ELITE_FACTORY;
    }

    public class CachedEnergyRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        public PositionedStack result;

        public CachedEnergyRecipe(int width, int height, Object[] items, ItemStack out) {
            super((TemplateRecipeHandler)MekanismRecipeHandler.this);
            this.result = new PositionedStack((Object)out, 119, 24);
            this.ingredients = new ArrayList();
            this.setIngredients(width, height, items);
        }

        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (items[y * width + x] == null) continue;
                    PositionedStack stack = new PositionedStack(items[y * width + x], 25 + x * 18, 6 + y * 18);
                    stack.setMaxSize(1);
                    this.ingredients.add(stack);
                }
            }
        }

        public ArrayList<PositionedStack> getIngredients() {
            return (ArrayList)this.getCycledIngredients(MekanismRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public boolean contains(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            for (PositionedStack stack : ingredients) {
                for (ItemStack item : stack.items) {
                    if (!MekanismRecipeHandler.areItemsEqual(item, ingredient)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

