/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.infuse.InfuseObject;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.infuse.InfuseType;
import mekanism.api.infuse.InfusionInput;
import mekanism.api.infuse.InfusionOutput;
import mekanism.client.gui.GuiElement;
import mekanism.client.gui.GuiMetallurgicInfuser;
import mekanism.client.gui.GuiPowerBar;
import mekanism.client.gui.GuiProgress;
import mekanism.client.gui.GuiSlot;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.nei.BaseRecipeHandler;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class MetallurgicInfuserRecipeHandler
extends BaseRecipeHandler {
    private int ticksPassed;

    @Override
    public void addGuiElements() {
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.EXTRA, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 16, 34));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.INPUT, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 50, 42));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.POWER, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 142, 34).with(GuiSlot.SlotOverlay.POWER));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.OUTPUT, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 108, 42));
        this.guiElements.add(new GuiPowerBar((IGuiWrapper)this, new GuiPowerBar.IPowerInfoHandler(){

            @Override
            public double getLevel() {
                return MetallurgicInfuserRecipeHandler.this.ticksPassed <= 20 ? (double)((float)MetallurgicInfuserRecipeHandler.this.ticksPassed / 20.0f) : 1.0;
            }
        }, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 164, 15));
        this.guiElements.add(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return MetallurgicInfuserRecipeHandler.this.ticksPassed >= 40 ? (double)((float)((MetallurgicInfuserRecipeHandler.this.ticksPassed - 40) % 20) / 20.0f) : 0.0;
            }
        }, GuiProgress.ProgressBar.MEDIUM, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 70, 46));
    }

    public String getRecipeName() {
        return MekanismUtils.localize("tile.MachineBlock.MetallurgicInfuser.name");
    }

    public String getOverlayIdentifier() {
        return "infuser";
    }

    public String getGuiTexture() {
        return "mekanism:gui/GuiMetallurgicInfuser.png";
    }

    public Class getGuiClass() {
        return GuiMetallurgicInfuser.class;
    }

    public String getRecipeId() {
        return "mekanism.infuser";
    }

    public List<ItemStack> getInfuseStacks(InfuseType type) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (Map.Entry<ItemStack, InfuseObject> obj : InfuseRegistry.getObjectMap().entrySet()) {
            if (obj.getValue().type != type) continue;
            ret.add(obj.getKey());
        }
        return ret;
    }

    public Set<Map.Entry<InfusionInput, InfusionOutput>> getRecipes() {
        return RecipeHandler.Recipe.METALLURGIC_INFUSER.get().entrySet();
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)15, (int)166, (int)56);
        for (GuiElement e : this.guiElements) {
            e.renderBackground(0, 0, -5, -15);
        }
    }

    public void drawExtras(int i) {
        float f;
        InfuseType type = ((CachedIORecipe)((Object)this.arecipes.get((int)i))).infusionType;
        float f2 = f = this.ticksPassed >= 20 && this.ticksPassed < 40 ? (float)((this.ticksPassed - 20) % 20) / 20.0f : 1.0f;
        if (this.ticksPassed < 20) {
            f = 0.0f;
        }
        GuiDraw.changeTexture((ResourceLocation)type.texture);
        this.drawProgressBar(2, 2, type.texX, type.texY, 4, 52, f, 3);
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticksPassed;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(67, 32, 32, 8), this.getRecipeId(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<InfusionInput, InfusionOutput> irecipe : this.getRecipes()) {
                this.arecipes.add(new CachedIORecipe(irecipe, this.getInfuseStacks(irecipe.getKey().infusionType), irecipe.getKey().infusionType));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public int recipiesPerPage() {
        return 2;
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<InfusionInput, InfusionOutput> irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.getValue().resource, (ItemStack)result)) continue;
            this.arecipes.add(new CachedIORecipe(irecipe, this.getInfuseStacks(irecipe.getKey().infusionType), irecipe.getKey().infusionType));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Map.Entry<InfusionInput, InfusionOutput> irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.getKey().inputStack, (ItemStack)ingredient)) continue;
            this.arecipes.add(new CachedIORecipe(irecipe, this.getInfuseStacks(irecipe.getKey().infusionType), irecipe.getKey().infusionType));
        }
    }

    public class CachedIORecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public List<ItemStack> infuseStacks;
        public PositionedStack inputStack;
        public PositionedStack outputStack;
        public InfuseType infusionType;

        public PositionedStack getIngredient() {
            return this.inputStack;
        }

        public PositionedStack getResult() {
            return this.outputStack;
        }

        public PositionedStack getOtherStack() {
            return new PositionedStack((Object)this.infuseStacks.get(MetallurgicInfuserRecipeHandler.this.cycleticks / 40 % this.infuseStacks.size()), 12, 20);
        }

        public CachedIORecipe(ItemStack input, ItemStack output, List<ItemStack> infuses, InfuseType type) {
            super((TemplateRecipeHandler)MetallurgicInfuserRecipeHandler.this);
            this.inputStack = new PositionedStack((Object)input, 46, 28);
            this.outputStack = new PositionedStack((Object)output, 104, 28);
            this.infuseStacks = infuses;
            this.infusionType = type;
        }

        public CachedIORecipe(Map.Entry recipe, List<ItemStack> infuses, InfuseType type) {
            this(((InfusionInput)recipe.getKey()).inputStack, ((InfusionOutput)recipe.getValue()).resource, infuses, type);
        }
    }
}

