/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.lighting.LightModel;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.ColourMultiplier;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.render.uv.IconTransformation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.Coord4D;
import mekanism.api.gas.GasNetwork;
import mekanism.client.model.ModelTransporterBox;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.FluidNetwork;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.multipart.PartDiversionTransporter;
import mekanism.common.multipart.PartLogisticalTransporter;
import mekanism.common.multipart.PartMechanicalPipe;
import mekanism.common.multipart.PartPressurizedTube;
import mekanism.common.multipart.PartSidedPipe;
import mekanism.common.multipart.PartTransmitter;
import mekanism.common.multipart.PartUniversalCable;
import mekanism.common.multipart.TransmitterType;
import mekanism.common.transporter.TransporterStack;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderPartTransmitter
implements TextureUtils.IIconSelfRegister {
    public static RenderPartTransmitter INSTANCE;
    public static Map<String, CCModel> small_models;
    public static Map<String, CCModel> large_models;
    public static Map<String, CCModel> contents_models;
    private static final int stages = 100;
    private static final double height = 0.45;
    private static final double offset = 0.015;
    private ModelTransporterBox modelBox = new ModelTransporterBox();
    private HashMap<ForgeDirection, HashMap<Fluid, MekanismRenderer.DisplayInteger[]>> cachedLiquids = new HashMap();
    private HashMap<ForgeDirection, HashMap<Integer, MekanismRenderer.DisplayInteger>> cachedOverlays = new HashMap();
    private Minecraft mc = Minecraft.func_71410_x();
    private EntityItem entityItem = new EntityItem(null);
    private RenderItem renderer = (RenderItem)RenderManager.field_78727_a.func_78715_a(EntityItem.class);

    public static RenderPartTransmitter getInstance() {
        return INSTANCE;
    }

    public static void init() {
        INSTANCE = new RenderPartTransmitter();
        TextureUtils.addIconRegistrar((TextureUtils.IIconSelfRegister)INSTANCE);
        small_models = CCModel.parseObjModels((ResourceLocation)MekanismUtils.getResource(MekanismUtils.ResourceType.MODEL, "transmitter_small.obj"), (int)7, null);
        for (Map.Entry<String, CCModel> e : small_models.entrySet()) {
            e.setValue(e.getValue().twoFacedCopy().apply((Transformation)new Translation(Vector3.center)).shrinkUVs(5.0E-4));
            e.getValue().computeLighting(LightModel.standardLightModel);
        }
        large_models = CCModel.parseObjModels((ResourceLocation)MekanismUtils.getResource(MekanismUtils.ResourceType.MODEL, "transmitter_large.obj"), (int)7, null);
        for (Map.Entry<String, CCModel> e : large_models.entrySet()) {
            e.setValue(e.getValue().twoFacedCopy().apply((Transformation)new Translation(Vector3.center)).shrinkUVs(5.0E-4));
            e.getValue().computeLighting(LightModel.standardLightModel);
        }
        contents_models = CCModel.parseObjModels((ResourceLocation)MekanismUtils.getResource(MekanismUtils.ResourceType.MODEL, "transmitter_contents.obj"), (int)7, null);
        LightModel interiorLightModel = new LightModel().setAmbient(new Vector3(0.6, 0.6, 0.6)).addLight(new LightModel.Light(new Vector3(0.3, 1.0, -0.7)).setDiffuse(new Vector3(0.6, 0.6, 0.6))).addLight(new LightModel.Light(new Vector3(-0.3, 1.0, 0.7)).setDiffuse(new Vector3(0.6, 0.6, 0.6)));
        for (CCModel c : contents_models.values()) {
            c.apply((Transformation)new Translation(Vector3.center));
            c.computeLighting(interiorLightModel);
            c.shrinkUVs(5.0E-4);
        }
    }

    private void push() {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glBlendFunc((int)770, (int)771);
    }

    private void pop() {
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public void renderItem(TransmitterType type) {
        CCRenderState.reset();
        CCRenderState.startDrawing();
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            this.renderSide(side, type);
        }
        CCRenderState.draw();
    }

    public void renderContents(PartLogisticalTransporter transporter, float partialTick, Vector3 vec) {
        GL11.glPushMatrix();
        this.entityItem.field_70292_b = 0;
        this.entityItem.field_70290_d = 0.0f;
        this.entityItem.func_70107_b((double)transporter.x() + 0.5, (double)transporter.y() + 0.5, (double)transporter.z() + 0.5);
        this.entityItem.field_70170_p = transporter.world();
        for (TransporterStack stack : transporter.transit) {
            if (stack == null) continue;
            GL11.glPushMatrix();
            this.entityItem.func_92058_a(stack.itemStack);
            float[] pos = TransporterUtils.getStackPosition(transporter, stack, partialTick * 5.0f);
            GL11.glTranslated((double)(vec.x + (double)pos[0]), (double)(vec.y + (double)pos[1] - (double)this.entityItem.field_70129_M), (double)(vec.z + (double)pos[2]));
            GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
            this.renderer.func_76986_a(this.entityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            GL11.glPopMatrix();
            if (stack.color == null) continue;
            CCRenderState.changeTexture((ResourceLocation)MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "TransporterBox.png"));
            GL11.glPushMatrix();
            MekanismRenderer.glowOn();
            GL11.glDisable((int)2884);
            GL11.glColor4f((float)stack.color.getColor(0), (float)stack.color.getColor(1), (float)stack.color.getColor(2), (float)1.0f);
            GL11.glTranslatef((float)((float)(vec.x + (double)pos[0])), (float)((float)(vec.y + (double)pos[1] - (double)this.entityItem.field_70129_M - (stack.itemStack.func_77973_b() instanceof ItemBlock ? 0.1 : 0.0))), (float)((float)(vec.z + (double)pos[2])));
            this.modelBox.render(0.0625f);
            MekanismRenderer.glowOff();
            GL11.glPopMatrix();
        }
        if (transporter instanceof PartDiversionTransporter) {
            int zPos;
            int yPos;
            int xPos;
            Coord4D obj;
            EntityClientPlayerMP player = this.mc.field_71439_g;
            World world = this.mc.field_71439_g.field_70170_p;
            ItemStack itemStack = player.func_71045_bC();
            MovingObjectPosition pos = player.func_70614_a(8.0, 1.0f);
            if (pos != null && itemStack != null && itemStack.func_77973_b() instanceof ItemConfigurator && (obj = new Coord4D(xPos = MathHelper.func_76128_c((double)pos.field_72311_b), yPos = MathHelper.func_76128_c((double)pos.field_72312_c), zPos = MathHelper.func_76128_c((double)pos.field_72309_d), transporter.world().field_73011_w.field_76574_g)).equals(Coord4D.get((TileEntity)transporter.tile()))) {
                int mode = ((PartDiversionTransporter)transporter).modes[pos.field_72310_e];
                ForgeDirection side = ForgeDirection.getOrientation((int)pos.field_72310_e);
                this.pushTransporter();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
                CCRenderState.changeTexture((ResourceLocation)(mode == 0 ? MekanismRenderer.getItemsTexture() : MekanismRenderer.getBlocksTexture()));
                GL11.glTranslatef((float)((float)vec.x), (float)((float)vec.y), (float)((float)vec.z));
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
                int display = this.getOverlayDisplay((World)world, (ForgeDirection)side, (int)mode).display;
                GL11.glCallList((int)display);
                this.popTransporter();
            }
        }
        GL11.glPopMatrix();
    }

    public void renderContents(PartUniversalCable cable, Vector3 pos) {
        if (cable.currentPower == 0.0) {
            return;
        }
        GL11.glPushMatrix();
        CCRenderState.reset();
        CCRenderState.useNormals = true;
        CCRenderState.startDrawing();
        GL11.glTranslated((double)pos.x, (double)pos.y, (double)pos.z);
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            this.renderEnergySide(side, cable);
        }
        MekanismRenderer.glowOn();
        MekanismRenderer.cullFrontFace();
        CCRenderState.draw();
        MekanismRenderer.disableCullFace();
        MekanismRenderer.glowOff();
        GL11.glPopMatrix();
    }

    public void renderContents(PartMechanicalPipe pipe, Vector3 pos) {
        float targetScale = ((FluidNetwork)pipe.getTransmitterNetwork()).fluidScale;
        pipe.currentScale = (double)Math.abs(pipe.currentScale - targetScale) > 0.01 ? (12.0f * pipe.currentScale + targetScale) / 13.0f : targetScale;
        Fluid fluid = ((FluidNetwork)pipe.getTransmitterNetwork()).refFluid;
        float scale = pipe.currentScale;
        if ((double)scale > 0.01 && fluid != null) {
            this.push();
            MekanismRenderer.glowOn(fluid.getLuminosity());
            CCRenderState.changeTexture((ResourceLocation)MekanismRenderer.getBlocksTexture());
            GL11.glTranslated((double)pos.x, (double)pos.y, (double)pos.z);
            boolean gas = fluid.isGaseous();
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                if (pipe.getConnectionType(side) == PartSidedPipe.ConnectionType.NORMAL) {
                    MekanismRenderer.DisplayInteger[] displayLists = this.getListAndRender(side, fluid);
                    if (displayLists == null) continue;
                    if (!gas) {
                        displayLists[Math.max(3, (int)(scale * 99.0f))].render();
                        continue;
                    }
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)scale);
                    displayLists[99].render();
                    continue;
                }
                if (pipe.getConnectionType(side) == PartSidedPipe.ConnectionType.NONE) continue;
                GL11.glCullFace((int)1028);
                CCRenderState.startDrawing();
                this.renderFluidInOut(side, pipe);
                CCRenderState.draw();
                GL11.glCullFace((int)1029);
            }
            MekanismRenderer.DisplayInteger[] displayLists = this.getListAndRender(ForgeDirection.UNKNOWN, fluid);
            if (displayLists != null) {
                if (!gas) {
                    displayLists[Math.max(3, (int)(scale * 99.0f))].render();
                } else {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)scale);
                    displayLists[99].render();
                }
            }
            MekanismRenderer.glowOff();
            this.pop();
        }
    }

    private MekanismRenderer.DisplayInteger[] getListAndRender(ForgeDirection side, Fluid fluid) {
        if (side == null || fluid == null || fluid.getIcon() == null) {
            return null;
        }
        if (this.cachedLiquids.containsKey(side) && this.cachedLiquids.get(side).containsKey(fluid)) {
            return this.cachedLiquids.get(side).get(fluid);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150355_j;
        toReturn.setTexture(fluid.getIcon());
        toReturn.setSideRender(side, false);
        toReturn.setSideRender(side.getOpposite(), false);
        MekanismRenderer.DisplayInteger[] displays = new MekanismRenderer.DisplayInteger[100];
        if (this.cachedLiquids.containsKey(side)) {
            this.cachedLiquids.get(side).put(fluid, displays);
        } else {
            HashMap<Fluid, MekanismRenderer.DisplayInteger[]> map = new HashMap<Fluid, MekanismRenderer.DisplayInteger[]>();
            map.put(fluid, displays);
            this.cachedLiquids.put(side, map);
        }
        MekanismRenderer.colorFluid(fluid);
        for (int i = 0; i < 100; ++i) {
            displays[i] = MekanismRenderer.DisplayInteger.createAndStart();
            switch (side) {
                case UNKNOWN: {
                    toReturn.minX = 0.265;
                    toReturn.minY = 0.265;
                    toReturn.minZ = 0.265;
                    toReturn.maxX = 0.735;
                    toReturn.maxY = 0.265 + (double)((float)i / 100.0f) * 0.45;
                    toReturn.maxZ = 0.735;
                    break;
                }
                case DOWN: {
                    toReturn.minX = 0.5 - (double)((float)i / 100.0f) * 0.45 / 2.0;
                    toReturn.minY = 0.0;
                    toReturn.minZ = 0.5 - (double)((float)i / 100.0f) * 0.45 / 2.0;
                    toReturn.maxX = 0.5 + (double)((float)i / 100.0f) * 0.45 / 2.0;
                    toReturn.maxY = 0.265;
                    toReturn.maxZ = 0.5 + (double)((float)i / 100.0f) * 0.45 / 2.0;
                    break;
                }
                case UP: {
                    toReturn.minX = 0.5 - (double)((float)i / 100.0f) * 0.45 / 2.0;
                    toReturn.minY = 0.235 + (double)((float)i / 100.0f) * 0.45;
                    toReturn.minZ = 0.5 - (double)((float)i / 100.0f) * 0.45 / 2.0;
                    toReturn.maxX = 0.5 + (double)((float)i / 100.0f) * 0.45 / 2.0;
                    toReturn.maxY = 1.0;
                    toReturn.maxZ = 0.5 + (double)((float)i / 100.0f) * 0.45 / 2.0;
                    break;
                }
                case NORTH: {
                    toReturn.minX = 0.265;
                    toReturn.minY = 0.265;
                    toReturn.minZ = 0.0;
                    toReturn.maxX = 0.735;
                    toReturn.maxY = 0.265 + (double)((float)i / 100.0f) * 0.45;
                    toReturn.maxZ = 0.265;
                    break;
                }
                case SOUTH: {
                    toReturn.minX = 0.265;
                    toReturn.minY = 0.265;
                    toReturn.minZ = 0.735;
                    toReturn.maxX = 0.735;
                    toReturn.maxY = 0.265 + (double)((float)i / 100.0f) * 0.45;
                    toReturn.maxZ = 1.0;
                    break;
                }
                case WEST: {
                    toReturn.minX = 0.0;
                    toReturn.minY = 0.265;
                    toReturn.minZ = 0.265;
                    toReturn.maxX = 0.265;
                    toReturn.maxY = 0.265 + (double)((float)i / 100.0f) * 0.45;
                    toReturn.maxZ = 0.735;
                    break;
                }
                case EAST: {
                    toReturn.minX = 0.735;
                    toReturn.minY = 0.265;
                    toReturn.minZ = 0.265;
                    toReturn.maxX = 1.0;
                    toReturn.maxY = 0.265 + (double)((float)i / 100.0f) * 0.45;
                    toReturn.maxZ = 0.735;
                }
            }
            MekanismRenderer.renderObject(toReturn);
            MekanismRenderer.DisplayInteger cfr_ignored_0 = displays[i];
            MekanismRenderer.DisplayInteger.endList();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return displays;
    }

    public void renderContents(PartPressurizedTube tube, Vector3 pos) {
        if (((GasNetwork)tube.getTransmitterNetwork()).refGas == null || ((GasNetwork)tube.getTransmitterNetwork()).gasScale == 0.0f) {
            return;
        }
        GL11.glPushMatrix();
        CCRenderState.reset();
        CCRenderState.useNormals = true;
        CCRenderState.startDrawing();
        GL11.glTranslated((double)pos.x, (double)pos.y, (double)pos.z);
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            this.renderGasSide(side, tube);
        }
        MekanismRenderer.glowOn(0);
        MekanismRenderer.cullFrontFace();
        CCRenderState.draw();
        MekanismRenderer.disableCullFace();
        MekanismRenderer.glowOff();
        GL11.glPopMatrix();
    }

    public void renderStatic(PartSidedPipe transmitter) {
        CCRenderState.reset();
        CCRenderState.hasColour = true;
        CCRenderState.setBrightness((IBlockAccess)transmitter.world(), (int)transmitter.x(), (int)transmitter.y(), (int)transmitter.z());
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            this.renderSide(side, transmitter);
        }
    }

    public void renderSide(ForgeDirection side, PartSidedPipe transmitter) {
        boolean connected = PartTransmitter.connectionMapContainsSide(transmitter.getAllCurrentConnections(), side);
        IIcon renderIcon = transmitter.getIconForSide(side);
        ColourRGBA c = null;
        if (transmitter.getRenderColor() != null) {
            c = new ColourRGBA((double)transmitter.getRenderColor().getColor(0), (double)transmitter.getRenderColor().getColor(1), (double)transmitter.getRenderColor().getColor(2), 1.0);
        }
        this.renderPart(renderIcon, transmitter.getModelForSide(side, false), transmitter.x(), transmitter.y(), transmitter.z(), (Colour)c);
    }

    public void renderSide(ForgeDirection side, TransmitterType type) {
        boolean out = side == ForgeDirection.UP || side == ForgeDirection.DOWN;
        IIcon renderIcon = out ? type.getSideIcon() : type.getCenterIcon();
        this.renderPart(renderIcon, this.getItemModel(side, type), 0.0, 0.0, 0.0, null);
    }

    public void renderEnergySide(ForgeDirection side, PartUniversalCable cable) {
        CCRenderState.changeTexture((ResourceLocation)MekanismRenderer.getBlocksTexture());
        this.renderTransparency(MekanismRenderer.energyIcon, cable.getModelForSide(side, true), (Colour)new ColourRGBA(1.0, 1.0, 1.0, cable.currentPower));
    }

    public void renderFluidInOut(ForgeDirection side, PartMechanicalPipe pipe) {
        CCRenderState.changeTexture((ResourceLocation)MekanismRenderer.getBlocksTexture());
        this.renderTransparency(((FluidNetwork)pipe.getTransmitterNetwork()).refFluid.getIcon(), pipe.getModelForSide(side, true), (Colour)new ColourRGBA(1.0, 1.0, 1.0, (double)pipe.currentScale));
    }

    public void renderGasSide(ForgeDirection side, PartPressurizedTube tube) {
        CCRenderState.changeTexture((ResourceLocation)MekanismRenderer.getBlocksTexture());
        this.renderTransparency(((GasNetwork)tube.getTransmitterNetwork()).refGas.getIcon(), tube.getModelForSide(side, true), (Colour)new ColourRGBA(1.0, 1.0, 1.0, (double)tube.currentScale));
    }

    public void renderPart(IIcon icon, CCModel cc, double x, double y, double z, Colour color) {
        if (color != null) {
            cc.render(new CCRenderState.IVertexOperation[]{new Translation(x, y, z), new IconTransformation(icon), new ColourMultiplier(color.rgba())});
        } else {
            cc.render(new CCRenderState.IVertexOperation[]{new Translation(x, y, z), new IconTransformation(icon)});
        }
    }

    public void renderTransparency(IIcon icon, CCModel cc, Colour color) {
        if (color != null) {
            cc.render(new CCRenderState.IVertexOperation[]{new IconTransformation(icon), new ColourMultiplier(color.rgba())});
        } else {
            cc.render(new CCRenderState.IVertexOperation[]{new IconTransformation(icon)});
        }
    }

    public CCModel getItemModel(ForgeDirection side, TransmitterType type) {
        String name = side.name().toLowerCase();
        boolean out = side == ForgeDirection.UP || side == ForgeDirection.DOWN;
        name = name + (out ? "NORMAL" : "NONE");
        if (type.getSize() == TransmitterType.Size.SMALL) {
            return small_models.get(name);
        }
        return large_models.get(name);
    }

    public void registerIcons(IIconRegister register) {
        PartUniversalCable.registerIcons(register);
        PartMechanicalPipe.registerIcons(register);
        PartPressurizedTube.registerIcons(register);
        PartLogisticalTransporter.registerIcons(register);
    }

    public int atlasIndex() {
        return 0;
    }

    private void popTransporter() {
        GL11.glPopAttrib();
        MekanismRenderer.glowOff();
        MekanismRenderer.blendOff();
        GL11.glPopMatrix();
    }

    private void pushTransporter() {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2896);
        MekanismRenderer.glowOn();
        MekanismRenderer.blendOn();
    }

    private MekanismRenderer.DisplayInteger getOverlayDisplay(World world, ForgeDirection side, int mode) {
        if (this.cachedOverlays.containsKey(side) && this.cachedOverlays.get(side).containsKey(mode)) {
            return this.cachedOverlays.get(side).get(mode);
        }
        IIcon icon = null;
        switch (mode) {
            case 0: {
                icon = Items.field_151016_H.getIcon(new ItemStack(Items.field_151016_H), 0);
                break;
            }
            case 1: {
                icon = Blocks.field_150429_aA.func_149691_a(0, 0);
                break;
            }
            case 2: {
                icon = Blocks.field_150429_aA.func_149691_a(0, 0);
            }
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150348_b;
        toReturn.setTexture(icon);
        MekanismRenderer.DisplayInteger display = MekanismRenderer.DisplayInteger.createAndStart();
        if (this.cachedOverlays.containsKey(side)) {
            this.cachedOverlays.get(side).put(mode, display);
        } else {
            HashMap<Integer, MekanismRenderer.DisplayInteger> map = new HashMap<Integer, MekanismRenderer.DisplayInteger>();
            map.put(mode, display);
            this.cachedOverlays.put(side, map);
        }
        switch (side) {
            case DOWN: {
                toReturn.minY = -0.01;
                toReturn.maxY = 0.0;
                toReturn.minX = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case UP: {
                toReturn.minY = 1.0;
                toReturn.maxY = 1.01;
                toReturn.minX = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case NORTH: {
                toReturn.minZ = -0.01;
                toReturn.maxZ = 0.0;
                toReturn.minX = 0.0;
                toReturn.minY = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxY = 1.0;
                break;
            }
            case SOUTH: {
                toReturn.minZ = 1.0;
                toReturn.maxZ = 1.01;
                toReturn.minX = 0.0;
                toReturn.minY = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxY = 1.0;
                break;
            }
            case WEST: {
                toReturn.minX = -0.01;
                toReturn.maxX = 0.0;
                toReturn.minY = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxY = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case EAST: {
                toReturn.minX = 1.0;
                toReturn.maxX = 1.01;
                toReturn.minY = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxY = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
        }
        MekanismRenderer.renderObject(toReturn);
        display.endList();
        return display;
    }
}

