/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.item;

import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mekanism.api.EnumColor;
import mekanism.api.energy.IEnergizedItem;
import mekanism.client.ClientProxy;
import mekanism.client.MekanismClient;
import mekanism.client.model.ModelArmoredJetpack;
import mekanism.client.model.ModelAtomicDisassembler;
import mekanism.client.model.ModelEnergyCube;
import mekanism.client.model.ModelFreeRunners;
import mekanism.client.model.ModelGasMask;
import mekanism.client.model.ModelGasTank;
import mekanism.client.model.ModelJetpack;
import mekanism.client.model.ModelObsidianTNT;
import mekanism.client.model.ModelPortableTank;
import mekanism.client.model.ModelRobit;
import mekanism.client.model.ModelScubaTank;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.RenderGlowPanel;
import mekanism.client.render.RenderPartTransmitter;
import mekanism.client.render.entity.RenderBalloon;
import mekanism.client.render.tileentity.RenderBin;
import mekanism.client.render.tileentity.RenderPortableTank;
import mekanism.common.IEnergyCube;
import mekanism.common.Mekanism;
import mekanism.common.Tier;
import mekanism.common.block.BlockMachine;
import mekanism.common.inventory.InventoryBin;
import mekanism.common.item.ItemAtomicDisassembler;
import mekanism.common.item.ItemBalloon;
import mekanism.common.item.ItemBlockBasic;
import mekanism.common.item.ItemBlockMachine;
import mekanism.common.item.ItemFreeRunners;
import mekanism.common.item.ItemGasMask;
import mekanism.common.item.ItemRobit;
import mekanism.common.item.ItemScubaTank;
import mekanism.common.item.ItemWalkieTalkie;
import mekanism.common.multipart.ItemGlowPanel;
import mekanism.common.multipart.ItemPartTransmitter;
import mekanism.common.multipart.TransmitterType;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.tile.TileEntityPortableTank;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ItemRenderingHandler
implements IItemRenderer {
    public ModelRobit robit = new ModelRobit();
    public ModelChest electricChest = new ModelChest();
    public ModelEnergyCube energyCube = new ModelEnergyCube();
    public ModelEnergyCube.ModelEnergyCore energyCore = new ModelEnergyCube.ModelEnergyCore();
    public ModelGasTank gasTank = new ModelGasTank();
    public ModelObsidianTNT obsidianTNT = new ModelObsidianTNT();
    public ModelJetpack jetpack = new ModelJetpack();
    public ModelArmoredJetpack armoredJetpack = new ModelArmoredJetpack();
    public ModelGasMask gasMask = new ModelGasMask();
    public ModelScubaTank scubaTank = new ModelScubaTank();
    public ModelFreeRunners freeRunners = new ModelFreeRunners();
    public ModelAtomicDisassembler atomicDisassembler = new ModelAtomicDisassembler();
    public ModelPortableTank portableTank = new ModelPortableTank();
    private final RenderBalloon balloonRenderer = new RenderBalloon();
    private final RenderBin binRenderer;
    private final RenderPortableTank portableTankRenderer;
    private final RenderItem renderItem;

    public ItemRenderingHandler() {
        this.binRenderer = (RenderBin)((Object)TileEntityRendererDispatcher.field_147556_a.field_147559_m.get(TileEntityBin.class));
        this.portableTankRenderer = (RenderPortableTank)((Object)TileEntityRendererDispatcher.field_147556_a.field_147559_m.get(TileEntityPortableTank.class));
        this.renderItem = (RenderItem)RenderManager.field_78727_a.func_78715_a(EntityItem.class);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        if (item.func_77973_b() == Mekanism.WalkieTalkie) {
            return type != IItemRenderer.ItemRenderType.INVENTORY;
        }
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        RenderBlocks renderBlocks = (RenderBlocks)data[0];
        if (type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }
        if (item.func_77973_b() instanceof IEnergyCube) {
            Tier.EnergyCubeTier tier = ((IEnergyCube)item.func_77973_b()).getEnergyCubeTier(item);
            IEnergizedItem energized = (IEnergizedItem)item.func_77973_b();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "EnergyCube" + tier.name + ".png"));
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)270.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
            this.energyCube.render(0.0625f);
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)1.0, (double)0.0);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "EnergyCore.png"));
            GL11.glShadeModel((int)7425);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            MekanismRenderer.glowOn();
            EnumColor c = tier.color;
            GL11.glPushMatrix();
            GL11.glScalef((float)0.4f, (float)0.4f, (float)0.4f);
            GL11.glColor4f((float)c.getColor(0), (float)c.getColor(1), (float)c.getColor(2), (float)((float)(energized.getEnergy(item) / energized.getMaxEnergy(item))));
            GL11.glTranslatef((float)0.0f, (float)((float)Math.sin(Math.toRadians(((float)MekanismClient.ticksPassed + MekanismRenderer.getPartialTick()) * 3.0f)) / 7.0f), (float)0.0f);
            GL11.glRotatef((float)(((float)MekanismClient.ticksPassed + MekanismRenderer.getPartialTick()) * 4.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(36.0f + ((float)MekanismClient.ticksPassed + MekanismRenderer.getPartialTick()) * 4.0f), (float)0.0f, (float)1.0f, (float)1.0f);
            this.energyCore.render(0.0625f);
            GL11.glPopMatrix();
            MekanismRenderer.glowOff();
            GL11.glShadeModel((int)7424);
            GL11.glDisable((int)2848);
            GL11.glDisable((int)2881);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        } else if (item.func_77973_b() instanceof ItemBlockBasic && item.func_77960_j() == 6) {
            RenderingRegistry.instance().renderInventoryBlock((RenderBlocks)data[0], Mekanism.BasicBlock, item.func_77960_j(), ClientProxy.BASIC_RENDER_ID);
            if (this.binRenderer == null || this.binRenderer.func_147498_b() == null) {
                return;
            }
            InventoryBin inv = new InventoryBin(item);
            ForgeDirection side = ForgeDirection.getOrientation((int)2);
            String amount = "";
            ItemStack itemStack = inv.getStack();
            if (itemStack != null) {
                amount = Integer.toString(inv.getItemCount());
            }
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            if (itemStack != null) {
                GL11.glPushMatrix();
                if (!(itemStack.func_77973_b() instanceof ItemBlock) || Block.func_149634_a((Item)itemStack.func_77973_b()).func_149645_b() != 0) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)-1.02f, (float)-0.2f, (float)0.0f);
                    if (type == IItemRenderer.ItemRenderType.INVENTORY) {
                        GL11.glTranslatef((float)-0.45f, (float)-0.4f, (float)0.0f);
                    }
                }
                if (type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON || type == IItemRenderer.ItemRenderType.ENTITY) {
                    GL11.glTranslatef((float)-0.22f, (float)-0.2f, (float)-0.22f);
                }
                GL11.glTranslated((double)0.73, (double)0.08, (double)0.44);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                float scale = 0.03125f;
                float scaler = 0.9f;
                GL11.glScalef((float)(scale * scaler), (float)(scale * scaler), (float)0.0f);
                TextureManager renderEngine = Minecraft.func_71410_x().field_71446_o;
                GL11.glDisable((int)2896);
                this.renderItem.func_82406_b(this.binRenderer.func_147498_b(), renderEngine, itemStack, 0, 0);
                GL11.glEnable((int)2896);
                GL11.glPopMatrix();
            }
            if (amount != "") {
                float maxScale = 0.02f;
                GL11.glPushMatrix();
                GL11.glPolygonOffset((float)-10.0f, (float)-10.0f);
                GL11.glEnable((int)32823);
                float displayWidth = 1.0f;
                float displayHeight = 1.0f;
                GL11.glTranslatef((float)0.0f, (float)-0.31f, (float)0.0f);
                if (type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON || type == IItemRenderer.ItemRenderType.ENTITY) {
                    GL11.glTranslated((double)-0.5, (double)-0.4, (double)-0.5);
                }
                GL11.glTranslatef((float)0.0f, (float)0.9f, (float)1.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)(displayWidth / 2.0f), (float)1.0f, (float)(displayHeight / 2.0f));
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                FontRenderer fontRenderer = this.binRenderer.func_147498_b();
                int requiredWidth = Math.max(fontRenderer.func_78256_a(amount), 1);
                int lineHeight = fontRenderer.field_78288_b + 2;
                int requiredHeight = lineHeight * 1;
                float scaler = 0.4f;
                float scaleX = displayWidth / (float)requiredWidth;
                float scale = scaleX * scaler;
                if (maxScale > 0.0f) {
                    scale = Math.min(scale, maxScale);
                }
                GL11.glScalef((float)scale, (float)(-scale), (float)scale);
                GL11.glDepthMask((boolean)false);
                int realHeight = (int)Math.floor(displayHeight / scale);
                int realWidth = (int)Math.floor(displayWidth / scale);
                int offsetX = (realWidth - requiredWidth) / 2;
                int offsetY = (realHeight - requiredHeight) / 2;
                GL11.glDisable((int)2896);
                fontRenderer.func_78276_b("\u00a7f" + amount, offsetX - realWidth / 2, 1 + offsetY - realHeight / 2, 1);
                GL11.glEnable((int)2896);
                GL11.glDepthMask((boolean)true);
                GL11.glDisable((int)32823);
                GL11.glPopMatrix();
            }
        } else if (Block.func_149634_a((Item)item.func_77973_b()) == Mekanism.GasTank) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "GasTank.png"));
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)270.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
            this.gasTank.render(0.0625f);
        } else if (Block.func_149634_a((Item)item.func_77973_b()) == Mekanism.ObsidianTNT) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "ObsidianTNT.png"));
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
            this.obsidianTNT.render(0.0625f);
        } else if (item.func_77973_b() instanceof ItemWalkieTalkie) {
            if (((ItemWalkieTalkie)item.func_77973_b()).getOn(item)) {
                MekanismRenderer.glowOn();
            }
            MekanismRenderer.renderItem(item);
            if (((ItemWalkieTalkie)item.func_77973_b()).getOn(item)) {
                MekanismRenderer.glowOff();
            }
        } else if (BlockMachine.MachineType.get(item) == BlockMachine.MachineType.ELECTRIC_CHEST) {
            ItemBlockMachine chest = (ItemBlockMachine)item.func_77973_b();
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            GL11.glTranslatef((float)0.0f, (float)1.0f, (float)1.0f);
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "ElectricChest.png"));
            this.electricChest.func_78231_a();
        } else if (item.func_77973_b() instanceof ItemRobit) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-1.5f, (float)0.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "Robit.png"));
            this.robit.render(0.08f);
        } else if (item.func_77973_b() == Mekanism.Jetpack) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.2f, (float)-0.35f, (float)0.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "Jetpack.png"));
            this.jetpack.render(0.0625f);
        } else if (item.func_77973_b() == Mekanism.ArmoredJetpack) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.2f, (float)-0.35f, (float)0.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "Jetpack.png"));
            this.armoredJetpack.render(0.0625f);
        } else if (item.func_77973_b() instanceof ItemGasMask) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.1f, (float)0.2f, (float)0.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "ScubaSet.png"));
            this.gasMask.render(0.0625f);
        } else if (item.func_77973_b() instanceof ItemScubaTank) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
            GL11.glScalef((float)1.6f, (float)1.6f, (float)1.6f);
            GL11.glTranslatef((float)0.2f, (float)-0.5f, (float)0.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "ScubaSet.png"));
            this.scubaTank.render(0.0625f);
        } else if (item.func_77973_b() instanceof ItemFreeRunners) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
            GL11.glTranslatef((float)0.2f, (float)-1.43f, (float)0.12f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "FreeRunners.png"));
            this.freeRunners.render(0.0625f);
        } else if (item.func_77973_b() instanceof ItemBalloon) {
            if (type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
                GL11.glScalef((float)2.5f, (float)2.5f, (float)2.5f);
                GL11.glTranslatef((float)0.2f, (float)0.0f, (float)0.1f);
                GL11.glRotatef((float)15.0f, (float)-1.0f, (float)0.0f, (float)1.0f);
                this.balloonRenderer.render(((ItemBalloon)item.func_77973_b()).getColor(item), 0.0, 1.9f, 0.0);
            } else {
                this.balloonRenderer.render(((ItemBalloon)item.func_77973_b()).getColor(item), 0.0, 1.0, 0.0);
            }
        } else if (item.func_77973_b() instanceof ItemAtomicDisassembler) {
            GL11.glPushMatrix();
            GL11.glScalef((float)1.4f, (float)1.4f, (float)1.4f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
                GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)50.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
                GL11.glTranslatef((float)0.0f, (float)-0.4f, (float)0.4f);
            } else if (type == IItemRenderer.ItemRenderType.INVENTORY) {
                GL11.glRotatef((float)225.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)-1.0f, (float)0.0f, (float)-1.0f);
                GL11.glScalef((float)0.6f, (float)0.6f, (float)0.6f);
                GL11.glTranslatef((float)0.0f, (float)-0.2f, (float)0.0f);
            } else {
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)-0.7f, (float)0.0f);
            }
            Minecraft.func_71410_x().field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "AtomicDisassembler.png"));
            this.atomicDisassembler.render(0.0625f);
            GL11.glPopMatrix();
        } else if (item.func_77973_b() instanceof ItemPartTransmitter) {
            GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
            MekanismRenderer.blendOn();
            GL11.glDisable((int)2884);
            RenderPartTransmitter.getInstance().renderItem(TransmitterType.values()[item.func_77960_j()]);
            GL11.glEnable((int)2884);
            MekanismRenderer.blendOff();
        } else if (item.func_77973_b() instanceof ItemGlowPanel) {
            GL11.glPushAttrib((int)64);
            GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
            double d = 0.15;
            GL11.glTranslated((double)d, (double)d, (double)d);
            GL11.glScaled((double)2.0, (double)2.0, (double)2.0);
            GL11.glTranslated((double)(0.4 - 2.0 * d), (double)(-2.0 * d), (double)(-2.0 * d));
            GL11.glDisable((int)2884);
            RenderHelper.func_74518_a();
            RenderGlowPanel.getInstance().renderItem(item.func_77960_j());
            GL11.glEnable((int)2884);
            GL11.glPopAttrib();
        } else if (BlockMachine.MachineType.get(item) == BlockMachine.MachineType.PORTABLE_TANK) {
            GL11.glRotatef((float)270.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "PortableTank.png"));
            ItemBlockMachine itemMachine = (ItemBlockMachine)item.func_77973_b();
            Fluid fluid = itemMachine.getFluidStack(item) != null ? itemMachine.getFluidStack(item).getFluid() : null;
            this.portableTankRenderer.render(fluid, itemMachine.getPrevScale(item), false, null, -0.5, -0.5, -0.5);
        } else if (item.func_77973_b() instanceof ItemBlockMachine) {
            RenderingRegistry.instance().renderInventoryBlock((RenderBlocks)data[0], Block.func_149634_a((Item)item.func_77973_b()), item.func_77960_j(), ClientProxy.MACHINE_RENDER_ID);
        } else if (item.func_77973_b() instanceof ItemBlockBasic) {
            RenderingRegistry.instance().renderInventoryBlock((RenderBlocks)data[0], Block.func_149634_a((Item)item.func_77973_b()), item.func_77960_j(), ClientProxy.BASIC_RENDER_ID);
        }
    }
}

