/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.sound;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import mekanism.api.Coord4D;
import mekanism.client.HolidayManager;
import mekanism.client.MekanismClient;
import mekanism.client.sound.IHasSound;
import mekanism.client.sound.Sound;
import mekanism.client.sound.TileSound;
import mekanism.common.Mekanism;
import mekanism.common.ObfuscatedNames;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;
import paulscode.sound.SoundSystem;

@SideOnly(value=Side.CLIENT)
public class SoundHandler {
    public Map<Object, Sound> sounds = Collections.synchronizedMap(new HashMap());
    public static Minecraft mc = Minecraft.func_71410_x();

    public SoundHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        Mekanism.logger.info("Successfully set up SoundHandler.");
    }

    public void preloadSounds() {
        CodeSource src = this.getClass().getProtectionDomain().getCodeSource();
        String corePath = src.getLocation().getFile().split("/mekanism/client")[0];
        List<String> listings = this.listFiles(corePath.replace("%20", " ").replace(".jar!", ".jar").replace("file:", ""), "assets/mekanism/sounds");
        for (String s : listings) {
            if (s.contains("etc") || s.contains("holiday")) continue;
            if (s.contains("/mekanism/sounds/")) {
                s = s.split("/mekanism/sounds/")[1];
            }
            this.preloadSound(s);
        }
        Mekanism.logger.info("Preloaded " + listings.size() + " object sounds.");
        if (MekanismClient.holidays) {
            listings = this.listFiles(corePath.replace("%20", " ").replace(".jar!", ".jar").replace("file:", ""), "assets/mekanism/sounds/holiday");
            for (String s : listings) {
                if (s.contains("/mekanism/sounds/")) {
                    s = s.split("/mekanism/sounds/")[1];
                }
                if (!s.contains("holiday")) {
                    s = "holiday/" + s;
                }
                this.preloadSound(s);
            }
        }
    }

    private List<String> listFiles(String path, String s) {
        ArrayList<String> names = new ArrayList<String>();
        File f = new File(path);
        if (!f.exists()) {
            return names;
        }
        if (!f.isDirectory()) {
            try {
                ZipEntry e;
                ZipInputStream zip = new ZipInputStream(new FileInputStream(path));
                while ((e = zip.getNextEntry()) != null) {
                    String name = e.getName();
                    if (!name.contains(s) || !name.endsWith(".ogg")) continue;
                    names.add(name);
                }
                zip.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            f = new File(path + "/" + s);
            for (File file : f.listFiles()) {
                if (!file.getPath().contains(s) || !file.getName().endsWith(".ogg")) continue;
                names.add(file.getName());
            }
        }
        return names;
    }

    private void preloadSound(String sound) {
        String id = "pre_" + sound;
        URL url = this.getClass().getClassLoader().getResource("assets/mekanism/sounds/" + sound);
        if (SoundHandler.getSoundSystem() != null) {
            SoundHandler.getSoundSystem().newSource(false, id, url, sound, true, 0.0f, 0.0f, 0.0f, 0, 16.0f);
            SoundHandler.getSoundSystem().activate(id);
            SoundHandler.getSoundSystem().removeSource(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTick() {
        Map<Object, Sound> map = this.sounds;
        synchronized (map) {
            if (SoundHandler.getSoundSystem() != null) {
                if (!Mekanism.proxy.isPaused()) {
                    ArrayList<Sound> soundsToRemove = new ArrayList<Sound>();
                    WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
                    for (Sound sound : this.sounds.values()) {
                        if (FMLClientHandler.instance().getClient().field_71439_g == null || world == null || sound.update((World)world)) continue;
                        soundsToRemove.add(sound);
                    }
                    for (Sound sound : soundsToRemove) {
                        sound.remove();
                    }
                    for (Sound sound : this.sounds.values()) {
                        if (!sound.isPlaying) continue;
                        sound.updateVolume();
                    }
                } else {
                    for (Sound sound : this.sounds.values()) {
                        if (!sound.isPlaying) continue;
                        sound.stopLoop();
                    }
                }
            } else {
                Mekanism.proxy.unloadSoundHandler();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sound getFrom(Object obj) {
        Map<Object, Sound> map = this.sounds;
        synchronized (map) {
            return this.sounds.get(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Object obj) {
        if (obj instanceof TileEntity && !(obj instanceof IHasSound)) {
            return;
        }
        Map<Object, Sound> map = this.sounds;
        synchronized (map) {
            if (this.getFrom(obj) == null && obj instanceof TileEntity) {
                new TileSound(this.getIdentifier(), HolidayManager.filterSound(((IHasSound)obj).getSoundPath()), (TileEntity)obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIdentifier() {
        Map<Object, Sound> map = this.sounds;
        synchronized (map) {
            String toReturn = "Mekanism_" + this.sounds.size() + "_" + new Random().nextInt(10000);
            for (Sound sound : this.sounds.values()) {
                if (!sound.identifier.equals(toReturn)) continue;
                return this.getIdentifier();
            }
            return toReturn;
        }
    }

    public void quickPlay(String soundPath, World world, Coord4D object) {
        URL url = this.getClass().getClassLoader().getResource("assets/mekanism/sounds/" + soundPath);
        if (url == null) {
            Mekanism.logger.info("Invalid sound file: " + soundPath);
        }
        String s = SoundHandler.getSoundSystem().quickPlay(false, url, soundPath, false, (float)object.xCoord, (float)object.yCoord, (float)object.zCoord, 0, 16.0f);
        SoundHandler.getSoundSystem().setVolume(s, this.getMasterVolume());
    }

    public float getMasterVolume() {
        return FMLClientHandler.instance().getClient().field_71474_y.func_151438_a(SoundCategory.MASTER);
    }

    public static SoundSystem getSoundSystem() {
        try {
            return (SoundSystem)MekanismUtils.getPrivateValue(SoundHandler.getSoundManager(), SoundManager.class, ObfuscatedNames.SoundManager_sndSystem);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static SoundManager getSoundManager() {
        try {
            return (SoundManager)MekanismUtils.getPrivateValue(mc.func_147118_V(), net.minecraft.client.audio.SoundHandler.class, ObfuscatedNames.SoundHandler_sndManager);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isSystemLoaded() {
        try {
            return (Boolean)MekanismUtils.getPrivateValue(SoundHandler.getSoundManager(), SoundManager.class, new String[]{"loaded"});
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void playSound(String sound) {
        mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation(sound), (float)1.0f));
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        if (event.getChunk() != null) {
            for (Object obj : event.getChunk().field_150816_i.values()) {
                TileEntity tileEntity;
                if (!(obj instanceof TileEntity) || !((tileEntity = (TileEntity)obj) instanceof IHasSound) || this.getFrom(tileEntity) == null || !this.sounds.containsKey(tileEntity)) continue;
                this.getFrom(tileEntity).remove();
            }
        }
    }
}

