/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.sound;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mekanism.api.Pos3D;
import mekanism.client.HolidayManager;
import mekanism.client.sound.IHasSound;
import mekanism.client.sound.Sound;
import mekanism.common.IActiveState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class TileSound
extends Sound {
    public TileEntity tileEntity;

    public TileSound(String id, String sound, TileEntity tileentity) {
        super(id, sound, tileentity, new Pos3D(tileentity));
        this.tileEntity = tileentity;
    }

    @Override
    public float getMultiplier() {
        return super.getMultiplier() * ((IHasSound)this.tileEntity).getVolumeMultiplier();
    }

    @Override
    public Pos3D getLocation() {
        return new Pos3D(this.tileEntity);
    }

    @Override
    public boolean update(World world) {
        if (!(this.tileEntity instanceof IHasSound)) {
            return false;
        }
        if (world.func_147438_o(this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e) != this.tileEntity) {
            return false;
        }
        if (!HolidayManager.filterSound(((IHasSound)this.tileEntity).getSoundPath()).equals(this.soundPath)) {
            return false;
        }
        if (this.tileEntity instanceof IActiveState && ((IActiveState)this.tileEntity).getActive() != this.isPlaying) {
            if (((IActiveState)this.tileEntity).getActive()) {
                this.play();
            } else {
                this.stopLoop();
            }
        }
        if (this.isPlaying) {
            ++this.ticksSincePlay;
        }
        return true;
    }
}

