/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.tank.DynamicTankCache;
import mekanism.common.tile.TileEntityDynamicTank;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CommonWorldTickHandler {
    private static final long maximumDeltaTimeNanoSecs = 16000000L;
    private HashMap<Integer, Queue<ChunkCoordIntPair>> chunkRegenMap;

    public void addRegenChunk(int dimensionId, ChunkCoordIntPair chunkCoord) {
        if (this.chunkRegenMap == null) {
            this.chunkRegenMap = new HashMap();
        }
        if (!this.chunkRegenMap.containsKey(dimensionId)) {
            LinkedList<ChunkCoordIntPair> list = new LinkedList<ChunkCoordIntPair>();
            list.add(chunkCoord);
            this.chunkRegenMap.put(dimensionId, list);
        } else if (!this.chunkRegenMap.get(dimensionId).contains(chunkCoord)) {
            this.chunkRegenMap.get(dimensionId).add(chunkCoord);
        }
    }

    public void resetRegenChunks() {
        if (this.chunkRegenMap != null) {
            this.chunkRegenMap.clear();
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.END) {
            this.tickEnd(event.world);
        }
    }

    public void tickEnd(World world) {
        ArrayList<Integer> idsToKill = new ArrayList<Integer>();
        HashMap tilesToKill = new HashMap();
        if (!world.field_72995_K) {
            for (Map.Entry<Integer, DynamicTankCache> entry : Mekanism.dynamicInventories.entrySet()) {
                int inventoryID = entry.getKey();
                for (Coord4D obj : entry.getValue().locations) {
                    TileEntity tileEntity;
                    if (obj.dimensionId != world.field_73011_w.field_76574_g || (tileEntity = obj.getTileEntity((IBlockAccess)world)) instanceof TileEntityDynamicTank && ((TileEntityDynamicTank)tileEntity).inventoryID == inventoryID) continue;
                    if (!tilesToKill.containsKey(inventoryID)) {
                        tilesToKill.put(inventoryID, new HashSet());
                    }
                    ((HashSet)tilesToKill.get(inventoryID)).add(obj);
                }
                if (!entry.getValue().locations.isEmpty()) continue;
                idsToKill.add(inventoryID);
            }
            for (Map.Entry<Integer, DynamicTankCache> entry : tilesToKill.entrySet()) {
                for (Coord4D obj : (HashSet)((Object)entry.getValue())) {
                    Mekanism.dynamicInventories.get((Object)entry.getKey()).locations.remove(obj);
                }
            }
            Iterator<Map.Entry<Integer, DynamicTankCache>> i$ = idsToKill.iterator();
            while (i$.hasNext()) {
                int n = (Integer)((Object)i$.next());
                for (Coord4D obj : Mekanism.dynamicInventories.get((Object)Integer.valueOf((int)n)).locations) {
                    TileEntityDynamicTank dynamicTank = (TileEntityDynamicTank)obj.getTileEntity((IBlockAccess)world);
                    if (dynamicTank == null) continue;
                    dynamicTank.cachedData = new DynamicTankCache();
                    dynamicTank.inventory = new ItemStack[2];
                    dynamicTank.inventoryID = -1;
                }
                Mekanism.dynamicInventories.remove(n);
            }
            if (this.chunkRegenMap == null) {
                return;
            }
            int dimensionId = world.field_73011_w.field_76574_g;
            if (this.chunkRegenMap.containsKey(dimensionId)) {
                ChunkCoordIntPair nextChunk;
                Queue<ChunkCoordIntPair> queue = this.chunkRegenMap.get(dimensionId);
                long startTime = System.nanoTime();
                while (System.nanoTime() - startTime < 16000000L && !queue.isEmpty() && (nextChunk = queue.poll()) != null) {
                    Random fmlRandom = new Random(world.func_72905_C());
                    long xSeed = fmlRandom.nextLong() >> 3;
                    long zSeed = fmlRandom.nextLong() >> 3;
                    fmlRandom.setSeed(xSeed * (long)nextChunk.field_77276_a + zSeed * (long)nextChunk.field_77275_b ^ world.func_72905_C());
                    Mekanism.genHandler.generate(fmlRandom, nextChunk.field_77276_a, nextChunk.field_77275_b, world, world.func_72863_F(), world.func_72863_F());
                    Mekanism.logger.info("[Mekanism] Regenerating ores at chunk " + nextChunk);
                }
                if (queue.isEmpty()) {
                    this.chunkRegenMap.remove(dimensionId);
                }
            }
        }
    }
}

