/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

public class EnergyDisplay {
    public static String getDisplay(double value, ElectricUnit unit, int decimalPlaces, boolean isShort) {
        String unitName = unit.name;
        String prefix = "";
        if (value < 0.0) {
            value = Math.abs(value);
            prefix = "-";
        }
        if (isShort) {
            unitName = unit.symbol;
        } else if (value > 1.0) {
            unitName = unit.getPlural();
        }
        if (value == 0.0) {
            return value + " " + unitName;
        }
        for (int i = 0; i < MeasurementUnit.values().length; ++i) {
            MeasurementUnit lowerMeasure = MeasurementUnit.values()[i];
            if (lowerMeasure.below(value) && lowerMeasure.ordinal() == 0) {
                return prefix + EnergyDisplay.roundDecimals(lowerMeasure.process(value), decimalPlaces) + " " + lowerMeasure.getName(isShort) + unitName;
            }
            if (lowerMeasure.ordinal() + 1 >= MeasurementUnit.values().length) {
                return prefix + EnergyDisplay.roundDecimals(lowerMeasure.process(value), decimalPlaces) + " " + lowerMeasure.getName(isShort) + unitName;
            }
            MeasurementUnit upperMeasure = MeasurementUnit.values()[i + 1];
            if ((!lowerMeasure.above(value) || !upperMeasure.below(value)) && lowerMeasure.value != value) continue;
            return prefix + EnergyDisplay.roundDecimals(lowerMeasure.process(value), decimalPlaces) + " " + lowerMeasure.getName(isShort) + unitName;
        }
        return prefix + EnergyDisplay.roundDecimals(value, decimalPlaces) + " " + unitName;
    }

    public static String getDisplay(double value, ElectricUnit unit) {
        return EnergyDisplay.getDisplay(value, unit, 2, false);
    }

    public static String getDisplayShort(double value, ElectricUnit unit) {
        return EnergyDisplay.getDisplay(value, unit, 2, true);
    }

    public static String getDisplayShort(double value, ElectricUnit unit, int decimalPlaces) {
        return EnergyDisplay.getDisplay(value, unit, decimalPlaces, true);
    }

    public static String getDisplaySimple(double value, ElectricUnit unit, int decimalPlaces) {
        if (value > 1.0) {
            if (decimalPlaces < 1) {
                return (int)value + " " + unit.getPlural();
            }
            return EnergyDisplay.roundDecimals(value, decimalPlaces) + " " + unit.getPlural();
        }
        if (decimalPlaces < 1) {
            return (int)value + " " + unit.name;
        }
        return EnergyDisplay.roundDecimals(value, decimalPlaces) + " " + unit.name;
    }

    public static double roundDecimals(double d, int decimalPlaces) {
        int j = (int)(d * Math.pow(10.0, decimalPlaces));
        return (double)j / Math.pow(10.0, decimalPlaces);
    }

    public static double roundDecimals(double d) {
        return EnergyDisplay.roundDecimals(d, 2);
    }

    public static enum EnergyType {
        J,
        RF,
        EU,
        MJ;

    }

    public static enum MeasurementUnit {
        MICRO("Micro", "u", 1.0E-6),
        MILLI("Milli", "m", 0.001),
        BASE("", "", 1.0),
        KILO("Kilo", "k", 1000.0),
        MEGA("Mega", "M", 1000000.0),
        GIGA("Giga", "G", 1.0E9),
        TERA("Tera", "T", 1.0E12),
        PETA("Peta", "P", 1.0E15),
        EXA("Exa", "E", 1.0E18),
        ZETTA("Zetta", "Z", 1.0E21),
        YOTTA("Yotta", "Y", 1.0E24);

        public String name;
        public String symbol;
        public double value;

        private MeasurementUnit(String s, String s1, double v) {
            this.name = s;
            this.symbol = s1;
            this.value = v;
        }

        public String getName(boolean getShort) {
            if (getShort) {
                return this.symbol;
            }
            return this.name;
        }

        public double process(double d) {
            return d / this.value;
        }

        public boolean above(double d) {
            return d > this.value;
        }

        public boolean below(double d) {
            return d < this.value;
        }
    }

    public static enum ElectricUnit {
        AMPERE("Amp", "I"),
        AMP_HOUR("Amp Hour", "Ah"),
        VOLTAGE("Volt", "V"),
        WATT("Watt", "W"),
        WATT_HOUR("Watt Hour", "Wh"),
        RESISTANCE("Ohm", "R"),
        CONDUCTANCE("Siemen", "S"),
        JOULES("Joule", "J");

        public String name;
        public String symbol;

        private ElectricUnit(String s, String s1) {
            this.name = s;
            this.symbol = s1;
        }

        public String getPlural() {
            return this.name + "s";
        }
    }
}

