/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import buildcraft.api.mj.IBatteryObject;
import buildcraft.api.mj.MjAPI;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergySink;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.ListUtils;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.util.CableUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class EnergyNetwork
extends DynamicNetwork<TileEntity, EnergyNetwork> {
    private double lastPowerScale = 0.0;
    private double joulesTransmitted = 0.0;
    private double jouleBufferLastTick = 0.0;
    public double clientEnergyScale = 0.0;
    public double electricityStored;

    public EnergyNetwork(IGridTransmitter<EnergyNetwork> ... varCables) {
        this.transmitters.addAll(Arrays.asList(varCables));
        this.register();
    }

    public EnergyNetwork(Collection<IGridTransmitter<EnergyNetwork>> collection) {
        this.transmitters.addAll(collection);
        this.register();
    }

    public EnergyNetwork(Set<EnergyNetwork> networks) {
        for (EnergyNetwork net : networks) {
            if (net == null) continue;
            if (net.jouleBufferLastTick > this.jouleBufferLastTick || net.clientEnergyScale > this.clientEnergyScale) {
                this.clientEnergyScale = net.clientEnergyScale;
                this.jouleBufferLastTick = net.jouleBufferLastTick;
                this.joulesTransmitted = net.joulesTransmitted;
                this.lastPowerScale = net.lastPowerScale;
            }
            this.electricityStored += net.electricityStored;
            this.addAllTransmitters(net.transmitters);
            net.deregister();
        }
        this.register();
    }

    public static double round(double d) {
        return Math.round(d * 10000.0) / 10000L;
    }

    @Override
    protected synchronized void updateMeanCapacity() {
        int numCables = this.transmitters.size();
        double reciprocalSum = 0.0;
        for (IGridTransmitter cable : this.transmitters) {
            reciprocalSum += 1.0 / (double)cable.getCapacity();
        }
        this.meanCapacity = (double)numCables / reciprocalSum;
    }

    @Override
    public void onNetworksCreated(List<EnergyNetwork> networks) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            double[] caps = new double[networks.size()];
            double cap = 0.0;
            for (EnergyNetwork network : networks) {
                double networkCapacity;
                caps[networks.indexOf((Object)network)] = networkCapacity = (double)network.getCapacity();
                cap += networkCapacity;
            }
            this.electricityStored = Math.min(cap, this.electricityStored);
            double[] percent = ListUtils.percent(caps);
            for (EnergyNetwork network : networks) {
                network.electricityStored = EnergyNetwork.round(percent[networks.indexOf(network)] * this.electricityStored);
            }
        }
    }

    public synchronized double getEnergyNeeded() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return 0.0;
        }
        return (double)this.getCapacity() - this.electricityStored;
    }

    public synchronized double tickEmit(double energyToSend) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return 0.0;
        }
        double sent = 0.0;
        boolean tryAgain = false;
        int i = 0;
        do {
            double prev = sent;
            tryAgain = energyToSend - (sent += this.doEmit(energyToSend - sent, tryAgain)) > 0.0 && sent - prev > 0.0 && i < 100;
            ++i;
        } while (tryAgain);
        this.joulesTransmitted = sent;
        return sent;
    }

    public synchronized double emit(double energyToSend) {
        double toUse = Math.min(this.getEnergyNeeded(), energyToSend);
        this.electricityStored += toUse;
        return energyToSend - toUse;
    }

    public synchronized double doEmit(double energyToSend, boolean tryAgain) {
        double sent = 0.0;
        List<Object> availableAcceptors = Arrays.asList(this.getAcceptors(new Object[0]).toArray());
        Collections.shuffle(availableAcceptors);
        if (!availableAcceptors.isEmpty()) {
            int divider = availableAcceptors.size();
            double remaining = energyToSend % (double)divider;
            double sending = (energyToSend - remaining) / (double)divider;
            for (Object obj : availableAcceptors) {
                if (!(obj instanceof TileEntity)) continue;
                TileEntity acceptor = (TileEntity)obj;
                double currentSending = sending + remaining;
                ForgeDirection side = (ForgeDirection)this.acceptorDirections.get(acceptor);
                if (side == null) continue;
                remaining = 0.0;
                if (acceptor instanceof IStrictEnergyAcceptor) {
                    sent += ((IStrictEnergyAcceptor)acceptor).transferEnergyToAcceptor(side.getOpposite(), currentSending);
                    continue;
                }
                if (MekanismUtils.useRF() && acceptor instanceof IEnergyHandler) {
                    IEnergyHandler handler = (IEnergyHandler)acceptor;
                    int used = handler.receiveEnergy(side.getOpposite(), (int)Math.round(currentSending * Mekanism.TO_TE), false);
                    sent += (double)used * Mekanism.FROM_TE;
                    continue;
                }
                if (MekanismUtils.useIC2() && acceptor instanceof IEnergySink) {
                    double toSend = Math.min(currentSending, EnergyNet.instance.getPowerFromTier(((IEnergySink)acceptor).getSinkTier()) * Mekanism.FROM_IC2);
                    toSend = Math.min(toSend, ((IEnergySink)acceptor).getDemandedEnergy() * Mekanism.FROM_IC2);
                    sent += toSend - ((IEnergySink)acceptor).injectEnergy(side.getOpposite(), toSend * Mekanism.TO_IC2, 0.0) * Mekanism.FROM_IC2;
                    continue;
                }
                if (!MekanismUtils.useBuildCraft() || MjAPI.getMjBattery((Object)acceptor, (String)"buildcraft.kinesis", (ForgeDirection)side.getOpposite()) == null || tryAgain) continue;
                IBatteryObject battery = MjAPI.getMjBattery((Object)acceptor, (String)"buildcraft.kinesis", (ForgeDirection)side.getOpposite());
                double toSend = battery.addEnergy(Math.min(battery.getEnergyRequested(), currentSending * Mekanism.TO_BC));
                sent += toSend * Mekanism.FROM_BC;
            }
        }
        return sent;
    }

    @Override
    public synchronized Set<TileEntity> getAcceptors(Object ... data) {
        HashSet<TileEntity> toReturn = new HashSet<TileEntity>();
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return toReturn;
        }
        for (TileEntity acceptor : ((Map)this.possibleAcceptors.clone()).values()) {
            IBatteryObject battery;
            IStrictEnergyAcceptor handler;
            ForgeDirection side = (ForgeDirection)this.acceptorDirections.get(acceptor);
            if (side == null) continue;
            if (acceptor instanceof IStrictEnergyAcceptor) {
                handler = (IStrictEnergyAcceptor)acceptor;
                if (!handler.canReceiveEnergy(side.getOpposite()) || !(handler.getMaxEnergy() - handler.getEnergy() > 0.0)) continue;
                toReturn.add(acceptor);
                continue;
            }
            if (MekanismUtils.useRF() && acceptor instanceof IEnergyHandler) {
                handler = (IEnergyHandler)acceptor;
                if (!handler.canConnectEnergy(side.getOpposite()) || handler.receiveEnergy(side.getOpposite(), 1, true) <= 0) continue;
                toReturn.add(acceptor);
                continue;
            }
            if (MekanismUtils.useIC2() && acceptor instanceof IEnergySink) {
                int tier;
                double max;
                double demanded;
                handler = (IEnergySink)acceptor;
                if (!handler.acceptsEnergyFrom(null, side.getOpposite()) || !(Math.min(demanded = handler.getDemandedEnergy() * Mekanism.FROM_IC2, max = EnergyNet.instance.getPowerFromTier(tier = Math.min(handler.getSinkTier(), 8)) * Mekanism.FROM_IC2) > 0.0)) continue;
                toReturn.add(acceptor);
                continue;
            }
            if (!MekanismUtils.useBuildCraft() || MjAPI.getMjBattery((Object)acceptor, (String)"buildcraft.kinesis", (ForgeDirection)side.getOpposite()) == null || !((battery = MjAPI.getMjBattery((Object)acceptor, (String)"buildcraft.kinesis", (ForgeDirection)side.getOpposite())).getEnergyRequested() > 0.0)) continue;
            toReturn.add(acceptor);
        }
        return toReturn;
    }

    @Override
    public synchronized void refresh() {
        Set iterCables = (Set)this.transmitters.clone();
        Iterator it = iterCables.iterator();
        boolean networkChanged = false;
        while (it.hasNext()) {
            IGridTransmitter conductor = (IGridTransmitter)it.next();
            if (conductor == null || conductor.getTile().func_145837_r()) {
                it.remove();
                this.transmitters.remove(conductor);
                networkChanged = true;
                continue;
            }
            conductor.setTransmitterNetwork(this);
        }
        if (networkChanged) {
            this.updateCapacity();
        }
        this.needsUpdate = true;
    }

    @Override
    public synchronized void refresh(IGridTransmitter<EnergyNetwork> transmitter) {
        TileEntity[] acceptors = CableUtils.getConnectedEnergyAcceptors(transmitter.getTile());
        this.clearAround(transmitter);
        for (TileEntity acceptor : acceptors) {
            ForgeDirection side = ForgeDirection.getOrientation((int)Arrays.asList(acceptors).indexOf(acceptor));
            if (side == null || acceptor == null || acceptor instanceof IGridTransmitter || !transmitter.canConnectToAcceptor(side, true)) continue;
            this.possibleAcceptors.put(Coord4D.get(acceptor), acceptor);
            this.acceptorDirections.put(acceptor, ForgeDirection.getOrientation((int)Arrays.asList(acceptors).indexOf(acceptor)));
        }
    }

    public String toString() {
        return "[EnergyNetwork] " + this.transmitters.size() + " transmitters, " + this.possibleAcceptors.size() + " acceptors.";
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.clearJoulesTransmitted();
        double currentPowerScale = this.getPowerScale();
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            if (Math.abs(currentPowerScale - this.lastPowerScale) > 0.01 || currentPowerScale != this.lastPowerScale && (currentPowerScale == 0.0 || currentPowerScale == 1.0)) {
                this.needsUpdate = true;
            }
            if (this.needsUpdate) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTransferEvent(this, currentPowerScale));
                this.lastPowerScale = currentPowerScale;
                this.needsUpdate = false;
            }
            if (this.electricityStored > 0.0) {
                this.electricityStored -= this.tickEmit(this.electricityStored);
            }
        }
    }

    public double getPowerScale() {
        return Math.max(this.jouleBufferLastTick == 0.0 ? 0.0 : Math.min(Math.ceil(Math.log10(this.getPower()) * 2.0) / 10.0, 1.0), this.getCapacity() == 0 ? 0.0 : this.electricityStored / (double)this.getCapacity());
    }

    public void clearJoulesTransmitted() {
        this.jouleBufferLastTick = this.electricityStored;
        this.joulesTransmitted = 0.0;
    }

    public double getPower() {
        return this.jouleBufferLastTick * 20.0;
    }

    protected EnergyNetwork create(IGridTransmitter<EnergyNetwork> ... varTransmitters) {
        EnergyNetwork network = new EnergyNetwork(varTransmitters);
        network.clientEnergyScale = this.clientEnergyScale;
        network.jouleBufferLastTick = this.jouleBufferLastTick;
        network.joulesTransmitted = this.joulesTransmitted;
        network.lastPowerScale = this.lastPowerScale;
        network.electricityStored += this.electricityStored;
        return network;
    }

    protected EnergyNetwork create(Collection<IGridTransmitter<EnergyNetwork>> collection) {
        EnergyNetwork network = new EnergyNetwork(collection);
        network.clientEnergyScale = this.clientEnergyScale;
        network.jouleBufferLastTick = this.jouleBufferLastTick;
        network.joulesTransmitted = this.joulesTransmitted;
        network.lastPowerScale = this.lastPowerScale;
        network.electricityStored += this.electricityStored;
        network.updateCapacity();
        return network;
    }

    protected EnergyNetwork create(Set<EnergyNetwork> networks) {
        return new EnergyNetwork(networks);
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.ENERGY;
    }

    @Override
    public String getNeededInfo() {
        return MekanismUtils.getEnergyDisplay(this.getEnergyNeeded());
    }

    @Override
    public String getStoredInfo() {
        return MekanismUtils.getEnergyDisplay(this.electricityStored);
    }

    @Override
    public String getFlowInfo() {
        return MekanismUtils.getEnergyDisplay(this.joulesTransmitted) + "/t";
    }

    public static class EnergyTransferEvent
    extends Event {
        public final EnergyNetwork energyNetwork;
        public final double power;

        public EnergyTransferEvent(EnergyNetwork network, double currentPower) {
            this.energyNetwork = network;
            this.power = currentPower;
        }
    }
}

