/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.ListUtils;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.ITransmitterNetwork;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.util.PipeUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class FluidNetwork
extends DynamicNetwork<IFluidHandler, FluidNetwork> {
    public int transferDelay = 0;
    public boolean didTransfer;
    public boolean prevTransfer;
    public float fluidScale;
    public Fluid refFluid;
    public FluidStack fluidStored;
    public int prevStored;
    public int prevTransferAmount = 0;

    public FluidNetwork(IGridTransmitter<FluidNetwork> ... varPipes) {
        this.transmitters.addAll(Arrays.asList(varPipes));
        this.register();
    }

    public FluidNetwork(Collection<IGridTransmitter<FluidNetwork>> collection) {
        this.transmitters.addAll(collection);
        this.register();
    }

    public FluidNetwork(Set<FluidNetwork> networks) {
        for (FluidNetwork net : networks) {
            if (net == null) continue;
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                if (net.refFluid != null && net.fluidScale > this.fluidScale) {
                    this.refFluid = net.refFluid;
                    this.fluidScale = net.fluidScale;
                    this.fluidStored = net.fluidStored;
                    net.fluidScale = 0.0f;
                    net.refFluid = null;
                    net.fluidStored = null;
                }
            } else if (net.fluidStored != null) {
                if (this.fluidStored == null) {
                    this.fluidStored = net.fluidStored;
                } else {
                    this.fluidStored.amount += net.fluidStored.amount;
                }
                net.fluidStored = null;
            }
            this.addAllTransmitters(net.transmitters);
            net.deregister();
        }
        this.fluidScale = this.getScale();
        this.register();
    }

    @Override
    protected synchronized void updateMeanCapacity() {
        int numCables = this.transmitters.size();
        double sum = 0.0;
        for (IGridTransmitter pipe : this.transmitters) {
            sum += (double)pipe.getCapacity();
        }
        this.meanCapacity = sum / (double)numCables;
    }

    @Override
    public void onNetworksCreated(List<FluidNetwork> networks) {
        if (this.fluidStored != null && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int[] caps = new int[networks.size()];
            int cap = 0;
            for (FluidNetwork network : networks) {
                caps[networks.indexOf((Object)network)] = network.getCapacity();
                cap += network.getCapacity();
            }
            this.fluidStored.amount = Math.min(cap, this.fluidStored.amount);
            int[] values = ListUtils.calcPercentInt(ListUtils.percent(caps), this.fluidStored.amount);
            for (FluidNetwork network : networks) {
                int index = networks.indexOf(network);
                if (values[index] <= 0) continue;
                network.fluidStored = new FluidStack(this.fluidStored.getFluid(), values[index]);
                network.fluidScale = network.getScale();
                network.refFluid = this.fluidStored.getFluid();
            }
        }
        this.fluidScale = 0.0f;
        this.fluidStored = null;
        this.refFluid = null;
    }

    public synchronized int getFluidNeeded() {
        return this.getCapacity() - (this.fluidStored != null ? this.fluidStored.amount : 0);
    }

    public synchronized int tickEmit(FluidStack fluidToSend, boolean doTransfer) {
        List<Object> availableAcceptors = Arrays.asList(this.getAcceptors(fluidToSend).toArray());
        Collections.shuffle(availableAcceptors);
        int fluidSent = 0;
        if (!availableAcceptors.isEmpty()) {
            int divider = availableAcceptors.size();
            int remaining = fluidToSend.amount % divider;
            int sending = (fluidToSend.amount - remaining) / divider;
            for (Object obj : availableAcceptors) {
                if (!(obj instanceof IFluidHandler)) continue;
                IFluidHandler acceptor = (IFluidHandler)obj;
                int currentSending = sending;
                if (remaining > 0) {
                    ++currentSending;
                    --remaining;
                }
                fluidSent += acceptor.fill(((ForgeDirection)this.acceptorDirections.get(acceptor)).getOpposite(), new FluidStack(fluidToSend.fluidID, currentSending), doTransfer);
            }
        }
        if (doTransfer && fluidSent > 0 && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.didTransfer = true;
            this.transferDelay = 2;
        }
        return fluidSent;
    }

    public synchronized int emit(FluidStack fluidToSend, boolean doTransfer) {
        if (fluidToSend == null || this.fluidStored != null && this.fluidStored.getFluid() != fluidToSend.getFluid()) {
            return 0;
        }
        int toUse = Math.min(this.getFluidNeeded(), fluidToSend.amount);
        if (doTransfer) {
            if (this.fluidStored == null) {
                this.fluidStored = fluidToSend.copy();
                this.fluidStored.amount = toUse;
            } else {
                this.fluidStored.amount += toUse;
            }
        }
        return toUse;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int stored;
            this.prevTransferAmount = 0;
            if (this.transferDelay == 0) {
                this.didTransfer = false;
            } else {
                --this.transferDelay;
            }
            int n = stored = this.fluidStored != null ? this.fluidStored.amount : 0;
            if (stored != this.prevStored) {
                this.needsUpdate = true;
            }
            this.prevStored = stored;
            if (this.didTransfer != this.prevTransfer || this.needsUpdate) {
                MinecraftForge.EVENT_BUS.post((Event)new FluidTransferEvent(this, this.fluidStored, this.didTransfer));
                this.needsUpdate = false;
            }
            this.prevTransfer = this.didTransfer;
            if (this.fluidStored != null) {
                this.prevTransferAmount = this.tickEmit(this.fluidStored, true);
                this.fluidStored.amount -= this.prevTransferAmount;
                if (this.fluidStored != null && this.fluidStored.amount <= 0) {
                    this.fluidStored = null;
                }
            }
        }
    }

    @Override
    public void clientTick() {
        super.clientTick();
        this.fluidScale = Math.max(this.fluidScale, this.getScale());
        if (this.didTransfer && this.fluidScale < 1.0f) {
            this.fluidScale = Math.max(this.getScale(), Math.min(1.0f, this.fluidScale + 0.02f));
        } else if (!this.didTransfer && this.fluidScale > 0.0f) {
            this.fluidScale = this.getScale();
            if (this.fluidScale == 0.0f) {
                this.fluidStored = null;
            }
        }
    }

    @Override
    public synchronized Set<IFluidHandler> getAcceptors(Object ... data) {
        FluidStack fluidToSend = (FluidStack)data[0];
        HashSet<IFluidHandler> toReturn = new HashSet<IFluidHandler>();
        for (IFluidHandler acceptor : ((Map)this.possibleAcceptors.clone()).values()) {
            if (this.acceptorDirections.get(acceptor) == null || !acceptor.canFill(((ForgeDirection)this.acceptorDirections.get(acceptor)).getOpposite(), fluidToSend.getFluid())) continue;
            toReturn.add(acceptor);
        }
        return toReturn;
    }

    @Override
    public synchronized void refresh() {
        Set iterPipes = (Set)this.transmitters.clone();
        Iterator it = iterPipes.iterator();
        boolean networkChanged = false;
        while (it.hasNext()) {
            IGridTransmitter conductor = (IGridTransmitter)it.next();
            if (conductor == null || conductor.getTile().func_145837_r()) {
                it.remove();
                networkChanged = true;
                this.transmitters.remove(conductor);
                continue;
            }
            conductor.setTransmitterNetwork(this);
        }
        if (networkChanged) {
            this.updateCapacity();
        }
    }

    @Override
    public synchronized void refresh(IGridTransmitter<FluidNetwork> transmitter) {
        IFluidHandler[] acceptors = PipeUtils.getConnectedAcceptors(transmitter.getTile());
        this.clearAround(transmitter);
        for (IFluidHandler acceptor : acceptors) {
            ForgeDirection side = ForgeDirection.getOrientation((int)Arrays.asList(acceptors).indexOf(acceptor));
            if (side == null || acceptor == null || acceptor instanceof IGridTransmitter || !transmitter.canConnectToAcceptor(side, true)) continue;
            this.possibleAcceptors.put(Coord4D.get((TileEntity)acceptor), acceptor);
            this.acceptorDirections.put(acceptor, ForgeDirection.getOrientation((int)Arrays.asList(acceptors).indexOf(acceptor)));
        }
    }

    public float getScale() {
        return Math.min(1.0f, this.fluidStored == null || this.getCapacity() == 0 ? 0.0f : (float)this.fluidStored.amount / (float)this.getCapacity());
    }

    public String toString() {
        return "[FluidNetwork] " + this.transmitters.size() + " transmitters, " + this.possibleAcceptors.size() + " acceptors.";
    }

    protected FluidNetwork create(IGridTransmitter<FluidNetwork> ... varTransmitters) {
        FluidNetwork network = new FluidNetwork(varTransmitters);
        network.refFluid = this.refFluid;
        if (this.fluidStored != null) {
            if (network.fluidStored == null) {
                network.fluidStored = this.fluidStored;
            } else {
                network.fluidStored.amount += this.fluidStored.amount;
            }
        }
        network.fluidScale = network.getScale();
        this.fluidScale = 0.0f;
        this.refFluid = null;
        this.fluidStored = null;
        return network;
    }

    protected FluidNetwork create(Collection<IGridTransmitter<FluidNetwork>> collection) {
        FluidNetwork network = new FluidNetwork(collection);
        network.refFluid = this.refFluid;
        if (this.fluidStored != null) {
            if (network.fluidStored == null) {
                network.fluidStored = this.fluidStored;
            } else {
                network.fluidStored.amount += this.fluidStored.amount;
            }
        }
        network.updateCapacity();
        network.fluidScale = network.getScale();
        return network;
    }

    @Override
    public boolean canMerge(List<ITransmitterNetwork<?, ?>> networks) {
        Fluid found = null;
        for (ITransmitterNetwork<?, ?> network : networks) {
            if (!(network instanceof FluidNetwork)) continue;
            FluidNetwork net = (FluidNetwork)network;
            if (net.fluidStored == null) continue;
            if (found != null && found != net.fluidStored.getFluid()) {
                return false;
            }
            found = net.fluidStored.getFluid();
        }
        return true;
    }

    protected FluidNetwork create(Set<FluidNetwork> networks) {
        return new FluidNetwork(networks);
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.FLUID;
    }

    @Override
    public String getNeededInfo() {
        return (float)this.getFluidNeeded() / 1000.0f + " buckets";
    }

    @Override
    public String getStoredInfo() {
        return this.fluidStored != null ? this.fluidStored.getFluid().getLocalizedName(this.fluidStored) + " (" + this.fluidStored.amount + " mB)" : "None";
    }

    @Override
    public String getFlowInfo() {
        return Integer.toString(this.prevTransferAmount) + " mB/t";
    }

    public static class FluidTransferEvent
    extends Event {
        public final FluidNetwork fluidNetwork;
        public final FluidStack fluidType;
        public final boolean didTransfer;

        public FluidTransferEvent(FluidNetwork network, FluidStack type, boolean did) {
            this.fluidNetwork = network;
            this.fluidType = type;
            this.didTransfer = did;
        }
    }
}

