/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Range4D;
import mekanism.common.Mekanism;
import mekanism.common.network.PacketBoxBlacklist;
import mekanism.common.network.PacketConfigSync;
import mekanism.common.network.PacketConfigurationUpdate;
import mekanism.common.network.PacketConfiguratorState;
import mekanism.common.network.PacketContainerEditMode;
import mekanism.common.network.PacketDataRequest;
import mekanism.common.network.PacketDigitUpdate;
import mekanism.common.network.PacketDigitalMinerGui;
import mekanism.common.network.PacketEditFilter;
import mekanism.common.network.PacketElectricBowState;
import mekanism.common.network.PacketElectricChest;
import mekanism.common.network.PacketJetpackData;
import mekanism.common.network.PacketKey;
import mekanism.common.network.PacketLogisticalSorterGui;
import mekanism.common.network.PacketNewFilter;
import mekanism.common.network.PacketPortableTankState;
import mekanism.common.network.PacketPortableTeleport;
import mekanism.common.network.PacketPortalFX;
import mekanism.common.network.PacketRedstoneControl;
import mekanism.common.network.PacketRemoveUpgrade;
import mekanism.common.network.PacketRobit;
import mekanism.common.network.PacketScubaTankData;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.network.PacketStatusUpdate;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.network.PacketTransmitterUpdate;
import mekanism.common.network.PacketWalkieTalkieState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;

public class PacketHandler {
    public SimpleNetworkWrapper netHandler = NetworkRegistry.INSTANCE.newSimpleChannel("MEK");

    public void initialize() {
        this.netHandler.registerMessage(PacketRobit.class, PacketRobit.RobitMessage.class, 0, Side.SERVER);
        this.netHandler.registerMessage(PacketTransmitterUpdate.class, PacketTransmitterUpdate.TransmitterUpdateMessage.class, 1, Side.CLIENT);
        this.netHandler.registerMessage(PacketElectricChest.class, PacketElectricChest.ElectricChestMessage.class, 2, Side.CLIENT);
        this.netHandler.registerMessage(PacketElectricChest.class, PacketElectricChest.ElectricChestMessage.class, 2, Side.SERVER);
        this.netHandler.registerMessage(PacketElectricBowState.class, PacketElectricBowState.ElectricBowStateMessage.class, 3, Side.SERVER);
        this.netHandler.registerMessage(PacketConfiguratorState.class, PacketConfiguratorState.ConfiguratorStateMessage.class, 4, Side.SERVER);
        this.netHandler.registerMessage(PacketTileEntity.class, PacketTileEntity.TileEntityMessage.class, 5, Side.CLIENT);
        this.netHandler.registerMessage(PacketTileEntity.class, PacketTileEntity.TileEntityMessage.class, 5, Side.SERVER);
        this.netHandler.registerMessage(PacketPortalFX.class, PacketPortalFX.PortalFXMessage.class, 6, Side.CLIENT);
        this.netHandler.registerMessage(PacketDataRequest.class, PacketDataRequest.DataRequestMessage.class, 7, Side.SERVER);
        this.netHandler.registerMessage(PacketStatusUpdate.class, PacketStatusUpdate.StatusUpdateMessage.class, 8, Side.CLIENT);
        this.netHandler.registerMessage(PacketDigitUpdate.class, PacketDigitUpdate.DigitUpdateMessage.class, 9, Side.SERVER);
        this.netHandler.registerMessage(PacketPortableTeleport.class, PacketPortableTeleport.PortableTeleportMessage.class, 10, Side.SERVER);
        this.netHandler.registerMessage(PacketRemoveUpgrade.class, PacketRemoveUpgrade.RemoveUpgradeMessage.class, 11, Side.SERVER);
        this.netHandler.registerMessage(PacketRedstoneControl.class, PacketRedstoneControl.RedstoneControlMessage.class, 12, Side.SERVER);
        this.netHandler.registerMessage(PacketWalkieTalkieState.class, PacketWalkieTalkieState.WalkieTalkieStateMessage.class, 13, Side.SERVER);
        this.netHandler.registerMessage(PacketLogisticalSorterGui.class, PacketLogisticalSorterGui.LogisticalSorterGuiMessage.class, 14, Side.CLIENT);
        this.netHandler.registerMessage(PacketLogisticalSorterGui.class, PacketLogisticalSorterGui.LogisticalSorterGuiMessage.class, 14, Side.SERVER);
        this.netHandler.registerMessage(PacketNewFilter.class, PacketNewFilter.NewFilterMessage.class, 15, Side.SERVER);
        this.netHandler.registerMessage(PacketEditFilter.class, PacketEditFilter.EditFilterMessage.class, 16, Side.SERVER);
        this.netHandler.registerMessage(PacketConfigurationUpdate.class, PacketConfigurationUpdate.ConfigurationUpdateMessage.class, 17, Side.SERVER);
        this.netHandler.registerMessage(PacketSimpleGui.class, PacketSimpleGui.SimpleGuiMessage.class, 18, Side.CLIENT);
        this.netHandler.registerMessage(PacketSimpleGui.class, PacketSimpleGui.SimpleGuiMessage.class, 18, Side.SERVER);
        this.netHandler.registerMessage(PacketDigitalMinerGui.class, PacketDigitalMinerGui.DigitalMinerGuiMessage.class, 19, Side.CLIENT);
        this.netHandler.registerMessage(PacketDigitalMinerGui.class, PacketDigitalMinerGui.DigitalMinerGuiMessage.class, 19, Side.SERVER);
        this.netHandler.registerMessage(PacketJetpackData.class, PacketJetpackData.JetpackDataMessage.class, 20, Side.CLIENT);
        this.netHandler.registerMessage(PacketJetpackData.class, PacketJetpackData.JetpackDataMessage.class, 20, Side.SERVER);
        this.netHandler.registerMessage(PacketKey.class, PacketKey.KeyMessage.class, 21, Side.SERVER);
        this.netHandler.registerMessage(PacketScubaTankData.class, PacketScubaTankData.ScubaTankDataMessage.class, 22, Side.CLIENT);
        this.netHandler.registerMessage(PacketScubaTankData.class, PacketScubaTankData.ScubaTankDataMessage.class, 22, Side.SERVER);
        this.netHandler.registerMessage(PacketConfigSync.class, PacketConfigSync.ConfigSyncMessage.class, 23, Side.CLIENT);
        this.netHandler.registerMessage(PacketBoxBlacklist.class, PacketBoxBlacklist.BoxBlacklistMessage.class, 24, Side.CLIENT);
        this.netHandler.registerMessage(PacketPortableTankState.class, PacketPortableTankState.PortableTankStateMessage.class, 25, Side.SERVER);
        this.netHandler.registerMessage(PacketContainerEditMode.class, PacketContainerEditMode.ContainerEditModeMessage.class, 26, Side.SERVER);
    }

    public static void encode(Object[] dataValues, ByteBuf output) {
        try {
            for (Object data : dataValues) {
                if (data instanceof Integer) {
                    output.writeInt(((Integer)data).intValue());
                    continue;
                }
                if (data instanceof Boolean) {
                    output.writeBoolean(((Boolean)data).booleanValue());
                    continue;
                }
                if (data instanceof Double) {
                    output.writeDouble(((Double)data).doubleValue());
                    continue;
                }
                if (data instanceof Float) {
                    output.writeFloat(((Float)data).floatValue());
                    continue;
                }
                if (data instanceof String) {
                    PacketHandler.writeString(output, (String)data);
                    continue;
                }
                if (data instanceof Byte) {
                    output.writeByte((int)((Byte)data).byteValue());
                    continue;
                }
                if (data instanceof ItemStack) {
                    PacketHandler.writeStack(output, (ItemStack)data);
                    continue;
                }
                if (data instanceof NBTTagCompound) {
                    PacketHandler.writeNBT(output, (NBTTagCompound)data);
                    continue;
                }
                if (data instanceof int[]) {
                    for (int i : (int[])data) {
                        output.writeInt(i);
                    }
                    continue;
                }
                if (data instanceof byte[]) {
                    for (byte b : (byte[])data) {
                        output.writeByte((int)b);
                    }
                    continue;
                }
                if (!(data instanceof ArrayList)) continue;
                PacketHandler.encode(((ArrayList)data).toArray(), output);
            }
        }
        catch (Exception e) {
            Mekanism.logger.error("Error while encoding packet data.");
            e.printStackTrace();
        }
    }

    public static void writeString(ByteBuf output, String s) {
        output.writeInt(s.getBytes().length);
        output.writeBytes(s.getBytes());
    }

    public static String readString(ByteBuf input) {
        return new String(input.readBytes(input.readInt()).array());
    }

    public static void writeStack(ByteBuf output, ItemStack stack) {
        output.writeInt(stack != null ? Item.func_150891_b((Item)stack.func_77973_b()) : -1);
        if (stack != null) {
            output.writeInt(stack.field_77994_a);
            output.writeInt(stack.func_77960_j());
            if (stack.func_77978_p() != null && stack.func_77973_b().func_77651_p()) {
                output.writeBoolean(true);
                PacketHandler.writeNBT(output, stack.func_77978_p());
            } else {
                output.writeBoolean(false);
            }
        }
    }

    public static ItemStack readStack(ByteBuf input) {
        int id = input.readInt();
        if (id >= 0) {
            ItemStack stack = new ItemStack(Item.func_150899_d((int)id), input.readInt(), input.readInt());
            if (input.readBoolean()) {
                stack.func_77982_d(PacketHandler.readNBT(input));
            }
            return stack;
        }
        return null;
    }

    public static void writeNBT(ByteBuf output, NBTTagCompound nbtTags) {
        try {
            byte[] buffer = CompressedStreamTools.func_74798_a((NBTTagCompound)nbtTags);
            output.writeInt(buffer.length);
            output.writeBytes(buffer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static NBTTagCompound readNBT(ByteBuf input) {
        try {
            byte[] buffer = new byte[input.readInt()];
            input.readBytes(buffer);
            return CompressedStreamTools.func_152457_a((byte[])buffer, (NBTSizeTracker)new NBTSizeTracker(0x200000L));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static EntityPlayer getPlayer(MessageContext context) {
        return Mekanism.proxy.getPlayer(context);
    }

    public void sendToAll(IMessage message) {
        this.netHandler.sendToAll(message);
    }

    public void sendTo(IMessage message, EntityPlayerMP player) {
        this.netHandler.sendTo(message, player);
    }

    public void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        this.netHandler.sendToAllAround(message, point);
    }

    public void sendToDimension(IMessage message, int dimensionId) {
        this.netHandler.sendToDimension(message, dimensionId);
    }

    public void sendToServer(IMessage message) {
        this.netHandler.sendToServer(message);
    }

    public void sendToCuboid(IMessage message, AxisAlignedBB cuboid, int dimId) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server != null && cuboid != null) {
            for (EntityPlayerMP player : server.func_71203_ab().field_72404_b) {
                if (player.field_71093_bK != dimId || !cuboid.func_72318_a(Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v))) continue;
                this.sendTo(message, player);
            }
        }
    }

    public void sendToReceivers(IMessage message, Range4D range) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server != null) {
            for (EntityPlayerMP player : server.func_71203_ab().field_72404_b) {
                if (player.field_71093_bK != range.dimensionId || !Range4D.getChunkRange((EntityPlayer)player).intersects(range)) continue;
                this.sendTo(message, player);
            }
        }
    }
}

