/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import mekanism.api.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.multipart.TransmitterType;
import net.minecraft.util.ResourceLocation;

public final class Tier {

    public static enum PipeTier {
        BASIC(1000, 100, TransmitterType.MECHANICAL_PIPE_BASIC),
        ADVANCED(4000, 400, TransmitterType.MECHANICAL_PIPE_ADVANCED),
        ELITE(16000, 1600, TransmitterType.MECHANICAL_PIPE_ELITE),
        ULTIMATE(64000, 6400, TransmitterType.MECHANICAL_PIPE_ULTIMATE);

        public int pipeCapacity;
        public int pipePullAmount;
        public TransmitterType type;

        public BaseTier getBaseTier() {
            return BaseTier.values()[this.ordinal()];
        }

        private PipeTier(int capacity, int pullAmount, TransmitterType transmitterType) {
            this.pipeCapacity = capacity;
            this.pipePullAmount = pullAmount;
            this.type = transmitterType;
        }

        public static PipeTier getTierFromMeta(int meta) {
            switch (meta) {
                case 4: {
                    return BASIC;
                }
                case 5: {
                    return ADVANCED;
                }
                case 6: {
                    return ELITE;
                }
                case 7: {
                    return ULTIMATE;
                }
            }
            return BASIC;
        }
    }

    public static enum CableTier {
        BASIC(500, TransmitterType.UNIVERSAL_CABLE_BASIC),
        ADVANCED(2000, TransmitterType.UNIVERSAL_CABLE_ADVANCED),
        ELITE(8000, TransmitterType.UNIVERSAL_CABLE_ELITE),
        ULTIMATE(32000, TransmitterType.UNIVERSAL_CABLE_ULTIMATE);

        public int cableCapacity;
        public TransmitterType type;

        public BaseTier getBaseTier() {
            return BaseTier.values()[this.ordinal()];
        }

        private CableTier(int capacity, TransmitterType transmitterType) {
            this.cableCapacity = capacity;
            this.type = transmitterType;
        }
    }

    public static enum FactoryTier {
        BASIC("Basic", 3, new ResourceLocation("mekanism", "gui/factory/GuiBasicFactory.png")),
        ADVANCED("Advanced", 5, new ResourceLocation("mekanism", "gui/factory/GuiAdvancedFactory.png")),
        ELITE("Elite", 7, new ResourceLocation("mekanism", "gui/factory/GuiEliteFactory.png"));

        public int processes;
        public ResourceLocation guiLocation;
        public String name;

        public static FactoryTier getFromName(String tierName) {
            for (FactoryTier tier : FactoryTier.values()) {
                if (!tierName.contains(tier.name)) continue;
                return tier;
            }
            Mekanism.logger.error("Invalid tier identifier when retrieving with name.");
            return BASIC;
        }

        public BaseTier getBaseTier() {
            return BaseTier.values()[this.ordinal()];
        }

        private FactoryTier(String s, int process, ResourceLocation gui) {
            this.name = s;
            this.processes = process;
            this.guiLocation = gui;
        }
    }

    public static enum EnergyCubeTier {
        BASIC("Basic", EnumColor.BRIGHT_GREEN, 2000000.0, 800.0),
        ADVANCED("Advanced", EnumColor.DARK_RED, 8000000.0, 3200.0),
        ELITE("Elite", EnumColor.DARK_BLUE, 3.2E7, 12800.0),
        ULTIMATE("Ultimate", EnumColor.PURPLE, 1.28E8, 51200.0);

        public double MAX_ELECTRICITY;
        public double OUTPUT;
        public String name;
        public EnumColor color;

        public static EnergyCubeTier getFromName(String tierName) {
            for (EnergyCubeTier tier : EnergyCubeTier.values()) {
                if (!tierName.contains(tier.name)) continue;
                return tier;
            }
            Mekanism.logger.error("Invalid tier identifier when retrieving with name.");
            return BASIC;
        }

        public BaseTier getBaseTier() {
            return BaseTier.values()[this.ordinal()];
        }

        private EnergyCubeTier(String s, EnumColor c, double maxEnergy, double out) {
            this.name = s;
            this.color = c;
            this.MAX_ELECTRICITY = maxEnergy;
            this.OUTPUT = out;
        }
    }

    public static enum BaseTier {
        BASIC("Basic"),
        ADVANCED("Advanced"),
        ELITE("Elite"),
        ULTIMATE("Ultimate");

        private String name;

        public String getName() {
            return this.name;
        }

        private BaseTier(String s) {
            this.name = s;
        }
    }
}

