/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import java.util.List;
import java.util.Random;
import mekanism.api.Coord4D;
import mekanism.api.energy.IEnergizedItem;
import mekanism.client.ClientProxy;
import mekanism.common.IActiveState;
import mekanism.common.IBoundingBlock;
import mekanism.common.IElectricChest;
import mekanism.common.IFactory;
import mekanism.common.IInvConfiguration;
import mekanism.common.IRedstoneControl;
import mekanism.common.ISpecialBounds;
import mekanism.common.ISustainedData;
import mekanism.common.ISustainedInventory;
import mekanism.common.ISustainedTank;
import mekanism.common.IUpgradeManagement;
import mekanism.common.ItemAttacher;
import mekanism.common.Mekanism;
import mekanism.common.network.PacketElectricChest;
import mekanism.common.network.PacketLogisticalSorterGui;
import mekanism.common.tile.TileEntityAdvancedFactory;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.common.tile.TileEntityChargepad;
import mekanism.common.tile.TileEntityChemicalCrystallizer;
import mekanism.common.tile.TileEntityChemicalDissolutionChamber;
import mekanism.common.tile.TileEntityChemicalInfuser;
import mekanism.common.tile.TileEntityChemicalInjectionChamber;
import mekanism.common.tile.TileEntityChemicalOxidizer;
import mekanism.common.tile.TileEntityChemicalWasher;
import mekanism.common.tile.TileEntityCombiner;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.tile.TileEntityCrusher;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.tile.TileEntityElectricChest;
import mekanism.common.tile.TileEntityElectricPump;
import mekanism.common.tile.TileEntityElectrolyticSeparator;
import mekanism.common.tile.TileEntityEliteFactory;
import mekanism.common.tile.TileEntityEnergizedSmelter;
import mekanism.common.tile.TileEntityEnrichmentChamber;
import mekanism.common.tile.TileEntityFactory;
import mekanism.common.tile.TileEntityFluidicPlenisher;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.TileEntityMetallurgicInfuser;
import mekanism.common.tile.TileEntityOsmiumCompressor;
import mekanism.common.tile.TileEntityPRC;
import mekanism.common.tile.TileEntityPortableTank;
import mekanism.common.tile.TileEntityPrecisionSawmill;
import mekanism.common.tile.TileEntityPurificationChamber;
import mekanism.common.tile.TileEntityRotaryCondensentrator;
import mekanism.common.tile.TileEntitySeismicVibrator;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheralProvider", modid="ComputerCraft")
public class BlockMachine
extends BlockContainer
implements ISpecialBounds,
IPeripheralProvider {
    public IIcon[][] icons = new IIcon[16][16];
    public Random machineRand = new Random();

    public BlockMachine() {
        super(Material.field_151573_f);
        this.func_149711_c(3.5f);
        this.func_149752_b(8.0f);
        this.func_149647_a(Mekanism.tabMekanism);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        if (this == Mekanism.MachineBlock) {
            this.icons[0][0] = register.func_94245_a("mekanism:EnrichmentChamberFrontOff");
            this.icons[0][1] = register.func_94245_a("mekanism:EnrichmentChamberFrontOn");
            this.icons[0][2] = register.func_94245_a("mekanism:SteelCasing");
            this.icons[1][0] = register.func_94245_a("mekanism:OsmiumCompressorFrontOff");
            this.icons[1][1] = register.func_94245_a("mekanism:OsmiumCompressorFrontOn");
            this.icons[1][2] = register.func_94245_a("mekanism:SteelCasing");
            this.icons[2][0] = register.func_94245_a("mekanism:CombinerFrontOff");
            this.icons[2][1] = register.func_94245_a("mekanism:CombinerFrontOn");
            this.icons[2][2] = register.func_94245_a("mekanism:SteelCasing");
            this.icons[3][0] = register.func_94245_a("mekanism:CrusherFrontOff");
            this.icons[3][1] = register.func_94245_a("mekanism:CrusherFrontOn");
            this.icons[3][2] = register.func_94245_a("mekanism:SteelCasing");
            this.icons[5][0] = register.func_94245_a("mekanism:BasicFactoryFront");
            this.icons[5][1] = register.func_94245_a("mekanism:BasicFactorySide");
            this.icons[5][2] = register.func_94245_a("mekanism:BasicFactoryTop");
            this.icons[6][0] = register.func_94245_a("mekanism:AdvancedFactoryFront");
            this.icons[6][1] = register.func_94245_a("mekanism:AdvancedFactorySide");
            this.icons[6][2] = register.func_94245_a("mekanism:AdvancedFactoryTop");
            this.icons[7][0] = register.func_94245_a("mekanism:EliteFactoryFront");
            this.icons[7][1] = register.func_94245_a("mekanism:EliteFactorySide");
            this.icons[7][2] = register.func_94245_a("mekanism:EliteFactoryTop");
            this.icons[9][0] = register.func_94245_a("mekanism:PurificationChamberFrontOff");
            this.icons[9][1] = register.func_94245_a("mekanism:PurificationChamberFrontOn");
            this.icons[9][2] = register.func_94245_a("mekanism:SteelCasing");
            this.icons[10][0] = register.func_94245_a("mekanism:EnergizedSmelterFrontOff");
            this.icons[10][1] = register.func_94245_a("mekanism:EnergizedSmelterFrontOn");
            this.icons[10][2] = register.func_94245_a("mekanism:SteelCasing");
            this.icons[11][0] = register.func_94245_a("mekanism:Teleporter");
        } else if (this == Mekanism.MachineBlock2) {
            this.icons[2][0] = register.func_94245_a("mekanism:ChemicalInjectionChamberFrontOff");
            this.icons[2][1] = register.func_94245_a("mekanism:ChemicalInjectionChamberFrontOn");
            this.icons[2][2] = register.func_94245_a("mekanism:SteelCasing");
            this.icons[3][0] = register.func_94245_a("mekanism:ChemicalInjectionChamberFrontOff");
            this.icons[3][1] = register.func_94245_a("mekanism:ChemicalInjectionChamberFrontOn");
            this.icons[3][2] = register.func_94245_a("mekanism:SteelCasing");
            this.icons[5][0] = register.func_94245_a("mekanism:PrecisionSawmillFrontOff");
            this.icons[5][1] = register.func_94245_a("mekanism:PrecisionSawmillFrontOn");
            this.icons[5][2] = register.func_94245_a("mekanism:SteelCasing");
            this.icons[9][0] = register.func_94245_a("mekanism:SteelBlock");
            this.icons[9][1] = register.func_94245_a("mekanism:SeismicVibrator");
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack itemstack) {
        TileEntityLogisticalSorter transporter;
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
        int side = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int height = Math.round(entityliving.field_70125_A);
        int change = 3;
        if (tileEntity == null) {
            return;
        }
        if (tileEntity.canSetFacing(0) && tileEntity.canSetFacing(1)) {
            if (height >= 65) {
                change = 1;
            } else if (height <= -65) {
                change = 0;
            }
        }
        if (change != 0 && change != 1) {
            switch (side) {
                case 0: {
                    change = 2;
                    break;
                }
                case 1: {
                    change = 5;
                    break;
                }
                case 2: {
                    change = 3;
                    break;
                }
                case 3: {
                    change = 4;
                }
            }
        }
        if (tileEntity instanceof TileEntityLogisticalSorter && !(transporter = (TileEntityLogisticalSorter)tileEntity).hasInventory()) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = Coord4D.get(transporter).getFromSide(dir).getTileEntity((IBlockAccess)world);
                if (!(tile instanceof IInventory)) continue;
                change = dir.getOpposite().ordinal();
                break;
            }
        }
        tileEntity.setFacing((short)change);
        tileEntity.redstone = world.func_72864_z(x, y, z);
        if (tileEntity instanceof IBoundingBlock) {
            ((IBoundingBlock)((Object)tileEntity)).onPlace();
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
        if (tileEntity instanceof IBoundingBlock) {
            ((IBoundingBlock)((Object)tileEntity)).onBreak();
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
        if (MekanismUtils.isActive((IBlockAccess)world, x, y, z) && ((IActiveState)((Object)tileEntity)).renderUpdate() && Mekanism.machineEffects) {
            float xRandom = (float)x + 0.5f;
            float yRandom = (float)y + 0.0f + random.nextFloat() * 6.0f / 16.0f;
            float zRandom = (float)z + 0.5f;
            float iRandom = 0.52f;
            float jRandom = random.nextFloat() * 0.6f - 0.3f;
            int side = tileEntity.facing;
            if (tileEntity instanceof TileEntityMetallurgicInfuser) {
                side = ForgeDirection.getOrientation((int)side).getOpposite().ordinal();
            }
            if (side == 4) {
                world.func_72869_a("smoke", (double)(xRandom - iRandom), (double)yRandom, (double)(zRandom + jRandom), 0.0, 0.0, 0.0);
                world.func_72869_a("reddust", (double)(xRandom - iRandom), (double)yRandom, (double)(zRandom + jRandom), 0.0, 0.0, 0.0);
            } else if (side == 5) {
                world.func_72869_a("smoke", (double)(xRandom + iRandom), (double)yRandom, (double)(zRandom + jRandom), 0.0, 0.0, 0.0);
                world.func_72869_a("reddust", (double)(xRandom + iRandom), (double)yRandom, (double)(zRandom + jRandom), 0.0, 0.0, 0.0);
            } else if (side == 2) {
                world.func_72869_a("smoke", (double)(xRandom + jRandom), (double)yRandom, (double)(zRandom - iRandom), 0.0, 0.0, 0.0);
                world.func_72869_a("reddust", (double)(xRandom + jRandom), (double)yRandom, (double)(zRandom - iRandom), 0.0, 0.0, 0.0);
            } else if (side == 3) {
                world.func_72869_a("smoke", (double)(xRandom + jRandom), (double)yRandom, (double)(zRandom + iRandom), 0.0, 0.0, 0.0);
                world.func_72869_a("reddust", (double)(xRandom + jRandom), (double)yRandom, (double)(zRandom + iRandom), 0.0, 0.0, 0.0);
            }
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (Mekanism.machineEffects && tileEntity instanceof IActiveState && ((IActiveState)tileEntity).getActive() && ((IActiveState)tileEntity).lightUpdate()) {
            return 15;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (this == Mekanism.MachineBlock) {
            if (meta == 0) {
                if (side == 3) {
                    return this.icons[0][0];
                }
                return this.icons[0][2];
            }
            if (meta == 1) {
                if (side == 3) {
                    return this.icons[1][0];
                }
                return this.icons[1][2];
            }
            if (meta == 2) {
                if (side == 3) {
                    return this.icons[2][0];
                }
                return this.icons[2][2];
            }
            if (meta == 3) {
                if (side == 3) {
                    return this.icons[3][0];
                }
                return this.icons[3][2];
            }
            if (meta == 5) {
                if (side == 3) {
                    return this.icons[5][0];
                }
                if (side == 0 || side == 1) {
                    return this.icons[5][2];
                }
                return this.icons[5][1];
            }
            if (meta == 6) {
                if (side == 3) {
                    return this.icons[6][0];
                }
                if (side == 0 || side == 1) {
                    return this.icons[6][2];
                }
                return this.icons[6][1];
            }
            if (meta == 7) {
                if (side == 3) {
                    return this.icons[7][0];
                }
                if (side == 0 || side == 1) {
                    return this.icons[7][2];
                }
                return this.icons[7][1];
            }
            if (meta == 9) {
                if (side == 3) {
                    return this.icons[9][0];
                }
                return this.icons[9][2];
            }
            if (meta == 10) {
                if (side == 3) {
                    return this.icons[10][0];
                }
                return this.icons[10][2];
            }
            if (meta == 11) {
                return this.icons[11][0];
            }
        } else if (this == Mekanism.MachineBlock2) {
            if (meta == 3 || meta == 5) {
                if (side == 3) {
                    return this.icons[meta][0];
                }
                return this.icons[meta][2];
            }
            if (meta == 9) {
                if (side == 3) {
                    return this.icons[meta][1];
                }
                return this.icons[meta][0];
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.func_72805_g(x, y, z);
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
        if (this == Mekanism.MachineBlock) {
            if (metadata == 0) {
                if (side == tileEntity.facing) {
                    return MekanismUtils.isActive(world, x, y, z) ? this.icons[0][1] : this.icons[0][0];
                }
                return this.icons[0][2];
            }
            if (metadata == 1) {
                if (side == tileEntity.facing) {
                    return MekanismUtils.isActive(world, x, y, z) ? this.icons[1][1] : this.icons[1][0];
                }
                return this.icons[1][2];
            }
            if (metadata == 2) {
                if (side == tileEntity.facing) {
                    return MekanismUtils.isActive(world, x, y, z) ? this.icons[2][1] : this.icons[2][0];
                }
                return this.icons[2][2];
            }
            if (metadata == 3) {
                if (side == tileEntity.facing) {
                    return MekanismUtils.isActive(world, x, y, z) ? this.icons[3][1] : this.icons[3][0];
                }
                return this.icons[3][2];
            }
            if (metadata == 5) {
                if (side == tileEntity.facing) {
                    return this.icons[5][0];
                }
                if (side == 0 || side == 1) {
                    return this.icons[5][2];
                }
                return this.icons[5][1];
            }
            if (metadata == 6) {
                if (side == tileEntity.facing) {
                    return this.icons[6][0];
                }
                if (side == 0 || side == 1) {
                    return this.icons[6][2];
                }
                return this.icons[6][1];
            }
            if (metadata == 7) {
                if (side == tileEntity.facing) {
                    return this.icons[7][0];
                }
                if (side == 0 || side == 1) {
                    return this.icons[7][2];
                }
                return this.icons[7][1];
            }
            if (metadata == 9) {
                if (side == tileEntity.facing) {
                    return MekanismUtils.isActive(world, x, y, z) ? this.icons[9][1] : this.icons[9][0];
                }
                return this.icons[9][2];
            }
            if (metadata == 10) {
                if (side == tileEntity.facing) {
                    return MekanismUtils.isActive(world, x, y, z) ? this.icons[10][1] : this.icons[10][0];
                }
                return this.icons[10][2];
            }
            if (metadata == 11) {
                return this.icons[11][0];
            }
        } else if (this == Mekanism.MachineBlock2) {
            if (metadata == 3 || metadata == 5) {
                if (side == tileEntity.facing) {
                    return MekanismUtils.isActive(world, x, y, z) ? this.icons[metadata][1] : this.icons[metadata][0];
                }
                return this.icons[metadata][2];
            }
            if (metadata == 9) {
                if (side == tileEntity.facing) {
                    return this.icons[metadata][1];
                }
                return this.icons[metadata][0];
            }
        }
        return null;
    }

    public int func_149692_a(int i) {
        return i;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativetabs, List list) {
        for (MachineType type : MachineType.values()) {
            if (type.typeBlock != this) continue;
            if (type == MachineType.BASIC_FACTORY || type == MachineType.ADVANCED_FACTORY || type == MachineType.ELITE_FACTORY) {
                for (IFactory.RecipeType recipe : IFactory.RecipeType.values()) {
                    ItemStack stack = new ItemStack(item, 1, type.meta);
                    ((IFactory)stack.func_77973_b()).setRecipeType(recipe.ordinal(), stack);
                    list.add(stack);
                }
                continue;
            }
            list.add(new ItemStack(item, 1, type.meta));
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityplayer, int facing, float posX, float posY, float posZ) {
        if (ItemAttacher.canAttach(entityplayer.func_71045_bC())) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        if (entityplayer.func_71045_bC() != null) {
            Item tool = entityplayer.func_71045_bC().func_77973_b();
            if (ModAPIManager.INSTANCE.hasAPI("BuildCraftAPI|tools") && tool instanceof IToolWrench && !tool.func_77658_a().contains("omniwrench") && ((IToolWrench)tool).canWrench(entityplayer, x, y, z)) {
                if (entityplayer.func_70093_af() && metadata != 13) {
                    this.dismantleBlock(world, x, y, z, false);
                    return true;
                }
                ((IToolWrench)tool).wrenchUsed(entityplayer, x, y, z);
                int change = 0;
                switch (tileEntity.facing) {
                    case 3: {
                        change = 5;
                        break;
                    }
                    case 5: {
                        change = 2;
                        break;
                    }
                    case 2: {
                        change = 4;
                        break;
                    }
                    case 4: {
                        change = 3;
                    }
                }
                if (tileEntity instanceof TileEntityLogisticalSorter && !((TileEntityLogisticalSorter)tileEntity).hasInventory()) {
                    for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                        TileEntity tile = Coord4D.get(tileEntity).getFromSide(dir).getTileEntity((IBlockAccess)world);
                        if (!(tileEntity instanceof IInventory)) continue;
                        change = dir.getOpposite().ordinal();
                        break;
                    }
                }
                tileEntity.setFacing((short)change);
                world.func_147459_d(x, y, z, (Block)this);
                return true;
            }
        }
        if (tileEntity != null) {
            MachineType type = MachineType.get((Block)this, metadata);
            if (type == MachineType.ELECTRIC_CHEST) {
                TileEntityElectricChest electricChest = (TileEntityElectricChest)tileEntity;
                if (!entityplayer.func_70093_af() && !world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN)) {
                    if (electricChest.canAccess()) {
                        MekanismUtils.openElectricChestGui((EntityPlayerMP)entityplayer, electricChest, null, true);
                    } else if (!electricChest.authenticated) {
                        Mekanism.packetHandler.sendTo(new PacketElectricChest.ElectricChestMessage(PacketElectricChest.ElectricChestPacketType.CLIENT_OPEN, true, false, 2, 0, null, Coord4D.get(electricChest)), (EntityPlayerMP)entityplayer);
                    } else {
                        Mekanism.packetHandler.sendTo(new PacketElectricChest.ElectricChestMessage(PacketElectricChest.ElectricChestPacketType.CLIENT_OPEN, true, false, 1, 0, null, Coord4D.get(electricChest)), (EntityPlayerMP)entityplayer);
                    }
                    return true;
                }
            } else {
                if (type == MachineType.PORTABLE_TANK) {
                    if (entityplayer.func_71045_bC() != null && FluidContainerRegistry.isContainer((ItemStack)entityplayer.func_71045_bC())) {
                        if (this.manageInventory(entityplayer, (TileEntityPortableTank)tileEntity)) {
                            entityplayer.field_71071_by.func_70296_d();
                            return true;
                        }
                    } else {
                        entityplayer.openGui((Object)Mekanism.instance, type.guiId, world, x, y, z);
                    }
                    return true;
                }
                if (type == MachineType.LOGISTICAL_SORTER) {
                    TileEntityLogisticalSorter sorter = (TileEntityLogisticalSorter)tileEntity;
                    PacketLogisticalSorterGui.LogisticalSorterGuiMessage.openServerGui(PacketLogisticalSorterGui.SorterGuiPacket.SERVER, 0, world, (EntityPlayerMP)entityplayer, Coord4D.get(tileEntity), -1);
                    return true;
                }
                if (!entityplayer.func_70093_af() && type.guiId != -1) {
                    entityplayer.openGui((Object)Mekanism.instance, type.guiId, world, x, y, z);
                    return true;
                }
            }
        }
        return false;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (MachineType.get((Block)this, metadata) == null) {
            return null;
        }
        return MachineType.get((Block)this, metadata).create();
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return null;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public Item func_149650_a(int i, Random random, int j) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return ClientProxy.MACHINE_RENDER_ID;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) != 13) {
            return this.field_149782_v;
        }
        TileEntityElectricChest tileEntity = (TileEntityElectricChest)world.func_147438_o(x, y, z);
        return tileEntity.canAccess() ? 3.5f : -1.0f;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (!player.field_71075_bZ.field_75098_d && !world.field_72995_K && this.canHarvestBlock(player, world.func_72805_g(x, y, z))) {
            TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + motionX, (double)y + motionY, (double)z + motionZ, this.getPickBlock(null, world, x, y, z));
            world.func_72838_d((Entity)entityItem);
        }
        return world.func_147468_f(x, y, z);
    }

    private boolean manageInventory(EntityPlayer player, TileEntityPortableTank tileEntity) {
        ItemStack itemStack = player.func_71045_bC();
        if (itemStack != null) {
            if (FluidContainerRegistry.isEmptyContainer((ItemStack)itemStack)) {
                ItemStack filled;
                if (tileEntity.fluidTank.getFluid() != null && tileEntity.fluidTank.getFluid().amount >= 1000 && (filled = FluidContainerRegistry.fillFluidContainer((FluidStack)tileEntity.fluidTank.getFluid(), (ItemStack)itemStack)) != null) {
                    if (player.field_71075_bZ.field_75098_d) {
                        tileEntity.fluidTank.drain(FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled).amount, true);
                        return true;
                    }
                    if (itemStack.field_77994_a > 1) {
                        if (player.field_71071_by.func_70441_a(filled)) {
                            --itemStack.field_77994_a;
                            tileEntity.fluidTank.drain(FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled).amount, true);
                        }
                    } else if (itemStack.field_77994_a == 1) {
                        player.func_70062_b(0, filled);
                        tileEntity.fluidTank.drain(FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled).amount, true);
                        return true;
                    }
                }
            } else if (FluidContainerRegistry.isFilledContainer((ItemStack)itemStack)) {
                FluidStack itemFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack);
                int needed = tileEntity.getCurrentNeeded();
                if (tileEntity.fluidTank.getFluid() == null && itemFluid.amount <= tileEntity.fluidTank.getCapacity() || itemFluid.amount <= needed) {
                    if (tileEntity.fluidTank.getFluid() != null && !tileEntity.fluidTank.getFluid().isFluidEqual(itemFluid)) {
                        return false;
                    }
                    boolean filled = false;
                    if (player.field_71075_bZ.field_75098_d) {
                        filled = true;
                    } else {
                        ItemStack containerItem = itemStack.func_77973_b().getContainerItem(itemStack);
                        if (containerItem != null) {
                            if (itemStack.field_77994_a == 1) {
                                player.func_70062_b(0, containerItem);
                                filled = true;
                            } else if (player.field_71071_by.func_70441_a(containerItem)) {
                                --itemStack.field_77994_a;
                                filled = true;
                            }
                        } else {
                            --itemStack.field_77994_a;
                            if (itemStack.field_77994_a == 0) {
                                player.func_70062_b(0, null);
                            }
                            filled = true;
                        }
                    }
                    if (filled) {
                        int toFill = Math.min(tileEntity.fluidTank.getCapacity() - tileEntity.fluidTank.getFluidAmount(), itemFluid.amount);
                        tileEntity.fluidTank.fill(itemFluid, true);
                        if (itemFluid.amount - toFill > 0) {
                            tileEntity.pushUp(new FluidStack(itemFluid.getFluid(), itemFluid.amount - toFill), true);
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!world.field_72995_K) {
            TileEntityLogisticalSorter sorter;
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity instanceof TileEntityBasicBlock) {
                ((TileEntityBasicBlock)tileEntity).onNeighborChange(block);
            }
            if (tileEntity instanceof TileEntityLogisticalSorter && !(sorter = (TileEntityLogisticalSorter)tileEntity).hasInventory()) {
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    TileEntity tile = Coord4D.get(tileEntity).getFromSide(dir).getTileEntity((IBlockAccess)world);
                    if (!(tile instanceof IInventory)) continue;
                    sorter.setFacing((short)dir.getOpposite().ordinal());
                    return;
                }
            }
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
        ItemStack itemStack = new ItemStack((Block)this, 1, world.func_72805_g(x, y, z));
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        if (((IUpgradeManagement)itemStack.func_77973_b()).supportsUpgrades(itemStack)) {
            IUpgradeManagement upgrade = (IUpgradeManagement)itemStack.func_77973_b();
            upgrade.setEnergyMultiplier(((IUpgradeManagement)((Object)tileEntity)).getEnergyMultiplier(new Object[0]), itemStack);
            upgrade.setSpeedMultiplier(((IUpgradeManagement)((Object)tileEntity)).getSpeedMultiplier(new Object[0]), itemStack);
        }
        if (tileEntity instanceof IInvConfiguration) {
            IInvConfiguration config = (IInvConfiguration)((Object)tileEntity);
            itemStack.field_77990_d.func_74757_a("hasSideData", true);
            itemStack.field_77990_d.func_74757_a("ejecting", config.getEjector().isEjecting());
            for (int i = 0; i < 6; ++i) {
                itemStack.field_77990_d.func_74774_a("config" + i, config.getConfiguration()[i]);
            }
        }
        if (tileEntity instanceof ISustainedData) {
            ((ISustainedData)((Object)tileEntity)).writeSustainedData(itemStack);
        }
        if (tileEntity instanceof IRedstoneControl) {
            IRedstoneControl control = (IRedstoneControl)((Object)tileEntity);
            itemStack.field_77990_d.func_74768_a("controlType", control.getControlType().ordinal());
        }
        if (tileEntity instanceof TileEntityElectricBlock) {
            IEnergizedItem energizedItem = (IEnergizedItem)itemStack.func_77973_b();
            energizedItem.setEnergy(itemStack, ((TileEntityElectricBlock)tileEntity).electricityStored);
        }
        if (tileEntity instanceof TileEntityContainerBlock && ((TileEntityContainerBlock)tileEntity).inventory.length > 0) {
            ISustainedInventory inventory = (ISustainedInventory)itemStack.func_77973_b();
            inventory.setInventory(((ISustainedInventory)((Object)tileEntity)).getInventory(new Object[0]), itemStack);
        }
        if (((ISustainedTank)itemStack.func_77973_b()).hasTank(itemStack) && tileEntity instanceof ISustainedTank && ((ISustainedTank)((Object)tileEntity)).getFluidStack(new Object[0]) != null) {
            ((ISustainedTank)itemStack.func_77973_b()).setFluidStack(((ISustainedTank)((Object)tileEntity)).getFluidStack(new Object[0]), itemStack);
        }
        if (tileEntity instanceof TileEntityElectricChest) {
            IElectricChest electricChest = (IElectricChest)itemStack.func_77973_b();
            electricChest.setAuthenticated(itemStack, ((TileEntityElectricChest)tileEntity).authenticated);
            electricChest.setLocked(itemStack, ((TileEntityElectricChest)tileEntity).locked);
            electricChest.setPassword(itemStack, ((TileEntityElectricChest)tileEntity).password);
        }
        if (tileEntity instanceof TileEntityFactory) {
            IFactory factoryItem = (IFactory)itemStack.func_77973_b();
            factoryItem.setRecipeType(((TileEntityFactory)tileEntity).recipeType, itemStack);
        }
        return itemStack;
    }

    public ItemStack dismantleBlock(World world, int x, int y, int z, boolean returnBlock) {
        ItemStack itemStack = this.getPickBlock(null, world, x, y, z);
        world.func_147468_f(x, y, z);
        if (!returnBlock) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + motionX, (double)y + motionY, (double)z + motionZ, itemStack);
            world.func_72838_d((Entity)entityItem);
        }
        return itemStack;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        MachineType type = MachineType.get((Block)this, world.func_72805_g(x, y, z));
        if (type == MachineType.CHARGEPAD) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.06f, 1.0f);
        } else if (type == MachineType.PORTABLE_TANK) {
            this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 1.0f, 0.875f);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        if (world.func_147438_o(x, y, z) instanceof TileEntityChargepad) {
            return null;
        }
        return super.func_149668_a(world, x, y, z);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        MachineType type = MachineType.get((Block)this, world.func_72805_g(x, y, z));
        if (type == MachineType.CHARGEPAD) {
            return false;
        }
        if (type == MachineType.PORTABLE_TANK) {
            return side == ForgeDirection.UP || side == ForgeDirection.DOWN;
        }
        return true;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!world.field_72995_K && tileEntity instanceof TileEntityElectricBlock && MekanismUtils.useIC2()) {
            ((TileEntityElectricBlock)tileEntity).register();
        }
    }

    @Override
    public void setRenderBounds(Block block, int metadata) {
    }

    @Override
    public boolean doDefaultBoundSetting(int metadata) {
        return false;
    }

    @Optional.Method(modid="ComputerCraft")
    public IPeripheral getPeripheral(World world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof IPeripheral) {
            return (IPeripheral)te;
        }
        return null;
    }

    public ForgeDirection[] getValidRotations(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        ForgeDirection[] valid = new ForgeDirection[6];
        if (tile instanceof TileEntityBasicBlock) {
            TileEntityBasicBlock basicTile = (TileEntityBasicBlock)tile;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (!basicTile.canSetFacing(dir.ordinal())) continue;
                valid[dir.ordinal()] = dir;
            }
        }
        return valid;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntityBasicBlock basicTile;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityBasicBlock && (basicTile = (TileEntityBasicBlock)tile).canSetFacing(axis.ordinal())) {
            basicTile.setFacing((short)axis.ordinal());
            return true;
        }
        return false;
    }

    public static enum MachineType {
        ENRICHMENT_CHAMBER(Mekanism.MachineBlock, 0, "EnrichmentChamber", 3, Mekanism.enrichmentChamberUsage * 400.0, TileEntityEnrichmentChamber.class, true, false, true),
        OSMIUM_COMPRESSOR(Mekanism.MachineBlock, 1, "OsmiumCompressor", 4, Mekanism.osmiumCompressorUsage * 400.0, TileEntityOsmiumCompressor.class, true, false, true),
        COMBINER(Mekanism.MachineBlock, 2, "Combiner", 5, Mekanism.combinerUsage * 400.0, TileEntityCombiner.class, true, false, true),
        CRUSHER(Mekanism.MachineBlock, 3, "Crusher", 6, Mekanism.crusherUsage * 400.0, TileEntityCrusher.class, true, false, true),
        DIGITAL_MINER(Mekanism.MachineBlock, 4, "DigitalMiner", 2, 100000.0, TileEntityDigitalMiner.class, true, true, true),
        BASIC_FACTORY(Mekanism.MachineBlock, 5, "BasicFactory", 11, Mekanism.factoryUsage * 3.0 * 400.0, TileEntityFactory.class, true, false, true),
        ADVANCED_FACTORY(Mekanism.MachineBlock, 6, "AdvancedFactory", 11, Mekanism.factoryUsage * 5.0 * 400.0, TileEntityAdvancedFactory.class, true, false, true),
        ELITE_FACTORY(Mekanism.MachineBlock, 7, "EliteFactory", 11, Mekanism.factoryUsage * 7.0 * 400.0, TileEntityEliteFactory.class, true, false, true),
        METALLURGIC_INFUSER(Mekanism.MachineBlock, 8, "MetallurgicInfuser", 12, Mekanism.metallurgicInfuserUsage * 400.0, TileEntityMetallurgicInfuser.class, true, true, true),
        PURIFICATION_CHAMBER(Mekanism.MachineBlock, 9, "PurificationChamber", 15, Mekanism.purificationChamberUsage * 400.0, TileEntityPurificationChamber.class, true, false, true),
        ENERGIZED_SMELTER(Mekanism.MachineBlock, 10, "EnergizedSmelter", 16, Mekanism.energizedSmelterUsage * 400.0, TileEntityEnergizedSmelter.class, true, false, true),
        TELEPORTER(Mekanism.MachineBlock, 11, "Teleporter", 13, 5000000.0, TileEntityTeleporter.class, true, false, false),
        ELECTRIC_PUMP(Mekanism.MachineBlock, 12, "ElectricPump", 17, 10000.0, TileEntityElectricPump.class, true, true, false),
        ELECTRIC_CHEST(Mekanism.MachineBlock, 13, "ElectricChest", -1, 12000.0, TileEntityElectricChest.class, true, true, false),
        CHARGEPAD(Mekanism.MachineBlock, 14, "Chargepad", -1, 10000.0, TileEntityChargepad.class, true, true, false),
        LOGISTICAL_SORTER(Mekanism.MachineBlock, 15, "LogisticalSorter", -1, 0.0, TileEntityLogisticalSorter.class, false, true, false),
        ROTARY_CONDENSENTRATOR(Mekanism.MachineBlock2, 0, "RotaryCondensentrator", 7, 20000.0, TileEntityRotaryCondensentrator.class, true, true, false),
        CHEMICAL_OXIDIZER(Mekanism.MachineBlock2, 1, "ChemicalOxidizer", 29, 20000.0, TileEntityChemicalOxidizer.class, true, true, true),
        CHEMICAL_INFUSER(Mekanism.MachineBlock2, 2, "ChemicalInfuser", 30, 20000.0, TileEntityChemicalInfuser.class, true, true, false),
        CHEMICAL_INJECTION_CHAMBER(Mekanism.MachineBlock2, 3, "ChemicalInjectionChamber", 31, Mekanism.chemicalInjectionChamberUsage * 400.0, TileEntityChemicalInjectionChamber.class, true, false, true),
        ELECTROLYTIC_SEPARATOR(Mekanism.MachineBlock2, 4, "ElectrolyticSeparator", 32, 400000.0, TileEntityElectrolyticSeparator.class, true, true, false),
        PRECISION_SAWMILL(Mekanism.MachineBlock2, 5, "PrecisionSawmill", 34, Mekanism.precisionSawmillUsage * 400.0, TileEntityPrecisionSawmill.class, true, false, true),
        CHEMICAL_DISSOLUTION_CHAMBER(Mekanism.MachineBlock2, 6, "ChemicalDissolutionChamber", 35, 20000.0, TileEntityChemicalDissolutionChamber.class, true, true, true),
        CHEMICAL_WASHER(Mekanism.MachineBlock2, 7, "ChemicalWasher", 36, 20000.0, TileEntityChemicalWasher.class, true, true, false),
        CHEMICAL_CRYSTALLIZER(Mekanism.MachineBlock2, 8, "ChemicalCrystallizer", 37, 20000.0, TileEntityChemicalCrystallizer.class, true, true, true),
        SEISMIC_VIBRATOR(Mekanism.MachineBlock2, 9, "SeismicVibrator", 39, 20000.0, TileEntitySeismicVibrator.class, true, true, false),
        PRESSURIZED_REACTION_CHAMBER(Mekanism.MachineBlock2, 10, "PressurizedReactionChamber", 40, 20000.0, TileEntityPRC.class, true, true, false),
        PORTABLE_TANK(Mekanism.MachineBlock2, 11, "PortableTank", 41, 0.0, TileEntityPortableTank.class, false, true, false),
        FLUIDIC_PLENISHER(Mekanism.MachineBlock2, 12, "FluidicPlenisher", 42, 10000.0, TileEntityFluidicPlenisher.class, true, true, false);

        public Block typeBlock;
        public int meta;
        public String name;
        public int guiId;
        public double baseEnergy;
        public Class<? extends TileEntity> tileEntityClass;
        public boolean isElectric;
        public boolean hasModel;
        public boolean supportsUpgrades;

        private MachineType(Block block, int i, String s, int j, double k, Class<? extends TileEntity> tileClass, boolean electric, boolean model, boolean upgrades) {
            this.typeBlock = block;
            this.meta = i;
            this.name = s;
            this.guiId = j;
            this.baseEnergy = k;
            this.tileEntityClass = tileClass;
            this.isElectric = electric;
            this.hasModel = model;
            this.supportsUpgrades = upgrades;
        }

        public static MachineType get(Block block, int meta) {
            for (MachineType type : MachineType.values()) {
                if (type.meta != meta || type.typeBlock != block) continue;
                return type;
            }
            return null;
        }

        public TileEntity create() {
            try {
                return this.tileEntityClass.newInstance();
            }
            catch (Exception e) {
                Mekanism.logger.error("Unable to indirectly create tile entity.");
                e.printStackTrace();
                return null;
            }
        }

        public String getDescription() {
            return MekanismUtils.localize("tooltip." + this.name);
        }

        public ItemStack getStack() {
            return new ItemStack(this.typeBlock, 1, this.meta);
        }

        public static MachineType get(ItemStack stack) {
            return MachineType.get(Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77960_j());
        }

        public String toString() {
            return Integer.toString(this.meta);
        }
    }
}

