/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration;

import ic2.api.item.IElectricItemManager;
import mekanism.api.energy.IEnergizedItem;
import mekanism.common.Mekanism;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;

public class IC2ItemManager
implements IElectricItemManager {
    public IEnergizedItem energizedItem;

    public static IC2ItemManager getManager(IEnergizedItem item) {
        IC2ItemManager manager = new IC2ItemManager();
        manager.energizedItem = item;
        return manager;
    }

    public double charge(ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        if (this.energizedItem.canReceive(itemStack)) {
            double energyNeeded = this.energizedItem.getMaxEnergy(itemStack) - this.energizedItem.getEnergy(itemStack);
            double energyToStore = Math.min(Math.min(amount * Mekanism.FROM_IC2, this.energizedItem.getMaxEnergy(itemStack) * 0.01), energyNeeded);
            if (!simulate) {
                this.energizedItem.setEnergy(itemStack, this.energizedItem.getEnergy(itemStack) + energyToStore);
            }
            return (int)Math.round(energyToStore * Mekanism.TO_IC2);
        }
        return 0.0;
    }

    public double discharge(ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean external, boolean simulate) {
        if (this.energizedItem.canSend(itemStack)) {
            double energyWanted = amount * Mekanism.FROM_IC2;
            double energyToGive = Math.min(Math.min(energyWanted, this.energizedItem.getMaxEnergy(itemStack) * 0.01), this.energizedItem.getEnergy(itemStack));
            if (!simulate) {
                this.energizedItem.setEnergy(itemStack, this.energizedItem.getEnergy(itemStack) - energyToGive);
            }
            return (int)Math.round(energyToGive * Mekanism.TO_IC2);
        }
        return 0.0;
    }

    public boolean canUse(ItemStack itemStack, double amount) {
        return this.energizedItem.getEnergy(itemStack) >= amount * Mekanism.FROM_IC2;
    }

    public double getCharge(ItemStack itemStack) {
        return (int)Math.round(this.energizedItem.getEnergy(itemStack) * Mekanism.TO_IC2);
    }

    public boolean use(ItemStack itemStack, double amount, EntityLivingBase entity) {
        return false;
    }

    public void chargeFromArmor(ItemStack itemStack, EntityLivingBase entity) {
    }

    public String getToolTip(ItemStack itemStack) {
        return null;
    }
}

