/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.event.FMLInterModComms;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import java.util.List;
import java.util.Map;
import mekanism.common.Mekanism;
import mekanism.common.block.BlockMachine;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class MekanismHooks {
    private Class BasicComponents;
    private Class BuildCraftEnergy;
    public boolean IC2Loaded = false;
    public boolean IC2APILoaded = false;
    public boolean RailcraftLoaded = false;
    public boolean BuildCraftPowerLoaded = false;
    public boolean RedstoneFluxLoaded = false;
    public boolean TELoaded = false;
    public boolean CCLoaded = false;
    public boolean MetallurgyCoreLoaded = false;
    public boolean MetallurgyBaseLoaded = false;

    public void hook() {
        if (ModAPIManager.INSTANCE.hasAPI("IC2API")) {
            this.IC2APILoaded = true;
        }
        if (ModAPIManager.INSTANCE.hasAPI("BuildCraftAPI|power")) {
            this.BuildCraftPowerLoaded = true;
        }
        if (ModAPIManager.INSTANCE.hasAPI("CoFHAPI|energy")) {
            this.RedstoneFluxLoaded = true;
        }
        if (Loader.isModLoaded((String)"IC2")) {
            this.IC2Loaded = true;
        }
        if (Loader.isModLoaded((String)"Railcraft")) {
            this.RailcraftLoaded = true;
        }
        if (Loader.isModLoaded((String)"ThermalExpansion")) {
            this.TELoaded = true;
        }
        if (Loader.isModLoaded((String)"ComputerCraft")) {
            this.CCLoaded = true;
        }
        if (Loader.isModLoaded((String)"Metallurgy3Core")) {
            this.MetallurgyCoreLoaded = true;
            if (Loader.isModLoaded((String)"Metallurgy3Base")) {
                this.MetallurgyBaseLoaded = true;
            }
        }
        if (this.IC2Loaded) {
            this.hookIC2Recipes();
            Mekanism.logger.info("Hooked into IC2 successfully.");
        }
        if (this.BuildCraftPowerLoaded) {
            Mekanism.logger.info("Hooked into BuildCraft successfully.");
        }
        if (this.CCLoaded) {
            this.loadCCPeripheralProviders();
        }
    }

    @Optional.Method(modid="IC2API")
    public void hookIC2Recipes() {
        block6: for (Map.Entry entry : Recipes.macerator.getRecipes().entrySet()) {
            if (((IRecipeInput)entry.getKey()).getInputs().isEmpty()) continue;
            List<String> names = MekanismUtils.getOreDictName((ItemStack)((IRecipeInput)entry.getKey()).getInputs().get(0));
            for (String name : names) {
                boolean did = false;
                if (name.startsWith("ingot")) {
                    RecipeHandler.addCrusherRecipe((ItemStack)((IRecipeInput)entry.getKey()).getInputs().get(0), (ItemStack)((RecipeOutput)entry.getValue()).items.get(0));
                    did = true;
                }
                if (!did) continue;
                continue block6;
            }
        }
        try {
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("oreOsmium"), null, new ItemStack[]{new ItemStack(Mekanism.Dust, 2, 2)});
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotOsmium"), null, new ItemStack[]{new ItemStack(Mekanism.Dust, 1, 2)});
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotRefinedObsidian"), null, new ItemStack[]{new ItemStack(Mekanism.Dust, 1, 3)});
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotRefinedGlowstone"), null, new ItemStack[]{new ItemStack(Items.field_151114_aO)});
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotSteel"), null, new ItemStack[]{new ItemStack(Mekanism.Dust, 1, 5)});
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("clumpIron"), null, new ItemStack[]{new ItemStack(Mekanism.DirtyDust, 1, 0)});
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("clumpGold"), null, new ItemStack[]{new ItemStack(Mekanism.DirtyDust, 1, 1)});
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("clumpOsmium"), null, new ItemStack[]{new ItemStack(Mekanism.DirtyDust, 1, 2)});
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("clumpCopper"), null, new ItemStack[]{new ItemStack(Mekanism.DirtyDust, 1, 3)});
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("clumpTin"), null, new ItemStack[]{new ItemStack(Mekanism.DirtyDust, 1, 4)});
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("clumpSilver"), null, new ItemStack[]{new ItemStack(Mekanism.DirtyDust, 1, 5)});
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("clumpObsidian"), null, new ItemStack[]{new ItemStack(Mekanism.DirtyDust, 1, 6)});
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("clumpLead"), null, new ItemStack[]{new ItemStack(Mekanism.DirtyDust, 1, 7)});
        }
        catch (Exception e) {
            // empty catch block
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("amplification", 50000);
        Recipes.matterAmplifier.addRecipe((IRecipeInput)new RecipeInputItemStack(new ItemStack(Mekanism.EnrichedAlloy), 1), tag, new ItemStack[0]);
    }

    @Optional.Method(modid="ComputerCraft")
    public void loadCCPeripheralProviders() {
        try {
            ComputerCraftAPI.registerPeripheralProvider((IPeripheralProvider)((BlockMachine)Mekanism.MachineBlock));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addPulverizerRecipe(ItemStack input, ItemStack output, int energy) {
        NBTTagCompound nbtTags = new NBTTagCompound();
        nbtTags.func_74768_a("energy", energy);
        nbtTags.func_74782_a("input", (NBTBase)input.func_77955_b(new NBTTagCompound()));
        nbtTags.func_74782_a("primaryOutput", (NBTBase)output.func_77955_b(new NBTTagCompound()));
        FMLInterModComms.sendMessage((String)"mekanism", (String)"PulverizerRecipe", (NBTTagCompound)nbtTags);
    }

    public ItemStack getBuildCraftItem(String name) {
        try {
            Object ret;
            if (this.BuildCraftEnergy == null) {
                this.BuildCraftEnergy = Class.forName("buildcraft.BuildCraftEnergy");
            }
            if (this.BuildCraftEnergy == null) {
                this.BuildCraftEnergy = Class.forName("net.minecraft.src.buildcraft.BuildCraftEnergy");
            }
            if ((ret = this.BuildCraftEnergy.getField(name).get(null)) instanceof Item) {
                return new ItemStack((Item)ret);
            }
            if (ret instanceof Block) {
                return new ItemStack((Block)ret);
            }
            throw new Exception("not instanceof ItemStack");
        }
        catch (Exception e) {
            Mekanism.logger.error("Unable to retrieve BuildCraft item " + name + ".");
            return null;
        }
    }
}

