/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.ListUtils;
import mekanism.common.item.ItemEnergized;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.UseHoeEvent;

public class ItemAtomicDisassembler
extends ItemEnergized {
    public double ENERGY_USAGE = 10.0;
    public double HOE_USAGE = 100.0;

    public ItemAtomicDisassembler() {
        super(1000000.0);
    }

    @Override
    public void func_94581_a(IIconRegister register) {
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return block != Blocks.field_150357_h;
    }

    @Override
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        super.func_77624_a(itemstack, entityplayer, list, flag);
        list.add(MekanismUtils.localize("tooltip.mode") + ": " + (Object)((Object)EnumColor.INDIGO) + this.getModeName(itemstack));
        list.add(MekanismUtils.localize("tooltip.efficiency") + ": " + (Object)((Object)EnumColor.INDIGO) + this.getEfficiency(itemstack));
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase hitEntity, EntityLivingBase player) {
        if (this.getEnergy(itemstack) > 0.0) {
            hitEntity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)player)), 20.0f);
            this.setEnergy(itemstack, this.getEnergy(itemstack) - 2000.0);
        } else {
            hitEntity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)player)), 4.0f);
        }
        return false;
    }

    public float getDigSpeed(ItemStack itemstack, Block block, int meta) {
        return this.getEnergy(itemstack) != 0.0 ? (float)this.getEfficiency(itemstack) : 1.0f;
    }

    public boolean func_150894_a(ItemStack itemstack, World world, Block block, int x, int y, int z, EntityLivingBase entityliving) {
        if ((double)block.func_149712_f(world, x, y, z) != 0.0) {
            this.setEnergy(itemstack, this.getEnergy(itemstack) - this.ENERGY_USAGE * (double)this.getEfficiency(itemstack));
        } else {
            this.setEnergy(itemstack, this.getEnergy(itemstack) - this.ENERGY_USAGE * (double)this.getEfficiency(itemstack) / 2.0);
        }
        return true;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int x, int y, int z, EntityPlayer player) {
        super.onBlockStartBreak(itemstack, x, y, z, player);
        if (!player.field_70170_p.field_72995_K) {
            Block block = player.field_70170_p.func_147439_a(x, y, z);
            int meta = player.field_70170_p.func_72805_g(x, y, z);
            if (block == Blocks.field_150439_ay) {
                block = Blocks.field_150450_ax;
            }
            ItemStack stack = new ItemStack(block, 1, meta);
            Coord4D orig = new Coord4D(x, y, z, player.field_70170_p.field_73011_w.field_76574_g);
            List<String> names = MekanismUtils.getOreDictName(stack);
            boolean isOre = false;
            for (String s : names) {
                if (!s.startsWith("ore") && !s.equals("logWood")) continue;
                isOre = true;
            }
            if (this.getMode(itemstack) == 3 && isOre && !player.field_71075_bZ.field_75098_d) {
                Set<Coord4D> found = new Finder(player.field_70170_p, stack, new Coord4D(x, y, z, player.field_70170_p.field_73011_w.field_76574_g)).calc();
                for (Coord4D coord : found) {
                    if (coord.equals(orig) || this.getEnergy(itemstack) < this.ENERGY_USAGE * (double)this.getEfficiency(itemstack)) continue;
                    Block block2 = coord.getBlock((IBlockAccess)player.field_70170_p);
                    block2.func_149664_b(player.field_70170_p, coord.xCoord, coord.yCoord, coord.zCoord, meta);
                    player.field_70170_p.func_72889_a(null, 2001, coord.xCoord, coord.yCoord, coord.zCoord, meta << 12);
                    player.field_70170_p.func_147468_f(coord.xCoord, coord.yCoord, coord.zCoord);
                    block2.func_149749_a(player.field_70170_p, coord.xCoord, coord.yCoord, coord.zCoord, block, meta);
                    block2.func_149697_b(player.field_70170_p, coord.xCoord, coord.yCoord, coord.zCoord, meta, 0);
                    this.setEnergy(itemstack, this.getEnergy(itemstack) - this.ENERGY_USAGE * (double)this.getEfficiency(itemstack));
                }
            }
        }
        return false;
    }

    public boolean func_77662_d() {
        return true;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!world.field_72995_K && entityplayer.func_70093_af()) {
            this.toggleMode(itemstack);
            entityplayer.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.GREY) + MekanismUtils.localize("tooltip.modeToggle") + " " + (Object)((Object)EnumColor.INDIGO) + this.getModeName(itemstack) + (Object)((Object)EnumColor.AQUA) + " (" + this.getEfficiency(itemstack) + ")"));
        }
        return itemstack;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            if (!this.useHoe(stack, player, world, x, y, z, side) && world.func_147439_a(x, y, z) != Blocks.field_150458_ak) {
                return false;
            }
            switch (this.getEfficiency(stack)) {
                case 20: {
                    for (int x1 = x - 1; x1 <= x + 1; ++x1) {
                        for (int z1 = z - 1; z1 <= z + 1; ++z1) {
                            this.useHoe(stack, player, world, x1, y, z1, side);
                        }
                    }
                    break;
                }
                case 128: {
                    for (int x1 = x - 2; x1 <= x + 2; ++x1) {
                        for (int z1 = z - 2; z1 <= z + 2; ++z1) {
                            this.useHoe(stack, player, world, x1, y, z1, side);
                        }
                    }
                    break;
                }
            }
            return true;
        }
        return false;
    }

    private boolean useHoe(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side) {
        if (!player.func_82247_a(x, y, z, side, stack) || !player.field_71075_bZ.field_75098_d && this.getEnergy(stack) < this.HOE_USAGE) {
            return false;
        }
        UseHoeEvent event = new UseHoeEvent(player, stack, world, x, y, z);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            this.setEnergy(stack, this.getEnergy(stack) - this.HOE_USAGE);
            return true;
        }
        Block block1 = world.func_147439_a(x, y, z);
        boolean air = world.func_147437_c(x, y + 1, z);
        if (side != 0 && air && (block1 == Blocks.field_150349_c || block1 == Blocks.field_150346_d)) {
            Block farm = Blocks.field_150458_ak;
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), farm.field_149762_H.func_150498_e(), (farm.field_149762_H.func_150497_c() + 1.0f) / 2.0f, farm.field_149762_H.func_150494_d() * 0.8f);
            if (world.field_72995_K) {
                return true;
            }
            world.func_147449_b(x, y, z, farm);
            if (!player.field_71075_bZ.field_75098_d) {
                this.setEnergy(stack, this.getEnergy(stack) - this.HOE_USAGE);
            }
            return true;
        }
        return false;
    }

    public int getEfficiency(ItemStack itemStack) {
        switch (this.getMode(itemStack)) {
            case 0: {
                return 20;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 128;
            }
            case 3: {
                return 20;
            }
            case 4: {
                return 0;
            }
        }
        return 0;
    }

    public int getMode(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return 0;
        }
        return itemStack.field_77990_d.func_74762_e("mode");
    }

    public String getModeName(ItemStack itemStack) {
        int mode = this.getMode(itemStack);
        switch (mode) {
            case 0: {
                return MekanismUtils.localize("tooltip.disassembler.normal");
            }
            case 1: {
                return MekanismUtils.localize("tooltip.disassembler.slow");
            }
            case 2: {
                return MekanismUtils.localize("tooltip.disassembler.fast");
            }
            case 3: {
                return MekanismUtils.localize("tooltip.disassembler.vein");
            }
            case 4: {
                return MekanismUtils.localize("tooltip.disassembler.off");
            }
        }
        return null;
    }

    public void toggleMode(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74768_a("mode", this.getMode(itemStack) < 4 ? this.getMode(itemStack) + 1 : 0);
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return false;
    }

    public static class Finder {
        public World world;
        public ItemStack stack;
        public Coord4D location;
        public Set<Coord4D> found = new HashSet<Coord4D>();
        public static Map<Block, List<Block>> ignoreBlocks = new HashMap<Block, List<Block>>();

        public Finder(World w, ItemStack s, Coord4D loc) {
            this.world = w;
            this.stack = s;
            this.location = loc;
        }

        public void loop(Coord4D pointer) {
            if (this.found.contains(pointer) || this.found.size() > 128) {
                return;
            }
            this.found.add(pointer);
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                Coord4D coord = pointer.getFromSide(side);
                if (!coord.exists(this.world) || !this.checkID(coord.getBlock((IBlockAccess)this.world)) || coord.getMetadata((IBlockAccess)this.world) != this.stack.func_77960_j() && (!MekanismUtils.getOreDictName(this.stack).contains("logWood") || coord.getMetadata((IBlockAccess)this.world) % 4 != this.stack.func_77960_j() % 4)) continue;
                this.loop(coord);
            }
        }

        public Set<Coord4D> calc() {
            this.loop(this.location);
            return this.found;
        }

        public boolean checkID(Block b) {
            Block origBlock = this.location.getBlock((IBlockAccess)this.world);
            return ignoreBlocks.get(origBlock) == null && b == origBlock || ignoreBlocks.get(origBlock) != null && ignoreBlocks.get(origBlock).contains(b);
        }

        static {
            ignoreBlocks.put(Blocks.field_150450_ax, ListUtils.asList(Blocks.field_150450_ax, Blocks.field_150439_ay));
            ignoreBlocks.put(Blocks.field_150439_ay, ListUtils.asList(Blocks.field_150450_ax, Blocks.field_150439_ay));
        }
    }
}

