/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.Pos3D;
import mekanism.common.entity.EntityBalloon;
import mekanism.common.item.ItemMekanism;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemBalloon
extends ItemMekanism {
    public ItemBalloon() {
        this.func_77627_a(true);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)new DispenserBehavior());
    }

    public EnumColor getColor(ItemStack stack) {
        return EnumColor.DYES[stack.func_77960_j()];
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        for (int i = 0; i < EnumColor.DYES.length; ++i) {
            EnumColor color = EnumColor.DYES[i];
            if (color == null) continue;
            ItemStack stack = new ItemStack((Item)this);
            stack.func_77964_b(i);
            list.add(stack);
        }
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!world.field_72995_K) {
            Pos3D pos = new Pos3D();
            pos.zPos += 0.3;
            pos.xPos -= 0.4;
            pos.rotateYaw(entityplayer.field_70761_aq);
            pos.translate(new Pos3D((Entity)entityplayer));
            world.func_72838_d((Entity)new EntityBalloon(world, pos.xPos - 0.5, pos.yPos - 0.25, pos.zPos - 0.5, this.getColor(itemstack)));
        }
        --itemstack.field_77994_a;
        return itemstack;
    }

    public String func_77653_i(ItemStack stack) {
        String color = this.getColor(stack).getDyedName();
        if (this.getColor(stack) == EnumColor.BLACK) {
            color = (Object)((Object)EnumColor.DARK_GREY) + this.getColor(stack).getDyeName();
        }
        return color + " " + MekanismUtils.localize("tooltip.balloon");
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            AxisAlignedBB bound = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 3), (double)(z + 1));
            List balloonsNear = player.field_70170_p.func_72872_a(EntityBalloon.class, bound);
            if (balloonsNear.size() > 0) {
                return true;
            }
            Coord4D obj = new Coord4D(x, y, z, world.field_73011_w.field_76574_g);
            if (obj.getBlock((IBlockAccess)world).isReplaceable((IBlockAccess)world, x, y, z)) {
                --obj.yCoord;
            }
            if (!world.isSideSolid(x, y, z, ForgeDirection.UP)) {
                return true;
            }
            if (this.canReplace(world, obj.xCoord, obj.yCoord + 1, obj.zCoord) && this.canReplace(world, obj.xCoord, obj.yCoord + 2, obj.zCoord)) {
                world.func_147468_f(obj.xCoord, obj.yCoord + 1, obj.zCoord);
                world.func_147468_f(obj.xCoord, obj.yCoord + 2, obj.zCoord);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)new EntityBalloon(world, obj, this.getColor(stack)));
                    --stack.field_77994_a;
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity) {
        if (player.func_70093_af()) {
            if (!player.field_70170_p.field_72995_K) {
                AxisAlignedBB bound = AxisAlignedBB.func_72330_a((double)(entity.field_70165_t - 0.2), (double)(entity.field_70163_u - 0.5), (double)(entity.field_70161_v - 0.2), (double)(entity.field_70165_t + 0.2), (double)(entity.field_70163_u + (double)entity.field_70139_V + 4.0), (double)(entity.field_70161_v + 0.2));
                List balloonsNear = player.field_70170_p.func_72872_a(EntityBalloon.class, bound);
                for (EntityBalloon balloon : balloonsNear) {
                    if (balloon.latchedEntity != entity) continue;
                    return true;
                }
                player.field_70170_p.func_72838_d((Entity)new EntityBalloon(entity, this.getColor(stack)));
                --stack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    private boolean canReplace(World world, int x, int y, int z) {
        return world.func_147437_c(x, y, z) || world.func_147439_a(x, y, z).isReplaceable((IBlockAccess)world, x, y, z);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
    }

    public class DispenserBehavior
    extends BehaviorDefaultDispenseItem {
        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            Coord4D coord = new Coord4D(source.func_82623_d(), source.func_82622_e(), source.func_82621_f(), source.func_82618_k().field_73011_w.field_76574_g);
            ForgeDirection side = ForgeDirection.getOrientation((int)BlockDispenser.func_149937_b((int)source.func_82620_h()).ordinal());
            List entities = source.func_82618_k().func_72872_a(EntityLivingBase.class, coord.getFromSide(side).getBoundingBox());
            boolean latched = false;
            for (EntityLivingBase entity : entities) {
                AxisAlignedBB bound = AxisAlignedBB.func_72330_a((double)(entity.field_70165_t - 0.2), (double)(entity.field_70163_u - 0.5), (double)(entity.field_70161_v - 0.2), (double)(entity.field_70165_t + 0.2), (double)(entity.field_70163_u + (double)entity.field_70139_V + 4.0), (double)(entity.field_70161_v + 0.2));
                List balloonsNear = source.func_82618_k().func_72872_a(EntityBalloon.class, bound);
                boolean hasBalloon = false;
                for (EntityBalloon balloon : balloonsNear) {
                    if (balloon.latchedEntity != entity) continue;
                    hasBalloon = true;
                }
                if (hasBalloon) continue;
                source.func_82618_k().func_72838_d((Entity)new EntityBalloon(entity, ItemBalloon.this.getColor(stack)));
                latched = true;
            }
            if (!latched) {
                Pos3D pos = new Pos3D(coord);
                switch (side) {
                    case DOWN: {
                        pos.translate(0.0, -2.5, 0.0);
                        break;
                    }
                    case UP: {
                        pos.translate(0.0, 0.0, 0.0);
                        break;
                    }
                    case NORTH: {
                        pos.translate(0.0, -1.0, -0.5);
                        break;
                    }
                    case SOUTH: {
                        pos.translate(0.0, -1.0, 0.5);
                        break;
                    }
                    case WEST: {
                        pos.translate(-0.5, -1.0, 0.0);
                        break;
                    }
                    case EAST: {
                        pos.translate(0.5, -1.0, 0.0);
                    }
                }
                if (!source.func_82618_k().field_72995_K) {
                    source.func_82618_k().func_72838_d((Entity)new EntityBalloon(source.func_82618_k(), pos.xPos, pos.yPos, pos.zPos, ItemBalloon.this.getColor(stack)));
                }
            }
            --stack.field_77994_a;
            return stack;
        }
    }
}

