/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.Range4D;
import mekanism.api.energy.IEnergizedItem;
import mekanism.common.IEnergyCube;
import mekanism.common.ISustainedInventory;
import mekanism.common.Mekanism;
import mekanism.common.Tier;
import mekanism.common.integration.IC2ItemManager;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityEnergyCube;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.api.energy.IEnergyContainerItem", modid="CoFHAPI|energy"), @Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="IC2API")})
public class ItemBlockEnergyCube
extends ItemBlock
implements IEnergizedItem,
IEnergyCube,
ISpecialElectricItem,
ISustainedInventory,
IEnergyContainerItem {
    public Block metaBlock;

    public ItemBlockEnergyCube(Block block) {
        super(block);
        this.metaBlock = block;
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.setNoRepair();
        this.func_77637_a(Mekanism.tabMekanism);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        if (!Keyboard.isKeyDown((int)42)) {
            list.add(MekanismUtils.localize("tooltip.hold") + " " + (Object)((Object)EnumColor.AQUA) + "shift" + (Object)((Object)EnumColor.GREY) + " " + MekanismUtils.localize("tooltip.forDetails"));
        } else {
            list.add((Object)((Object)EnumColor.BRIGHT_GREEN) + MekanismUtils.localize("tooltip.storedEnergy") + ": " + (Object)((Object)EnumColor.GREY) + MekanismUtils.getEnergyDisplay(this.getEnergy(itemstack)));
            list.add((Object)((Object)EnumColor.AQUA) + MekanismUtils.localize("tooltip.inventory") + ": " + (Object)((Object)EnumColor.GREY) + LangUtils.transYesNo(this.getInventory(itemstack) != null && this.getInventory(itemstack).func_74745_c() != 0));
        }
    }

    public ItemStack getUnchargedItem(Tier.EnergyCubeTier tier) {
        ItemStack charged = new ItemStack((Item)this);
        this.setEnergyCubeTier(charged, tier);
        charged.func_77964_b(100);
        return charged;
    }

    public String func_77667_c(ItemStack itemstack) {
        return this.func_77658_a() + "." + this.getEnergyCubeTier((ItemStack)itemstack).name;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        boolean place = super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
        if (place) {
            TileEntityEnergyCube tileEntity = (TileEntityEnergyCube)world.func_147438_o(x, y, z);
            tileEntity.tier = ((IEnergyCube)stack.func_77973_b()).getEnergyCubeTier(stack);
            tileEntity.electricityStored = this.getEnergy(stack);
            tileEntity.setInventory(this.getInventory(stack), new Object[0]);
            if (!world.field_72995_K) {
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(tileEntity), tileEntity.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(tileEntity)));
            }
        }
        return place;
    }

    @Override
    public Tier.EnergyCubeTier getEnergyCubeTier(ItemStack itemstack) {
        if (itemstack.field_77990_d == null) {
            return Tier.EnergyCubeTier.BASIC;
        }
        if (itemstack.field_77990_d.func_74779_i("tier") == null) {
            return Tier.EnergyCubeTier.BASIC;
        }
        return Tier.EnergyCubeTier.getFromName(itemstack.field_77990_d.func_74779_i("tier"));
    }

    @Override
    public void setEnergyCubeTier(ItemStack itemstack, Tier.EnergyCubeTier tier) {
        if (itemstack.field_77990_d == null) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        itemstack.field_77990_d.func_74778_a("tier", tier.name);
    }

    @Optional.Method(modid="IC2API")
    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    @Optional.Method(modid="IC2API")
    public double getMaxCharge(ItemStack itemStack) {
        return 0.0;
    }

    @Optional.Method(modid="IC2API")
    public int getTier(ItemStack itemStack) {
        return 4;
    }

    @Optional.Method(modid="IC2API")
    public double getTransferLimit(ItemStack itemStack) {
        return 0.0;
    }

    @Override
    public void setInventory(NBTTagList nbtTags, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.field_77990_d.func_74782_a("Items", (NBTBase)nbtTags);
        }
    }

    @Override
    public NBTTagList getInventory(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                return null;
            }
            return itemStack.field_77990_d.func_150295_c("Items", 10);
        }
        return null;
    }

    @Override
    public double getEnergy(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return 0.0;
        }
        double electricityStored = itemStack.field_77990_d.func_74769_h("electricity");
        itemStack.func_77964_b((int)Math.max(1.0, Math.abs(electricityStored / this.getMaxEnergy(itemStack) * 100.0 - 100.0)));
        return electricityStored;
    }

    @Override
    public void setEnergy(ItemStack itemStack, double amount) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        double electricityStored = Math.max(Math.min(amount, this.getMaxEnergy(itemStack)), 0.0);
        itemStack.field_77990_d.func_74780_a("electricity", electricityStored);
        itemStack.func_77964_b((int)Math.max(1.0, Math.abs(electricityStored / this.getMaxEnergy(itemStack) * 100.0 - 100.0)));
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return this.getEnergyCubeTier((ItemStack)itemStack).MAX_ELECTRICITY;
    }

    @Override
    public double getMaxTransfer(ItemStack itemStack) {
        return this.getMaxEnergy(itemStack) * 0.005;
    }

    @Override
    public boolean canReceive(ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return true;
    }

    public int receiveEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canReceive(theItem)) {
            double energyNeeded = this.getMaxEnergy(theItem) - this.getEnergy(theItem);
            double toReceive = Math.min((double)energy * Mekanism.FROM_TE, energyNeeded);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) + toReceive);
            }
            return (int)Math.round(toReceive * Mekanism.TO_TE);
        }
        return 0;
    }

    public int extractEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canSend(theItem)) {
            double energyRemaining = this.getEnergy(theItem);
            double toSend = Math.min((double)energy * Mekanism.FROM_TE, energyRemaining);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) - toSend);
            }
            return (int)Math.round(toSend * Mekanism.TO_TE);
        }
        return 0;
    }

    public int getEnergyStored(ItemStack theItem) {
        return (int)(this.getEnergy(theItem) * Mekanism.TO_TE);
    }

    public int getMaxEnergyStored(ItemStack theItem) {
        return (int)(this.getMaxEnergy(theItem) * Mekanism.TO_TE);
    }

    @Override
    public boolean isMetadataSpecific(ItemStack itemStack) {
        return false;
    }

    @Optional.Method(modid="IC2API")
    public IElectricItemManager getManager(ItemStack itemStack) {
        return IC2ItemManager.getManager(this);
    }

    @Optional.Method(modid="IC2API")
    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    @Optional.Method(modid="IC2API")
    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }
}

