/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.energy.EnergizedItemManager;
import mekanism.api.energy.IEnergizedItem;
import mekanism.client.MekanismKeyHandler;
import mekanism.common.IElectricChest;
import mekanism.common.IFactory;
import mekanism.common.IInvConfiguration;
import mekanism.common.IRedstoneControl;
import mekanism.common.ISustainedData;
import mekanism.common.ISustainedInventory;
import mekanism.common.ISustainedTank;
import mekanism.common.IUpgradeManagement;
import mekanism.common.Mekanism;
import mekanism.common.block.BlockMachine;
import mekanism.common.integration.IC2ItemManager;
import mekanism.common.inventory.InventoryElectricChest;
import mekanism.common.network.PacketElectricChest;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.tile.TileEntityElectricChest;
import mekanism.common.tile.TileEntityFactory;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.lwjgl.input.Keyboard;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.api.energy.IEnergyContainerItem", modid="CoFHAPI|energy"), @Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="IC2API")})
public class ItemBlockMachine
extends ItemBlock
implements IEnergizedItem,
ISpecialElectricItem,
IUpgradeManagement,
IFactory,
ISustainedInventory,
ISustainedTank,
IElectricChest,
IEnergyContainerItem,
IFluidContainerItem {
    public Block metaBlock;

    public ItemBlockMachine(Block block) {
        super(block);
        this.metaBlock = block;
        this.func_77627_a(true);
        this.setNoRepair();
        this.func_77625_d(1);
    }

    public int func_77647_b(int i) {
        return i;
    }

    public String func_77667_c(ItemStack itemstack) {
        if (BlockMachine.MachineType.get(itemstack) != null) {
            return this.func_77658_a() + "." + BlockMachine.MachineType.get((ItemStack)itemstack).name;
        }
        return "null";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        BlockMachine.MachineType type = BlockMachine.MachineType.get(itemstack);
        if (!Keyboard.isKeyDown((int)42)) {
            list.add(MekanismUtils.localize("tooltip.hold") + " " + (Object)((Object)EnumColor.INDIGO) + "shift" + (Object)((Object)EnumColor.GREY) + " " + MekanismUtils.localize("tooltip.forDetails") + ".");
            list.add(MekanismUtils.localize("tooltip.hold") + " " + (Object)((Object)EnumColor.AQUA) + "shift" + (Object)((Object)EnumColor.GREY) + " and " + (Object)((Object)EnumColor.AQUA) + Keyboard.getKeyName((int)MekanismKeyHandler.modeSwitchKey.func_151463_i()) + (Object)((Object)EnumColor.GREY) + " " + MekanismUtils.localize("tooltip.forDesc") + ".");
        } else if (!Keyboard.isKeyDown((int)MekanismKeyHandler.modeSwitchKey.func_151463_i())) {
            if (type == BlockMachine.MachineType.BASIC_FACTORY || type == BlockMachine.MachineType.ADVANCED_FACTORY || type == BlockMachine.MachineType.ELITE_FACTORY) {
                list.add((Object)((Object)EnumColor.INDIGO) + MekanismUtils.localize("tooltip.recipeType") + ": " + (Object)((Object)EnumColor.GREY) + IFactory.RecipeType.values()[this.getRecipeType(itemstack)].getName());
            }
            if (type == BlockMachine.MachineType.ELECTRIC_CHEST) {
                list.add((Object)((Object)EnumColor.INDIGO) + MekanismUtils.localize("tooltip.auth") + ": " + (Object)((Object)EnumColor.GREY) + LangUtils.transYesNo(this.getAuthenticated(itemstack)));
                list.add((Object)((Object)EnumColor.INDIGO) + MekanismUtils.localize("tooltip.locked") + ": " + (Object)((Object)EnumColor.GREY) + LangUtils.transYesNo(this.getLocked(itemstack)));
            }
            if (type == BlockMachine.MachineType.PORTABLE_TANK) {
                list.add((Object)((Object)EnumColor.INDIGO) + MekanismUtils.localize("tooltip.portableTank.bucketMode") + ": " + (Object)((Object)EnumColor.GREY) + LangUtils.transYesNo(this.getBucketMode(itemstack)));
            }
            if (type.isElectric) {
                list.add((Object)((Object)EnumColor.BRIGHT_GREEN) + MekanismUtils.localize("tooltip.storedEnergy") + ": " + (Object)((Object)EnumColor.GREY) + MekanismUtils.getEnergyDisplay(this.getEnergyStored(itemstack)));
            }
            if (this.hasTank(itemstack) && this.getFluidStack(itemstack) != null) {
                list.add((Object)((Object)EnumColor.PINK) + FluidRegistry.getFluidName((FluidStack)this.getFluidStack(itemstack)) + ": " + (Object)((Object)EnumColor.GREY) + this.getFluidStack((Object[])new Object[]{itemstack}).amount + "mB");
            }
            if (this.supportsUpgrades(itemstack)) {
                list.add((Object)((Object)EnumColor.PURPLE) + MekanismUtils.localize("tooltip.upgrade.energy") + ": " + (Object)((Object)EnumColor.GREY) + "x" + (this.getEnergyMultiplier(itemstack) + 1));
                list.add((Object)((Object)EnumColor.PURPLE) + MekanismUtils.localize("tooltip.upgrade.speed") + ": " + (Object)((Object)EnumColor.GREY) + "x" + (this.getSpeedMultiplier(itemstack) + 1));
            }
            if (type != BlockMachine.MachineType.CHARGEPAD && type != BlockMachine.MachineType.LOGISTICAL_SORTER) {
                list.add((Object)((Object)EnumColor.AQUA) + MekanismUtils.localize("tooltip.inventory") + ": " + (Object)((Object)EnumColor.GREY) + LangUtils.transYesNo(this.getInventory(itemstack) != null && this.getInventory(itemstack).func_74745_c() != 0));
            }
        } else {
            list.addAll(MekanismUtils.splitLines(type.getDescription()));
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        BlockMachine.MachineType type = BlockMachine.MachineType.get(stack);
        if (type == BlockMachine.MachineType.PORTABLE_TANK && this.getBucketMode(stack)) {
            return false;
        }
        return super.func_77648_a(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        boolean place = true;
        BlockMachine.MachineType type = BlockMachine.MachineType.get(stack);
        if (type == BlockMachine.MachineType.DIGITAL_MINER) {
            for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
                for (int yPos = y; yPos <= y + 1; ++yPos) {
                    for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                        Block b = world.func_147439_a(xPos, yPos, zPos);
                        if (yPos > 255) {
                            place = false;
                        }
                        if (b.isAir((IBlockAccess)world, xPos, yPos, zPos) || b.isReplaceable((IBlockAccess)world, xPos, yPos, zPos)) continue;
                        return false;
                    }
                }
            }
        }
        if (place && super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata)) {
            TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
            if (tileEntity instanceof IUpgradeManagement) {
                ((IUpgradeManagement)((Object)tileEntity)).setEnergyMultiplier(this.getEnergyMultiplier(stack), new Object[0]);
                ((IUpgradeManagement)((Object)tileEntity)).setSpeedMultiplier(this.getSpeedMultiplier(stack), new Object[0]);
            }
            if (tileEntity instanceof IInvConfiguration) {
                IInvConfiguration config = (IInvConfiguration)((Object)tileEntity);
                if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("hasSideData")) {
                    config.getEjector().setEjecting(stack.field_77990_d.func_74767_n("ejecting"));
                    for (int i = 0; i < 6; ++i) {
                        config.getConfiguration()[i] = stack.field_77990_d.func_74771_c("config" + i);
                    }
                }
            }
            if (tileEntity instanceof ISustainedData && stack.field_77990_d != null) {
                ((ISustainedData)((Object)tileEntity)).readSustainedData(stack);
            }
            if (tileEntity instanceof IRedstoneControl && stack.field_77990_d != null && stack.field_77990_d.func_74764_b("controlType")) {
                ((IRedstoneControl)((Object)tileEntity)).setControlType(IRedstoneControl.RedstoneControl.values()[stack.field_77990_d.func_74762_e("controlType")]);
            }
            if (tileEntity instanceof TileEntityFactory) {
                ((TileEntityFactory)tileEntity).recipeType = this.getRecipeType(stack);
                world.func_147459_d(x, y, z, tileEntity.func_145838_q());
            }
            if (tileEntity instanceof ISustainedTank && this.hasTank(stack) && this.getFluidStack(stack) != null) {
                ((ISustainedTank)((Object)tileEntity)).setFluidStack(this.getFluidStack(stack), new Object[0]);
            }
            if (tileEntity instanceof TileEntityElectricChest) {
                ((TileEntityElectricChest)tileEntity).authenticated = this.getAuthenticated(stack);
                ((TileEntityElectricChest)tileEntity).locked = this.getLocked(stack);
                ((TileEntityElectricChest)tileEntity).password = this.getPassword(stack);
            }
            ((ISustainedInventory)((Object)tileEntity)).setInventory(this.getInventory(stack), new Object[0]);
            if (tileEntity instanceof TileEntityElectricBlock) {
                ((TileEntityElectricBlock)tileEntity).electricityStored = this.getEnergy(stack);
            }
            return true;
        }
        return false;
    }

    @Optional.Method(modid="IC2API")
    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    @Optional.Method(modid="IC2API")
    public double getMaxCharge(ItemStack itemStack) {
        return 0.0;
    }

    @Optional.Method(modid="IC2API")
    public int getTier(ItemStack itemStack) {
        return 4;
    }

    @Optional.Method(modid="IC2API")
    public double getTransferLimit(ItemStack itemStack) {
        return 0.0;
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
        BlockMachine.MachineType type = BlockMachine.MachineType.get(itemstack);
        if (type == BlockMachine.MachineType.ELECTRIC_CHEST) {
            InventoryElectricChest inv;
            if (world != null && !world.field_72995_K && (inv = new InventoryElectricChest(itemstack)).func_70301_a(54) != null && this.getEnergy(itemstack) < this.getMaxEnergy(itemstack)) {
                if (inv.func_70301_a(54).func_77973_b() instanceof IEnergizedItem) {
                    this.setEnergy(itemstack, this.getEnergy(itemstack) + EnergizedItemManager.discharge(inv.func_70301_a(54), this.getMaxEnergy(itemstack) - this.getEnergy(itemstack)));
                } else if (MekanismUtils.useIC2() && inv.func_70301_a(54).func_77973_b() instanceof IElectricItem) {
                    IElectricItem item = (IElectricItem)inv.func_70301_a(54).func_77973_b();
                    if (item.canProvideEnergy(inv.func_70301_a(54))) {
                        double gain = ElectricItem.manager.discharge(inv.func_70301_a(54), (double)((int)((this.getMaxEnergy(itemstack) - this.getEnergy(itemstack)) * Mekanism.TO_IC2)), 3, false, true, false) * Mekanism.FROM_IC2;
                        this.setEnergy(itemstack, this.getEnergy(itemstack) + gain);
                    }
                } else if (MekanismUtils.useRF() && inv.func_70301_a(54).func_77973_b() instanceof IEnergyContainerItem) {
                    ItemStack itemStack = inv.func_70301_a(54);
                    IEnergyContainerItem item = (IEnergyContainerItem)inv.func_70301_a(54).func_77973_b();
                    int itemEnergy = (int)Math.round(Math.min(Math.sqrt(item.getMaxEnergyStored(itemStack)), (double)item.getEnergyStored(itemStack)));
                    int toTransfer = (int)Math.round(Math.min((double)itemEnergy, (this.getMaxEnergy(itemstack) - this.getEnergy(itemstack)) * Mekanism.TO_TE));
                    this.setEnergy(itemstack, this.getEnergy(itemstack) + (double)item.extractEnergy(itemStack, toTransfer, false) * Mekanism.FROM_TE);
                } else if (inv.func_70301_a(54).func_77973_b() == Items.field_151137_ax && this.getEnergy(itemstack) + Mekanism.ENERGY_PER_REDSTONE <= this.getMaxEnergy(itemstack)) {
                    this.setEnergy(itemstack, this.getEnergy(itemstack) + Mekanism.ENERGY_PER_REDSTONE);
                    --inv.func_70301_a((int)54).field_77994_a;
                    if (inv.func_70301_a((int)54).field_77994_a <= 0) {
                        inv.func_70299_a(54, null);
                    }
                }
                inv.write();
            }
        } else if (type == BlockMachine.MachineType.PORTABLE_TANK && world != null && !world.field_72995_K) {
            float targetScale = (float)(this.getFluidStack(itemstack) != null ? this.getFluidStack((Object[])new Object[]{itemstack}).amount : 0) / 14000.0f;
            if ((double)Math.abs(this.getPrevScale(itemstack) - targetScale) > 0.01) {
                this.setPrevScale(itemstack, (9.0f * this.getPrevScale(itemstack) + targetScale) / 10.0f);
            }
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        this.func_77663_a(entityItem.func_92059_d(), null, (Entity)entityItem, 0, false);
        return false;
    }

    @Override
    public int getEnergyMultiplier(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                return 0;
            }
            return itemStack.field_77990_d.func_74762_e("energyMultiplier");
        }
        return 0;
    }

    @Override
    public void setEnergyMultiplier(int multiplier, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.field_77990_d.func_74768_a("energyMultiplier", multiplier);
        }
    }

    @Override
    public int getSpeedMultiplier(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                return 0;
            }
            return itemStack.field_77990_d.func_74762_e("speedMultiplier");
        }
        return 0;
    }

    @Override
    public void setSpeedMultiplier(int multiplier, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.field_77990_d.func_74768_a("speedMultiplier", multiplier);
        }
    }

    @Override
    public boolean supportsUpgrades(Object ... data) {
        if (data[0] instanceof ItemStack) {
            BlockMachine.MachineType type = BlockMachine.MachineType.get((ItemStack)data[0]);
            return type.supportsUpgrades;
        }
        return false;
    }

    public boolean tryPlaceContainedLiquid(World world, ItemStack itemstack, int x, int y, int z) {
        boolean flag;
        if (this.getFluidStack(itemstack) == null || !this.getFluidStack(itemstack).getFluid().canBePlacedInWorld()) {
            return false;
        }
        Material material = world.func_147439_a(x, y, z).func_149688_o();
        boolean bl = flag = !material.func_76220_a();
        if (!world.func_147437_c(x, y, z) && !flag) {
            return false;
        }
        if (world.field_73011_w.field_76575_d && this.getFluidStack(itemstack).getFluid() == FluidRegistry.WATER) {
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.func_72869_a("largesmoke", (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0);
            }
        } else {
            if (!world.field_72995_K && flag && !material.func_76224_d()) {
                world.func_147480_a(x, y, z, true);
            }
            world.func_147465_d(x, y, z, MekanismUtils.getFlowingBlock(this.getFluidStack(itemstack).getFluid()), 0, 3);
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        BlockMachine.MachineType type = BlockMachine.MachineType.get(itemstack);
        if (BlockMachine.MachineType.get(itemstack) == BlockMachine.MachineType.ELECTRIC_CHEST) {
            if (!world.field_72995_K) {
                if (!this.getAuthenticated(itemstack)) {
                    Mekanism.packetHandler.sendTo(new PacketElectricChest.ElectricChestMessage(PacketElectricChest.ElectricChestPacketType.CLIENT_OPEN, false, false, 2, 0, null, null), (EntityPlayerMP)entityplayer);
                } else if (this.getLocked(itemstack) && this.getEnergy(itemstack) > 0.0) {
                    Mekanism.packetHandler.sendTo(new PacketElectricChest.ElectricChestMessage(PacketElectricChest.ElectricChestPacketType.CLIENT_OPEN, false, false, 1, 0, null, null), (EntityPlayerMP)entityplayer);
                } else {
                    InventoryElectricChest inventory = new InventoryElectricChest(entityplayer);
                    MekanismUtils.openElectricChestGui((EntityPlayerMP)entityplayer, null, (IInventory)inventory, false);
                }
            }
        } else if (type == BlockMachine.MachineType.PORTABLE_TANK && this.getBucketMode(itemstack)) {
            MovingObjectPosition pos = this.func_77621_a(world, entityplayer, !entityplayer.func_70093_af());
            if (pos == null) {
                return itemstack;
            }
            if (pos.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                Coord4D coord = new Coord4D(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, world.field_73011_w.field_76574_g);
                if (!world.func_72962_a(entityplayer, coord.xCoord, coord.yCoord, coord.zCoord)) {
                    return itemstack;
                }
                if (!entityplayer.func_70093_af()) {
                    if (!entityplayer.func_82247_a(coord.xCoord, coord.yCoord, coord.zCoord, pos.field_72310_e, itemstack)) {
                        return itemstack;
                    }
                    FluidStack fluid = MekanismUtils.getFluid(world, coord.xCoord, coord.yCoord, coord.zCoord);
                    if (fluid != null && (this.getFluidStack(itemstack) == null || this.getFluidStack(itemstack).isFluidEqual(fluid))) {
                        int needed = 14000 - (this.getFluidStack(itemstack) != null ? this.getFluidStack((Object[])new Object[]{itemstack}).amount : 0);
                        if (fluid.amount > needed) {
                            return itemstack;
                        }
                        if (this.getFluidStack(itemstack) == null) {
                            this.setFluidStack(fluid, itemstack);
                        } else {
                            FluidStack newStack = this.getFluidStack(itemstack);
                            newStack.amount += fluid.amount;
                            this.setFluidStack(newStack, itemstack);
                        }
                        world.func_147468_f(coord.xCoord, coord.yCoord, coord.zCoord);
                    }
                } else {
                    FluidStack stored = this.getFluidStack(itemstack);
                    if (stored == null || stored.amount < 1000) {
                        return itemstack;
                    }
                    Coord4D trans = coord.getFromSide(ForgeDirection.getOrientation((int)pos.field_72310_e));
                    if (!entityplayer.func_82247_a(trans.xCoord, trans.yCoord, trans.zCoord, pos.field_72310_e, itemstack)) {
                        return itemstack;
                    }
                    if (this.tryPlaceContainedLiquid(world, itemstack, trans.xCoord, trans.yCoord, trans.zCoord) && !entityplayer.field_71075_bZ.field_75098_d) {
                        FluidStack newStack = stored.copy();
                        newStack.amount -= 1000;
                        this.setFluidStack((FluidStack)(newStack.amount > 0 ? newStack : null), itemstack);
                    }
                }
            }
            return itemstack;
        }
        return itemstack;
    }

    @Override
    public int getRecipeType(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return 0;
        }
        return itemStack.field_77990_d.func_74762_e("recipeType");
    }

    @Override
    public void setRecipeType(int type, ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74768_a("recipeType", type);
    }

    @Override
    public void setInventory(NBTTagList nbtTags, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.field_77990_d.func_74782_a("Items", (NBTBase)nbtTags);
        }
    }

    @Override
    public NBTTagList getInventory(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                return null;
            }
            return itemStack.field_77990_d.func_150295_c("Items", 10);
        }
        return null;
    }

    @Override
    public void setFluidStack(FluidStack fluidStack, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            if (fluidStack == null || fluidStack.amount == 0 || fluidStack.fluidID == 0) {
                itemStack.field_77990_d.func_82580_o("fluidTank");
            } else {
                itemStack.field_77990_d.func_74782_a("fluidTank", (NBTBase)fluidStack.writeToNBT(new NBTTagCompound()));
            }
        }
    }

    @Override
    public FluidStack getFluidStack(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                return null;
            }
            if (itemStack.field_77990_d.func_74764_b("fluidTank")) {
                return FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.field_77990_d.func_74775_l("fluidTank"));
            }
        }
        return null;
    }

    @Override
    public boolean hasTank(Object ... data) {
        if (!(data[0] instanceof ItemStack) || !(((ItemStack)data[0]).func_77973_b() instanceof ISustainedTank)) {
            return false;
        }
        BlockMachine.MachineType type = BlockMachine.MachineType.get((ItemStack)data[0]);
        return type == BlockMachine.MachineType.ELECTRIC_PUMP || type == BlockMachine.MachineType.PORTABLE_TANK || type == BlockMachine.MachineType.FLUIDIC_PLENISHER;
    }

    @Override
    public void setAuthenticated(ItemStack itemStack, boolean auth) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74757_a("authenticated", auth);
    }

    @Override
    public boolean getAuthenticated(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return false;
        }
        return itemStack.field_77990_d.func_74767_n("authenticated");
    }

    @Override
    public void setPassword(ItemStack itemStack, String pass) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74778_a("password", pass);
    }

    @Override
    public String getPassword(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return "";
        }
        return itemStack.field_77990_d.func_74779_i("password");
    }

    @Override
    public void setLocked(ItemStack itemStack, boolean locked) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74757_a("locked", locked);
    }

    @Override
    public boolean getLocked(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return false;
        }
        return itemStack.field_77990_d.func_74767_n("locked");
    }

    @Override
    public void setOpen(ItemStack itemStack, boolean open) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74757_a("open", open);
    }

    @Override
    public boolean getOpen(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return false;
        }
        return itemStack.field_77990_d.func_74767_n("open");
    }

    public void setPrevScale(ItemStack itemStack, float prevLidAngle) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74776_a("prevScale", prevLidAngle);
    }

    public float getPrevScale(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return 0.0f;
        }
        return itemStack.field_77990_d.func_74760_g("prevScale");
    }

    public void setBucketMode(ItemStack itemStack, boolean bucketMode) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74757_a("bucketMode", bucketMode);
    }

    public boolean getBucketMode(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return false;
        }
        return itemStack.field_77990_d.func_74767_n("bucketMode");
    }

    @Override
    public double getEnergy(ItemStack itemStack) {
        if (itemStack.field_77990_d == null || !BlockMachine.MachineType.get((ItemStack)itemStack).isElectric) {
            return 0.0;
        }
        return itemStack.field_77990_d.func_74769_h("electricity");
    }

    @Override
    public void setEnergy(ItemStack itemStack, double amount) {
        if (!BlockMachine.MachineType.get((ItemStack)itemStack).isElectric) {
            return;
        }
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        double electricityStored = Math.max(Math.min(amount, this.getMaxEnergy(itemStack)), 0.0);
        itemStack.field_77990_d.func_74780_a("electricity", electricityStored);
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return MekanismUtils.getMaxEnergy(itemStack, this, BlockMachine.MachineType.get((Block)Block.func_149634_a((Item)itemStack.func_77973_b()), (int)itemStack.func_77960_j()).baseEnergy);
    }

    @Override
    public double getMaxTransfer(ItemStack itemStack) {
        return this.getMaxEnergy(itemStack) * 0.005;
    }

    @Override
    public boolean canReceive(ItemStack itemStack) {
        return BlockMachine.MachineType.get((ItemStack)itemStack).isElectric;
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return false;
    }

    public int receiveEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canReceive(theItem)) {
            double energyNeeded = this.getMaxEnergy(theItem) - this.getEnergy(theItem);
            double toReceive = Math.min((double)energy * Mekanism.FROM_TE, energyNeeded);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) + toReceive);
            }
            return (int)Math.round(toReceive * Mekanism.TO_TE);
        }
        return 0;
    }

    public int extractEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canSend(theItem)) {
            double energyRemaining = this.getEnergy(theItem);
            double toSend = Math.min((double)energy * Mekanism.FROM_TE, energyRemaining);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) - toSend);
            }
            return (int)Math.round(toSend * Mekanism.TO_TE);
        }
        return 0;
    }

    public int getEnergyStored(ItemStack theItem) {
        return (int)(this.getEnergy(theItem) * Mekanism.TO_TE);
    }

    public int getMaxEnergyStored(ItemStack theItem) {
        return (int)(this.getMaxEnergy(theItem) * Mekanism.TO_TE);
    }

    @Override
    public boolean isMetadataSpecific(ItemStack itemStack) {
        return true;
    }

    @Optional.Method(modid="IC2API")
    public IElectricItemManager getManager(ItemStack itemStack) {
        return IC2ItemManager.getManager(this);
    }

    @Optional.Method(modid="IC2API")
    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    @Optional.Method(modid="IC2API")
    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public FluidStack getFluid(ItemStack container) {
        return this.getFluidStack(container);
    }

    public int getCapacity(ItemStack container) {
        return 14000;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (BlockMachine.MachineType.get(container) == BlockMachine.MachineType.PORTABLE_TANK && resource != null) {
            FluidStack stored = this.getFluidStack(container);
            int toFill = 0;
            if (stored != null && stored.getFluid() != resource.getFluid()) {
                return 0;
            }
            toFill = stored == null ? Math.min(resource.amount, 14000) : Math.min(resource.amount, 14000 - stored.amount);
            if (doFill) {
                this.setFluidStack(new FluidStack(resource.getFluid(), toFill), container);
            }
            return toFill;
        }
        return 0;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        FluidStack stored;
        if (BlockMachine.MachineType.get(container) == BlockMachine.MachineType.PORTABLE_TANK && (stored = this.getFluidStack(container)) != null) {
            FluidStack toDrain = new FluidStack(stored.getFluid(), Math.min(stored.amount, maxDrain));
            if (doDrain) {
                stored.amount -= toDrain.amount;
                this.setFluidStack((FluidStack)(stored.amount > 0 ? stored : null), container);
            }
            return toDrain;
        }
        return null;
    }
}

