/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.energy.IEnergizedItem;
import mekanism.client.render.ModelCustomArmor;
import mekanism.common.Mekanism;
import mekanism.common.integration.IC2ItemManager;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.entity.living.LivingAttackEvent;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.api.energy.IEnergyContainerItem", modid="CoFHAPI|energy"), @Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="IC2API")})
public class ItemFreeRunners
extends ItemArmor
implements IEnergizedItem,
ISpecialElectricItem,
IEnergyContainerItem {
    public double MAX_ELECTRICITY = 64000.0;

    public ItemFreeRunners() {
        super(EnumHelper.addArmorMaterial((String)"FRICTIONBOOTS", (int)0, (int[])new int[]{0, 0, 0, 0}, (int)0), 0, 3);
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.setNoRepair();
        this.func_77637_a(Mekanism.tabMekanism);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
    }

    public boolean isValidArmor(ItemStack stack, int armorType, Entity entity) {
        return armorType == 3;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "mekanism:render/NullArmor.png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        ModelCustomArmor model = ModelCustomArmor.INSTANCE;
        model.modelType = ModelCustomArmor.ArmorModel.FREERUNNERS;
        return model;
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        list.add((Object)((Object)EnumColor.AQUA) + MekanismUtils.localize("tooltip.storedEnergy") + ": " + (Object)((Object)EnumColor.GREY) + MekanismUtils.getEnergyDisplay(this.getEnergy(itemstack)));
    }

    public ItemStack getUnchargedItem() {
        ItemStack charged = new ItemStack((Item)this);
        charged.func_77964_b(100);
        return charged;
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        ItemStack discharged = new ItemStack((Item)this);
        discharged.func_77964_b(100);
        list.add(discharged);
        ItemStack charged = new ItemStack((Item)this);
        this.setEnergy(charged, ((IEnergizedItem)charged.func_77973_b()).getMaxEnergy(charged));
        list.add(charged);
    }

    @Optional.Method(modid="IC2API")
    public boolean canProvideEnergy(ItemStack itemStack) {
        return this.canSend(itemStack);
    }

    @Optional.Method(modid="IC2API")
    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    @Optional.Method(modid="IC2API")
    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    @Optional.Method(modid="IC2API")
    public double getMaxCharge(ItemStack itemStack) {
        return 0.0;
    }

    @Optional.Method(modid="IC2API")
    public int getTier(ItemStack itemStack) {
        return 4;
    }

    @Optional.Method(modid="IC2API")
    public double getTransferLimit(ItemStack itemStack) {
        return 0.0;
    }

    @Override
    public double getEnergy(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return 0.0;
        }
        double electricityStored = itemStack.field_77990_d.func_74769_h("electricity");
        itemStack.func_77964_b((int)Math.max(1.0, Math.abs(electricityStored / this.getMaxEnergy(itemStack) * 100.0 - 100.0)));
        return electricityStored;
    }

    @Override
    public void setEnergy(ItemStack itemStack, double amount) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        double electricityStored = Math.max(Math.min(amount, this.getMaxEnergy(itemStack)), 0.0);
        itemStack.field_77990_d.func_74780_a("electricity", electricityStored);
        itemStack.func_77964_b((int)Math.max(1.0, Math.abs(electricityStored / this.getMaxEnergy(itemStack) * 100.0 - 100.0)));
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return this.MAX_ELECTRICITY;
    }

    @Override
    public double getMaxTransfer(ItemStack itemStack) {
        return this.getMaxEnergy(itemStack) * 0.005;
    }

    @Override
    public boolean canReceive(ItemStack itemStack) {
        return this.getMaxEnergy(itemStack) - this.getEnergy(itemStack) > 0.0;
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return false;
    }

    public int receiveEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canReceive(theItem)) {
            double energyNeeded = this.getMaxEnergy(theItem) - this.getEnergy(theItem);
            double toReceive = Math.min((double)energy * Mekanism.FROM_TE, energyNeeded);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) + toReceive);
            }
            return (int)Math.round(toReceive * Mekanism.TO_TE);
        }
        return 0;
    }

    public int extractEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canSend(theItem)) {
            double energyRemaining = this.getEnergy(theItem);
            double toSend = Math.min((double)energy * Mekanism.FROM_TE, energyRemaining);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) - toSend);
            }
            return (int)Math.round(toSend * Mekanism.TO_TE);
        }
        return 0;
    }

    public int getEnergyStored(ItemStack theItem) {
        return (int)Math.round(this.getEnergy(theItem) * Mekanism.TO_TE);
    }

    public int getMaxEnergyStored(ItemStack theItem) {
        return (int)Math.round(this.getMaxEnergy(theItem) * Mekanism.TO_TE);
    }

    @Override
    public boolean isMetadataSpecific(ItemStack itemStack) {
        return false;
    }

    @Optional.Method(modid="IC2API")
    public IElectricItemManager getManager(ItemStack itemStack) {
        return IC2ItemManager.getManager(this);
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingAttackEvent event) {
        ItemStack stack;
        ItemFreeRunners boots;
        EntityLivingBase base = event.entityLiving;
        if (base.func_71124_b(1) != null && base.func_71124_b(1).func_77973_b() instanceof ItemFreeRunners && (boots = (ItemFreeRunners)(stack = base.func_71124_b(1)).func_77973_b()).getEnergy(stack) > 0.0 && event.source == DamageSource.field_76379_h) {
            boots.setEnergy(stack, boots.getEnergy(stack) - (double)(event.ammount * 50.0f));
            event.setCanceled(true);
        }
    }
}

