/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.miner;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.common.miner.MItemStackFilter;
import mekanism.common.miner.MMaterialFilter;
import mekanism.common.miner.MModIDFilter;
import mekanism.common.miner.MOreDictFilter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class MinerFilter {
    public abstract boolean canFilter(ItemStack var1);

    public abstract NBTTagCompound write(NBTTagCompound var1);

    protected abstract void read(NBTTagCompound var1);

    public abstract void write(ArrayList var1);

    protected abstract void read(ByteBuf var1);

    public static MinerFilter readFromNBT(NBTTagCompound nbtTags) {
        int type = nbtTags.func_74762_e("type");
        MinerFilter filter = null;
        if (type == 0) {
            filter = new MItemStackFilter();
        } else if (type == 1) {
            filter = new MOreDictFilter();
        } else if (type == 2) {
            filter = new MMaterialFilter();
        } else if (type == 3) {
            filter = new MModIDFilter();
        }
        ((MinerFilter)filter).read(nbtTags);
        return filter;
    }

    public static MinerFilter readFromPacket(ByteBuf dataStream) {
        int type = dataStream.readInt();
        MinerFilter filter = null;
        if (type == 0) {
            filter = new MItemStackFilter();
        } else if (type == 1) {
            filter = new MOreDictFilter();
        } else if (type == 2) {
            filter = new MMaterialFilter();
        } else if (type == 3) {
            filter = new MModIDFilter();
        }
        ((MinerFilter)filter).read(dataStream);
        return filter;
    }

    public boolean equals(Object filter) {
        return filter instanceof MinerFilter;
    }
}

