/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.miner;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.BlockInfo;
import mekanism.api.Coord4D;
import mekanism.common.miner.MinerFilter;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class ThreadMinerSearch
extends Thread {
    public TileEntityDigitalMiner tileEntity;
    public State state = State.IDLE;
    public BitSet oresToMine = new BitSet();
    public Map<BlockInfo, Boolean> acceptedItems = new HashMap<BlockInfo, Boolean>();
    public int found = 0;

    public ThreadMinerSearch(TileEntityDigitalMiner tile) {
        this.tileEntity = tile;
    }

    @Override
    public void run() {
        this.state = State.SEARCHING;
        if (!this.tileEntity.inverse && this.tileEntity.filters.isEmpty()) {
            this.state = State.FINISHED;
            return;
        }
        Coord4D coord = this.tileEntity.getStartingCoord();
        int diameter = this.tileEntity.getDiameter();
        int size = this.tileEntity.getTotalSize();
        BlockInfo info = new BlockInfo(null, 0);
        for (int i = 0; i < size; ++i) {
            TileEntity tile;
            int x = coord.xCoord + i % diameter;
            int z = coord.zCoord + i / diameter % diameter;
            int y = coord.yCoord + i / diameter / diameter;
            if (this.tileEntity.func_145837_r()) {
                return;
            }
            if (this.tileEntity.field_145851_c == x && this.tileEntity.field_145848_d == y && this.tileEntity.field_145849_e == z || !this.tileEntity.func_145831_w().func_72863_F().func_73149_a(x >> 4, z >> 4) || (tile = this.tileEntity.func_145831_w().func_147438_o(x, y, z)) instanceof TileEntityBoundingBlock) continue;
            info.block = this.tileEntity.func_145831_w().func_147439_a(x, y, z);
            info.meta = this.tileEntity.func_145831_w().func_72805_g(x, y, z);
            if (info.block == null || this.tileEntity.func_145831_w().func_147437_c(x, y, z) || !(info.block.func_149712_f(this.tileEntity.func_145831_w(), x, y, z) >= 0.0f)) continue;
            boolean canFilter = false;
            if (this.acceptedItems.containsKey(info)) {
                canFilter = this.acceptedItems.get(info);
            } else {
                ItemStack stack = new ItemStack(info.block, 1, info.meta);
                if (this.tileEntity.replaceStack != null && this.tileEntity.replaceStack.func_77969_a(stack)) continue;
                boolean hasFilter = false;
                for (MinerFilter filter : this.tileEntity.filters) {
                    if (!filter.canFilter(stack)) continue;
                    hasFilter = true;
                }
                canFilter = this.tileEntity.inverse ? !hasFilter : hasFilter;
                this.acceptedItems.put(info, canFilter);
            }
            if (!canFilter) continue;
            this.oresToMine.set(i);
            ++this.found;
        }
        this.state = State.FINISHED;
        this.tileEntity.oresToMine = this.oresToMine;
        MekanismUtils.saveChunk(this.tileEntity);
    }

    public void reset() {
        this.state = State.IDLE;
    }

    public static enum State {
        IDLE("Not ready"),
        SEARCHING("Searching"),
        PAUSED("Paused"),
        FINISHED("Ready");

        public String desc;

        private State(String s) {
            this.desc = s;
        }
    }
}

