/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.HollowMicroblock;
import codechicken.multipart.IconHitEffects;
import codechicken.multipart.JCuboidPart;
import codechicken.multipart.JIconHitEffects;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.render.RenderGlowPanel;
import mekanism.common.Mekanism;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PartGlowPanel
extends JCuboidPart
implements JNormalOcclusion,
JIconHitEffects {
    public EnumColor colour = EnumColor.WHITE;
    public ForgeDirection side = ForgeDirection.DOWN;
    public static Cuboid6[] bounds = new Cuboid6[6];

    public PartGlowPanel() {
    }

    public PartGlowPanel(EnumColor colour, ForgeDirection side) {
        this.setColour(colour);
        this.setOrientation(side);
    }

    public Cuboid6 getBounds() {
        return bounds[this.side.ordinal()];
    }

    public String getType() {
        return "mekanism:glow_panel";
    }

    public void setColour(EnumColor newColour) {
        this.colour = newColour;
    }

    public void setOrientation(ForgeDirection newSide) {
        this.side = newSide;
    }

    public void onNeighborChanged() {
        if (!this.world().field_72995_K && !this.canStay()) {
            TileMultipart.dropItem((ItemStack)new ItemStack(Mekanism.GlowPanel, 1, this.colour.getMetaValue()), (World)this.world(), (Vector3)Vector3.fromTileEntityCenter((TileEntity)this.tile()));
            this.tile().remPart((TMultiPart)this);
        }
    }

    public void onPartChanged(TMultiPart other) {
        if (!this.world().field_72995_K && !this.canStay()) {
            TileMultipart.dropItem((ItemStack)new ItemStack(Mekanism.GlowPanel, 1, this.colour.getMetaValue()), (World)this.world(), (Vector3)Vector3.fromTileEntityCenter((TileEntity)this.tile()));
            this.tile().remPart((TMultiPart)this);
        }
    }

    public void writeDesc(MCDataOutput data) {
        data.writeInt(this.side.ordinal());
        data.writeInt(this.colour.getMetaValue());
    }

    public void readDesc(MCDataInput data) {
        this.side = ForgeDirection.getOrientation((int)data.readInt());
        this.colour = EnumColor.DYES[data.readInt()];
    }

    public void save(NBTTagCompound nbt) {
        nbt.func_74768_a("side", this.side.ordinal());
        nbt.func_74768_a("colour", this.colour.getMetaValue());
    }

    public void load(NBTTagCompound nbt) {
        this.side = ForgeDirection.getOrientation((int)nbt.func_74762_e("side"));
        this.colour = EnumColor.DYES[nbt.func_74762_e("colour")];
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderStatic(Vector3 pos, int pass) {
        if (pass == 0) {
            RenderGlowPanel.getInstance().renderStatic(this);
            return true;
        }
        return false;
    }

    public int getLightValue() {
        return 15;
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        return this.getCollisionBoxes();
    }

    public boolean occlusionTest(TMultiPart other) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)other);
    }

    public IIcon getBreakingIcon(Object subPart, int side) {
        return RenderGlowPanel.icon;
    }

    public IIcon getBrokenIcon(int side) {
        return RenderGlowPanel.icon;
    }

    public void addHitEffects(MovingObjectPosition hit, EffectRenderer effectRenderer) {
        IconHitEffects.addHitEffects((JIconHitEffects)this, (MovingObjectPosition)hit, (EffectRenderer)effectRenderer);
    }

    public void addDestroyEffects(MovingObjectPosition mop, EffectRenderer effectRenderer) {
        IconHitEffects.addDestroyEffects((JIconHitEffects)this, (EffectRenderer)effectRenderer, (boolean)false);
    }

    public Iterable<ItemStack> getDrops() {
        return Collections.singletonList(this.pickItem(null));
    }

    public ItemStack pickItem(MovingObjectPosition hit) {
        return new ItemStack(Mekanism.GlowPanel, 1, this.colour.getMetaValue());
    }

    public boolean doesTick() {
        return false;
    }

    public boolean canStay() {
        Coord4D adj = Coord4D.get((TileEntity)this.tile()).getFromSide(this.side);
        return this.world().isSideSolid(adj.xCoord, adj.yCoord, adj.zCoord, this.side.getOpposite()) || this.tile().partMap(this.side.ordinal()) instanceof HollowMicroblock;
    }

    static {
        Cuboid6 cuboid = new Cuboid6(0.25, 0.0, 0.25, 0.75, 0.125, 0.75);
        Translation fromOrigin = new Translation(Vector3.center);
        Translation toOrigin = (Translation)fromOrigin.inverse();
        for (int i = 0; i < 6; ++i) {
            PartGlowPanel.bounds[i] = cuboid.copy().apply((Transformation)toOrigin).apply(Rotation.sideRotations[i]).apply((Transformation)fromOrigin);
        }
    }
}

