/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import codechicken.lib.vec.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Set;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.render.RenderPartTransmitter;
import mekanism.common.FluidNetwork;
import mekanism.common.Tier;
import mekanism.common.multipart.PartSidedPipe;
import mekanism.common.multipart.PartTransmitter;
import mekanism.common.multipart.TransmitterIcons;
import mekanism.common.multipart.TransmitterType;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class PartMechanicalPipe
extends PartTransmitter<FluidNetwork>
implements IFluidHandler {
    public Tier.PipeTier tier;
    public FluidTank dummyTank = new FluidTank(1000);
    public static TransmitterIcons pipeIcons = new TransmitterIcons(4, 1);
    public float currentScale;
    public FluidStack cacheFluid;
    public FluidStack lastWrite;

    public PartMechanicalPipe(Tier.PipeTier pipeTier) {
        this.tier = pipeTier;
    }

    @Override
    public void update() {
        if (!this.world().field_72995_K) {
            if (this.cacheFluid != null) {
                if (((FluidNetwork)this.getTransmitterNetwork()).fluidStored == null) {
                    ((FluidNetwork)this.getTransmitterNetwork()).fluidStored = this.cacheFluid;
                } else {
                    ((FluidNetwork)this.getTransmitterNetwork()).fluidStored.amount += this.cacheFluid.amount;
                }
                this.cacheFluid = null;
            }
            if (this.getTransmitterNetwork(false) != null && ((FluidNetwork)this.getTransmitterNetwork(false)).getSize() > 0) {
                int last;
                int n = last = this.lastWrite != null ? this.lastWrite.amount : 0;
                if (last != this.getSaveShare()) {
                    MekanismUtils.saveChunk((TileEntity)this.tile());
                }
            }
            IFluidHandler[] connectedAcceptors = PipeUtils.getConnectedAcceptors((TileEntity)this.tile());
            for (ForgeDirection side : this.getConnections(PartSidedPipe.ConnectionType.PULL)) {
                FluidStack received;
                IFluidHandler container;
                if (connectedAcceptors[side.ordinal()] == null || (container = connectedAcceptors[side.ordinal()]) == null || (received = container.drain(side.getOpposite(), this.getPullAmount(), false)) == null || received.amount == 0) continue;
                container.drain(side.getOpposite(), ((FluidNetwork)this.getTransmitterNetwork()).emit(received, true), true);
            }
        }
        super.update();
    }

    private int getSaveShare() {
        if (((FluidNetwork)this.getTransmitterNetwork()).fluidStored != null) {
            int remain = ((FluidNetwork)this.getTransmitterNetwork()).fluidStored.amount % ((FluidNetwork)this.getTransmitterNetwork()).transmitters.size();
            int toSave = ((FluidNetwork)this.getTransmitterNetwork()).fluidStored.amount / ((FluidNetwork)this.getTransmitterNetwork()).transmitters.size();
            if (((FluidNetwork)this.getTransmitterNetwork()).isFirst((IGridTransmitter)this.tile())) {
                toSave += remain;
            }
            return toSave;
        }
        return 0;
    }

    @Override
    public void onChunkUnload() {
        if (!this.world().field_72995_K && this.lastWrite != null && ((FluidNetwork)this.getTransmitterNetwork()).fluidStored != null) {
            ((FluidNetwork)this.getTransmitterNetwork()).fluidStored.amount -= this.lastWrite.amount;
            if (((FluidNetwork)this.getTransmitterNetwork()).fluidStored.amount <= 0) {
                ((FluidNetwork)this.getTransmitterNetwork()).fluidStored = null;
            }
        }
        super.onChunkUnload();
    }

    @Override
    public void preSingleMerge(FluidNetwork network) {
        if (this.cacheFluid != null) {
            if (network.fluidStored == null) {
                network.fluidStored = this.cacheFluid;
            } else {
                network.fluidStored.amount += this.cacheFluid.amount;
            }
            this.cacheFluid = null;
        }
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        super.load(nbtTags);
        if (nbtTags.func_74764_b("cacheFluid")) {
            this.cacheFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtTags.func_74775_l("cacheFluid"));
        }
        this.tier = Tier.PipeTier.values()[nbtTags.func_74762_e("tier")];
    }

    @Override
    public void save(NBTTagCompound nbtTags) {
        super.save(nbtTags);
        if (this.getTransmitterNetwork(false) != null && ((FluidNetwork)this.getTransmitterNetwork(false)).getSize() > 0 && ((FluidNetwork)this.getTransmitterNetwork((boolean)false)).fluidStored != null) {
            int remain = ((FluidNetwork)this.getTransmitterNetwork()).fluidStored.amount % ((FluidNetwork)this.getTransmitterNetwork()).transmitters.size();
            int toSave = ((FluidNetwork)this.getTransmitterNetwork()).fluidStored.amount / ((FluidNetwork)this.getTransmitterNetwork()).transmitters.size();
            if (((FluidNetwork)this.getTransmitterNetwork()).isFirst((IGridTransmitter)this.tile())) {
                toSave += remain;
            }
            if (toSave > 0) {
                FluidStack stack;
                this.lastWrite = stack = new FluidStack(((FluidNetwork)this.getTransmitterNetwork()).fluidStored.getFluid(), toSave);
                nbtTags.func_74782_a("cacheFluid", (NBTBase)stack.writeToNBT(new NBTTagCompound()));
            }
        }
        nbtTags.func_74768_a("tier", this.tier.ordinal());
    }

    public String getType() {
        return "mekanism:mechanical_pipe_" + this.tier.name().toLowerCase();
    }

    public static void registerIcons(IIconRegister register) {
        pipeIcons.registerCenterIcons(register, new String[]{"MechanicalPipeBasic", "MechanicalPipeAdvanced", "MechanicalPipeElite", "MechanicalPipeUltimate"});
        pipeIcons.registerSideIcons(register, new String[]{"MechanicalPipeSide"});
    }

    @Override
    public IIcon getCenterIcon() {
        return pipeIcons.getCenterIcon(this.tier.ordinal());
    }

    @Override
    public IIcon getSideIcon() {
        return pipeIcons.getSideIcon(0);
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.FLUID;
    }

    @Override
    public TransmitterType getTransmitter() {
        return this.tier.type;
    }

    @Override
    public boolean isValidAcceptor(TileEntity tile, ForgeDirection side) {
        return PipeUtils.getConnections((TileEntity)this.tile())[side.ordinal()];
    }

    @Override
    public FluidNetwork createNetworkFromSingleTransmitter(IGridTransmitter<FluidNetwork> transmitter) {
        return new FluidNetwork(transmitter);
    }

    @Override
    public FluidNetwork createNetworkByMergingSet(Set<FluidNetwork> networks) {
        return new FluidNetwork(networks);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 pos, float f, int pass) {
        if (pass == 0) {
            RenderPartTransmitter.getInstance().renderContents(this, pos);
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.getConnectionType(from) == PartSidedPipe.ConnectionType.NORMAL) {
            return ((FluidNetwork)this.getTransmitterNetwork()).emit(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.getConnectionType(from) == PartSidedPipe.ConnectionType.NORMAL;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.getConnectionType(from) != PartSidedPipe.ConnectionType.NONE) {
            return new FluidTankInfo[]{this.dummyTank.getInfo()};
        }
        return new FluidTankInfo[0];
    }

    @Override
    public int getTransmitterNetworkSize() {
        return ((FluidNetwork)this.getTransmitterNetwork()).getSize();
    }

    @Override
    public int getTransmitterNetworkAcceptorSize() {
        return ((FluidNetwork)this.getTransmitterNetwork()).getAcceptorSize();
    }

    @Override
    public String getTransmitterNetworkNeeded() {
        return ((FluidNetwork)this.getTransmitterNetwork()).getNeededInfo();
    }

    @Override
    public String getTransmitterNetworkFlow() {
        return ((FluidNetwork)this.getTransmitterNetwork()).getFlowInfo();
    }

    @Override
    public int getCapacity() {
        return this.tier.pipeCapacity;
    }

    public int getPullAmount() {
        return this.tier.pipePullAmount;
    }
}

