/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import buildcraft.api.tools.IToolWrench;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.ExtendedMOP;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.render.CCModel;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.ISidedHollowConnect;
import codechicken.multipart.INeighborTileChange;
import codechicken.multipart.IconHitEffects;
import codechicken.multipart.JIconHitEffects;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.PartMap;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TSlottedPart;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.IConfigurable;
import mekanism.api.transmitters.IBlockableConnection;
import mekanism.api.transmitters.ITransmitter;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.render.RenderPartTransmitter;
import mekanism.common.ITileNetwork;
import mekanism.common.Mekanism;
import mekanism.common.Tier;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.multipart.PartDiversionTransporter;
import mekanism.common.multipart.PartLogisticalTransporter;
import mekanism.common.multipart.PartMechanicalPipe;
import mekanism.common.multipart.PartPressurizedTube;
import mekanism.common.multipart.PartRestrictiveTransporter;
import mekanism.common.multipart.PartUniversalCable;
import mekanism.common.multipart.TransmitterType;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class PartSidedPipe
extends TMultiPart
implements TSlottedPart,
JNormalOcclusion,
ISidedHollowConnect,
JIconHitEffects,
ITileNetwork,
IBlockableConnection,
IConfigurable,
ITransmitter,
INeighborTileChange {
    public static IndexedCuboid6[] smallSides = new IndexedCuboid6[7];
    public static IndexedCuboid6[] largeSides = new IndexedCuboid6[7];
    public int delayTicks;
    public ForgeDirection testingSide = null;
    public byte currentAcceptorConnections = 0;
    public byte currentTransmitterConnections = 0;
    public boolean sendDesc = false;
    public boolean redstonePowered = false;
    public boolean redstoneReactive = true;
    public ConnectionType[] connectionTypes = new ConnectionType[]{ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL};

    public static TMultiPart getPartType(TransmitterType type) {
        switch (type) {
            case UNIVERSAL_CABLE_BASIC: {
                return new PartUniversalCable(Tier.CableTier.BASIC);
            }
            case UNIVERSAL_CABLE_ADVANCED: {
                return new PartUniversalCable(Tier.CableTier.ADVANCED);
            }
            case UNIVERSAL_CABLE_ELITE: {
                return new PartUniversalCable(Tier.CableTier.ELITE);
            }
            case UNIVERSAL_CABLE_ULTIMATE: {
                return new PartUniversalCable(Tier.CableTier.ULTIMATE);
            }
            case MECHANICAL_PIPE_BASIC: {
                return new PartMechanicalPipe(Tier.PipeTier.BASIC);
            }
            case MECHANICAL_PIPE_ADVANCED: {
                return new PartMechanicalPipe(Tier.PipeTier.ADVANCED);
            }
            case MECHANICAL_PIPE_ELITE: {
                return new PartMechanicalPipe(Tier.PipeTier.ELITE);
            }
            case MECHANICAL_PIPE_ULTIMATE: {
                return new PartMechanicalPipe(Tier.PipeTier.ULTIMATE);
            }
            case PRESSURIZED_TUBE: {
                return new PartPressurizedTube();
            }
            case LOGISTICAL_TRANSPORTER: {
                return new PartLogisticalTransporter();
            }
            case RESTRICTIVE_TRANSPORTER: {
                return new PartRestrictiveTransporter();
            }
            case DIVERSION_TRANSPORTER: {
                return new PartDiversionTransporter();
            }
        }
        return null;
    }

    public static boolean connectionMapContainsSide(byte connections, ForgeDirection side) {
        byte tester = (byte)(1 << side.ordinal());
        return (connections & tester) > 0;
    }

    public abstract IIcon getCenterIcon();

    public abstract IIcon getSideIcon();

    public void update() {
        if (this.world().field_72995_K) {
            if (this.delayTicks == 5) {
                this.delayTicks = 6;
                this.refreshConnections();
            } else if (this.delayTicks < 5) {
                ++this.delayTicks;
            }
        }
        if (this.sendDesc && !this.world().field_72995_K) {
            this.sendDescUpdate();
            this.sendDesc = false;
        }
    }

    public IIcon getIconForSide(ForgeDirection side) {
        ConnectionType type = this.getConnectionType(side);
        if (type == ConnectionType.NONE) {
            return this.getCenterIcon();
        }
        return this.getSideIcon();
    }

    public byte getPossibleTransmitterConnections() {
        byte connections = 0;
        if (this.redstoneReactive && this.world().func_72864_z(this.x(), this.y(), this.z())) {
            return connections;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity;
            if (!this.canConnectMutual(side) || !TransmissionType.checkTransmissionType(tileEntity = Coord4D.get((TileEntity)this.tile()).getFromSide(side).getTileEntity((IBlockAccess)this.world()), this.getTransmitter().getTransmission())) continue;
            connections = (byte)(connections | 1 << side.ordinal());
        }
        return connections;
    }

    public byte getPossibleAcceptorConnections() {
        byte connections = 0;
        if (this.redstoneReactive && this.world().func_72864_z(this.x(), this.y(), this.z())) {
            return connections;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity;
            if (!this.canConnectMutual(side) || !this.isValidAcceptor(tileEntity = Coord4D.get((TileEntity)this.tile()).getFromSide(side).getTileEntity((IBlockAccess)this.world()), side)) continue;
            connections = (byte)(connections | 1 << side.ordinal());
        }
        return connections;
    }

    public byte getAllCurrentConnections() {
        return (byte)(this.currentTransmitterConnections | this.currentAcceptorConnections);
    }

    public boolean occlusionTest(TMultiPart other) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)other);
    }

    public Iterable<IndexedCuboid6> getSubParts() {
        HashSet<IndexedCuboid6> subParts = new HashSet<IndexedCuboid6>();
        if (this.tile() != null) {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                int ord = side.ordinal();
                byte connections = this.getAllCurrentConnections();
                if (!PartSidedPipe.connectionMapContainsSide(connections, side) && side != this.testingSide) continue;
                subParts.add(this.getTransmitter().getSize() == TransmitterType.Size.SMALL ? smallSides[ord] : largeSides[ord]);
            }
        }
        subParts.add(this.getTransmitter().getSize() == TransmitterType.Size.SMALL ? smallSides[6] : largeSides[6]);
        return subParts;
    }

    public abstract TransmitterType getTransmitter();

    public Iterable<Cuboid6> getCollisionBoxes() {
        HashSet<Cuboid6> collisionBoxes = new HashSet<Cuboid6>();
        collisionBoxes.addAll((Collection)this.getSubParts());
        return collisionBoxes;
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        return this.getCollisionBoxes();
    }

    public int getSlotMask() {
        return PartMap.CENTER.mask;
    }

    public IIcon getBreakingIcon(Object subPart, int side) {
        return this.getCenterIcon();
    }

    public IIcon getBrokenIcon(int side) {
        return this.getCenterIcon();
    }

    public Cuboid6 getBounds() {
        return this.getTransmitter().getSize() == TransmitterType.Size.SMALL ? smallSides[6] : largeSides[6];
    }

    public int getHollowSize(int side) {
        ForgeDirection direction = ForgeDirection.getOrientation((int)side);
        if (PartSidedPipe.connectionMapContainsSide(this.getAllCurrentConnections(), direction) || direction == this.testingSide) {
            return this.getTransmitter().getSize().centerSize + 1;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderStatic(Vector3 pos, int pass) {
        if (pass == 1) {
            RenderPartTransmitter.getInstance().renderStatic(this);
            return true;
        }
        return false;
    }

    public void addHitEffects(MovingObjectPosition hit, EffectRenderer effectRenderer) {
        IconHitEffects.addHitEffects((JIconHitEffects)this, (MovingObjectPosition)hit, (EffectRenderer)effectRenderer);
    }

    public void addDestroyEffects(MovingObjectPosition mop, EffectRenderer effectRenderer) {
        IconHitEffects.addDestroyEffects((JIconHitEffects)this, (EffectRenderer)effectRenderer, (boolean)false);
    }

    public abstract boolean isValidAcceptor(TileEntity var1, ForgeDirection var2);

    @Override
    public boolean canConnectMutual(ForgeDirection side) {
        if (!this.canConnect(side)) {
            return false;
        }
        TileEntity tile = Coord4D.get((TileEntity)this.tile()).getFromSide(side).getTileEntity((IBlockAccess)this.world());
        return !(tile instanceof IBlockableConnection) || ((IBlockableConnection)tile).canConnect(side.getOpposite());
    }

    @Override
    public boolean canConnect(ForgeDirection side) {
        if (this.redstoneReactive && this.world().func_72864_z(this.x(), this.y(), this.z())) {
            return false;
        }
        this.testingSide = side;
        boolean unblocked = this.tile().canReplacePart((TMultiPart)this, (TMultiPart)this);
        this.testingSide = null;
        return unblocked;
    }

    public void readDesc(MCDataInput packet) {
        this.currentTransmitterConnections = packet.readByte();
        this.currentAcceptorConnections = packet.readByte();
        for (int i = 0; i < 6; ++i) {
            this.connectionTypes[i] = ConnectionType.values()[packet.readInt()];
        }
        if (this.tile() != null) {
            this.tile().internalPartChange((TMultiPart)this);
            this.tile().markRender();
        }
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeByte((int)this.currentTransmitterConnections);
        packet.writeByte((int)this.currentAcceptorConnections);
        for (int i = 0; i < 6; ++i) {
            packet.writeInt(this.connectionTypes[i].ordinal());
        }
    }

    public void load(NBTTagCompound nbtTags) {
        super.load(nbtTags);
        this.redstoneReactive = nbtTags.func_74767_n("redstoneReactive");
        for (int i = 0; i < 6; ++i) {
            this.connectionTypes[i] = ConnectionType.values()[nbtTags.func_74762_e("connection" + i)];
        }
    }

    public void save(NBTTagCompound nbtTags) {
        super.save(nbtTags);
        nbtTags.func_74757_a("redstoneReactive", this.redstoneReactive);
        for (int i = 0; i < 6; ++i) {
            nbtTags.func_74768_a("connection" + i, this.connectionTypes[i].ordinal());
        }
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition part, ItemStack item) {
        if (item == null) {
            return false;
        }
        if (ModAPIManager.INSTANCE.hasAPI("BuildCraftAPI|tools") && item.func_77973_b() instanceof IToolWrench && !(item.func_77973_b() instanceof ItemConfigurator) && player.func_70093_af()) {
            if (!this.world().field_72995_K) {
                this.tile().dropItems(this.getDrops());
                this.tile().remPart((TMultiPart)this);
            }
            return true;
        }
        return false;
    }

    public Iterable<ItemStack> getDrops() {
        return Collections.singletonList(this.pickItem(null));
    }

    public ItemStack pickItem(MovingObjectPosition hit) {
        return new ItemStack(Mekanism.PartTransmitter, 1, this.getTransmitter().ordinal());
    }

    public boolean doesTick() {
        return true;
    }

    protected void onRedstoneSplit() {
    }

    protected void onRedstoneJoin() {
    }

    protected void onRefresh() {
    }

    public void refreshConnections() {
        byte possibleTransmitters = this.getPossibleTransmitterConnections();
        byte possibleAcceptors = this.getPossibleAcceptorConnections();
        if (possibleTransmitters != this.currentTransmitterConnections) {
            boolean nowPowered;
            boolean bl = nowPowered = this.redstoneReactive && this.world().func_72864_z(this.x(), this.y(), this.z());
            if (nowPowered != this.redstonePowered) {
                this.redstonePowered = nowPowered;
                if (nowPowered) {
                    this.onRedstoneSplit();
                } else {
                    this.onRedstoneJoin();
                }
                this.tile().notifyPartChange((TMultiPart)this);
            }
        }
        if (!this.world().field_72995_K) {
            this.currentTransmitterConnections = possibleTransmitters;
            this.currentAcceptorConnections = possibleAcceptors;
        }
        this.onRefresh();
        if (!this.world().field_72995_K) {
            this.sendDesc = true;
        }
    }

    protected void onModeChange(ForgeDirection side) {
        this.refreshConnections();
    }

    public void onAdded() {
        super.onAdded();
        this.refreshConnections();
    }

    public void onChunkLoad() {
        super.onChunkLoad();
        this.refreshConnections();
    }

    public void onNeighborTileChanged(int side, boolean weak) {
        this.refreshConnections();
    }

    public void onPartChanged(TMultiPart part) {
        super.onPartChanged(part);
        this.refreshConnections();
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) throws Exception {
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        return data;
    }

    public ConnectionType getConnectionType(ForgeDirection side) {
        if (!PartSidedPipe.connectionMapContainsSide(this.getAllCurrentConnections(), side)) {
            return ConnectionType.NONE;
        }
        if (PartSidedPipe.connectionMapContainsSide(this.currentTransmitterConnections, side)) {
            return ConnectionType.NORMAL;
        }
        return this.connectionTypes[side.ordinal()];
    }

    public List<ForgeDirection> getConnections(ConnectionType type) {
        ArrayList<ForgeDirection> sides = new ArrayList<ForgeDirection>();
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (this.getConnectionType(side) != type) continue;
            sides.add(side);
        }
        return sides;
    }

    public CCModel getModelForSide(ForgeDirection side, boolean internal) {
        String sideName = side.name().toLowerCase();
        String typeName = this.getConnectionType(side).name().toUpperCase();
        String name = sideName + typeName;
        if (internal) {
            return RenderPartTransmitter.contents_models.get(name);
        }
        if (this.getTransmitter().getSize() == TransmitterType.Size.LARGE) {
            return RenderPartTransmitter.large_models.get(name);
        }
        return RenderPartTransmitter.small_models.get(name);
    }

    @Override
    public boolean onSneakRightClick(EntityPlayer player, int side) {
        ExtendedMOP hit = (ExtendedMOP)RayTracer.retraceBlock((World)this.world(), (EntityPlayer)player, (int)this.x(), (int)this.y(), (int)this.z());
        if (hit == null) {
            return false;
        }
        if (hit.subHit < 6) {
            this.connectionTypes[hit.subHit] = this.connectionTypes[hit.subHit].next();
            this.sendDesc = true;
            this.onModeChange(ForgeDirection.getOrientation((int)side));
            player.func_145747_a((IChatComponent)new ChatComponentText("Connection type changed to " + this.connectionTypes[hit.subHit].toString()));
            return true;
        }
        return this.onConfigure(player, hit.subHit, side);
    }

    protected boolean onConfigure(EntityPlayer player, int part, int side) {
        return false;
    }

    public EnumColor getRenderColor() {
        return null;
    }

    @Override
    public boolean onRightClick(EntityPlayer player, int side) {
        this.redstoneReactive ^= true;
        this.refreshConnections();
        this.tile().notifyPartChange((TMultiPart)this);
        player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " Redstone sensitivity turned " + (Object)((Object)EnumColor.INDIGO) + (this.redstoneReactive ? "on." : "off.")));
        return true;
    }

    public boolean canConnectToAcceptor(ForgeDirection side, boolean ignoreActive) {
        if (!this.isValidAcceptor(Coord4D.get((TileEntity)this.tile()).getFromSide(side).getTileEntity((IBlockAccess)this.world()), side) || !PartSidedPipe.connectionMapContainsSide(this.currentAcceptorConnections, side)) {
            return false;
        }
        if (!ignoreActive) {
            return this.getConnectionType(side) == ConnectionType.NORMAL || this.getConnectionType(side) == ConnectionType.PUSH;
        }
        return this.connectionTypes[side.ordinal()] == ConnectionType.NORMAL || this.connectionTypes[side.ordinal()] == ConnectionType.PUSH;
    }

    public boolean weakTileChanges() {
        return false;
    }

    static {
        PartSidedPipe.smallSides[0] = new IndexedCuboid6((Object)0, new Cuboid6(0.3, 0.0, 0.3, 0.7, 0.3, 0.7));
        PartSidedPipe.smallSides[1] = new IndexedCuboid6((Object)1, new Cuboid6(0.3, 0.7, 0.3, 0.7, 1.0, 0.7));
        PartSidedPipe.smallSides[2] = new IndexedCuboid6((Object)2, new Cuboid6(0.3, 0.3, 0.0, 0.7, 0.7, 0.3));
        PartSidedPipe.smallSides[3] = new IndexedCuboid6((Object)3, new Cuboid6(0.3, 0.3, 0.7, 0.7, 0.7, 1.0));
        PartSidedPipe.smallSides[4] = new IndexedCuboid6((Object)4, new Cuboid6(0.0, 0.3, 0.3, 0.3, 0.7, 0.7));
        PartSidedPipe.smallSides[5] = new IndexedCuboid6((Object)5, new Cuboid6(0.7, 0.3, 0.3, 1.0, 0.7, 0.7));
        PartSidedPipe.smallSides[6] = new IndexedCuboid6((Object)6, new Cuboid6(0.3, 0.3, 0.3, 0.7, 0.7, 0.7));
        PartSidedPipe.largeSides[0] = new IndexedCuboid6((Object)0, new Cuboid6(0.25, 0.0, 0.25, 0.75, 0.25, 0.75));
        PartSidedPipe.largeSides[1] = new IndexedCuboid6((Object)1, new Cuboid6(0.25, 0.75, 0.25, 0.75, 1.0, 0.75));
        PartSidedPipe.largeSides[2] = new IndexedCuboid6((Object)2, new Cuboid6(0.25, 0.25, 0.0, 0.75, 0.75, 0.25));
        PartSidedPipe.largeSides[3] = new IndexedCuboid6((Object)3, new Cuboid6(0.25, 0.25, 0.75, 0.75, 0.75, 1.0));
        PartSidedPipe.largeSides[4] = new IndexedCuboid6((Object)4, new Cuboid6(0.0, 0.25, 0.25, 0.25, 0.75, 0.75));
        PartSidedPipe.largeSides[5] = new IndexedCuboid6((Object)5, new Cuboid6(0.75, 0.25, 0.25, 1.0, 0.75, 0.75));
        PartSidedPipe.largeSides[6] = new IndexedCuboid6((Object)6, new Cuboid6(0.25, 0.25, 0.25, 0.75, 0.75, 0.75));
    }

    public static enum ConnectionType {
        NORMAL,
        PUSH,
        PULL,
        NONE;


        public ConnectionType next() {
            if (this.ordinal() == ConnectionType.values().length - 1) {
                return NORMAL;
            }
            return ConnectionType.values()[this.ordinal() + 1];
        }
    }
}

