/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import codechicken.multipart.TileMultipart;
import java.util.HashSet;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.IConfigurable;
import mekanism.api.Range4D;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.TransmissionType;
import mekanism.api.transmitters.TransmitterNetworkRegistry;
import mekanism.client.ClientTickHandler;
import mekanism.common.Mekanism;
import mekanism.common.multipart.PartSidedPipe;
import mekanism.common.network.PacketTransmitterUpdate;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class PartTransmitter<N extends DynamicNetwork<?, N>>
extends PartSidedPipe
implements IGridTransmitter<N>,
IConfigurable {
    public N theNetwork;

    public void bind(TileMultipart t) {
        if (this.tile() != null && this.theNetwork != null) {
            ((DynamicNetwork)this.getTransmitterNetwork()).transmitters.remove(this.tile());
            super.bind(t);
            ((DynamicNetwork)this.getTransmitterNetwork()).transmitters.add((IGridTransmitter)this.tile());
        } else {
            super.bind(t);
        }
    }

    @Override
    public void refreshTransmitterNetwork() {
        this.getTransmitterNetwork().refresh(this);
        this.getTransmitterNetwork().refresh();
    }

    @Override
    public void onRefresh() {
        this.refreshTransmitterNetwork();
    }

    @Override
    public void onRedstoneSplit() {
        ((DynamicNetwork)this.getTransmitterNetwork()).split((IGridTransmitter)this.tile());
        this.setTransmitterNetwork(null);
    }

    @Override
    public void onRedstoneJoin() {
        this.setTransmitterNetwork(null);
        this.getTransmitterNetwork();
    }

    @Override
    public void setTransmitterNetwork(N network) {
        if (network != this.theNetwork) {
            this.removeFromTransmitterNetwork();
            this.theNetwork = network;
        }
    }

    @Override
    public boolean areTransmitterNetworksEqual(TileEntity tileEntity) {
        return tileEntity instanceof IGridTransmitter && this.getTransmissionType() == ((IGridTransmitter)tileEntity).getTransmissionType();
    }

    @Override
    public N getTransmitterNetwork() {
        return this.getTransmitterNetwork(true);
    }

    @Override
    public N getTransmitterNetwork(boolean createIfNull) {
        if (this.theNetwork == null && createIfNull) {
            byte possibleTransmitters = this.getPossibleTransmitterConnections();
            HashSet connectedNets = new HashSet();
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity cable;
                if (!PartTransmitter.connectionMapContainsSide(possibleTransmitters, side) || !TransmissionType.checkTransmissionType(cable = Coord4D.get((TileEntity)this.tile()).getFromSide(side).getTileEntity((IBlockAccess)this.world()), this.getTransmissionType()) || ((IGridTransmitter)cable).getTransmitterNetwork(false) == null) continue;
                connectedNets.add(((IGridTransmitter)cable).getTransmitterNetwork());
            }
            if (connectedNets.size() == 0) {
                this.theNetwork = this.createNetworkFromSingleTransmitter((IGridTransmitter)this.tile());
                ((DynamicNetwork)this.theNetwork).fullRefresh();
                ((DynamicNetwork)this.theNetwork).updateCapacity();
            } else if (connectedNets.size() == 1) {
                DynamicNetwork network = (DynamicNetwork)connectedNets.iterator().next();
                this.preSingleMerge(network);
                this.theNetwork = network;
                ((DynamicNetwork)this.theNetwork).transmitters.add((IGridTransmitter)this.tile());
                ((DynamicNetwork)this.theNetwork).fullRefresh();
                ((DynamicNetwork)this.theNetwork).updateCapacity();
            } else {
                this.theNetwork = this.createNetworkByMergingSet(connectedNets);
                ((DynamicNetwork)this.theNetwork).transmitters.add((IGridTransmitter)this.tile());
                ((DynamicNetwork)this.theNetwork).fullRefresh();
                ((DynamicNetwork)this.theNetwork).updateCapacity();
            }
        }
        return this.theNetwork;
    }

    public void preSingleMerge(N network) {
    }

    @Override
    public void removeFromTransmitterNetwork() {
        if (this.theNetwork != null) {
            ((DynamicNetwork)this.theNetwork).removeTransmitter((IGridTransmitter)this.tile());
        }
    }

    @Override
    public void fixTransmitterNetwork() {
        ((DynamicNetwork)this.getTransmitterNetwork()).fixMessedUpNetwork((IGridTransmitter)this.tile());
    }

    public abstract N createNetworkFromSingleTransmitter(IGridTransmitter<N> var1);

    public abstract N createNetworkByMergingSet(Set<N> var1);

    public void onChunkUnload() {
        super.onChunkUnload();
        ((DynamicNetwork)this.getTransmitterNetwork()).split(this);
        if (!this.world().field_72995_K) {
            TransmitterNetworkRegistry.getInstance().pruneEmptyNetworks();
        } else {
            try {
                ClientTickHandler.killDeadNetworks();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void preRemove() {
        if (this.tile() instanceof IGridTransmitter) {
            ((DynamicNetwork)this.getTransmitterNetwork()).split((IGridTransmitter)this.tile());
            if (!this.world().field_72995_K) {
                TransmitterNetworkRegistry.getInstance().pruneEmptyNetworks();
            } else {
                try {
                    ClientTickHandler.killDeadNetworks();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        super.preRemove();
    }

    @Override
    protected void onModeChange(ForgeDirection side) {
        super.onModeChange(side);
        if (!this.world().field_72995_K) {
            Mekanism.packetHandler.sendToReceivers(new PacketTransmitterUpdate.TransmitterUpdateMessage(PacketTransmitterUpdate.PacketType.UPDATE, Coord4D.get((TileEntity)this.tile()), new Object[0]), new Range4D(Coord4D.get((TileEntity)this.tile())));
        }
    }

    @Override
    public void onNeighborTileChanged(int side, boolean weak) {
        super.onNeighborTileChanged(side, weak);
        if (!this.world().field_72995_K) {
            Mekanism.packetHandler.sendToReceivers(new PacketTransmitterUpdate.TransmitterUpdateMessage(PacketTransmitterUpdate.PacketType.UPDATE, Coord4D.get((TileEntity)this.tile()), new Object[0]), new Range4D(Coord4D.get((TileEntity)this.tile())));
        }
    }

    @Override
    public TileEntity getTile() {
        return this.tile();
    }

    @Override
    public void chunkLoad() {
    }
}

