/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import codechicken.lib.vec.Vector3;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.tile.IEnergySource;
import java.util.List;
import java.util.Set;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.MekanismClient;
import mekanism.client.render.RenderPartTransmitter;
import mekanism.common.EnergyNetwork;
import mekanism.common.Mekanism;
import mekanism.common.Tier;
import mekanism.common.multipart.PartSidedPipe;
import mekanism.common.multipart.PartTransmitter;
import mekanism.common.multipart.TransmitterIcons;
import mekanism.common.multipart.TransmitterType;
import mekanism.common.util.CableUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.api.energy.IEnergyHandler", modid="CoFHAPI|energy"), @Optional.Interface(iface="buildcraft.api.power.IPowerReceptor", modid="BuildCraftAPI|power")})
public class PartUniversalCable
extends PartTransmitter<EnergyNetwork>
implements IStrictEnergyAcceptor,
IEnergyHandler,
IPowerReceptor {
    public Tier.CableTier tier;
    public PowerHandler powerHandler;
    public static TransmitterIcons cableIcons = new TransmitterIcons(4, 1);
    public double currentPower = 0.0;
    public double cacheEnergy = 0.0;
    public double lastWrite = 0.0;

    public PartUniversalCable(Tier.CableTier cableTier) {
        this.tier = cableTier;
        if (MekanismUtils.useBuildCraft()) {
            this.configure();
        }
    }

    @Override
    public void update() {
        if (this.world().field_72995_K) {
            double targetPower = ((EnergyNetwork)this.getTransmitterNetwork()).clientEnergyScale;
            if (Math.abs(this.currentPower - targetPower) > 0.01) {
                this.currentPower = (9.0 * this.currentPower + targetPower) / 10.0;
            }
        } else {
            List<ForgeDirection> sides;
            double last;
            if (this.getTransmitterNetwork(false) != null && ((EnergyNetwork)this.getTransmitterNetwork(false)).getSize() > 0 && (last = this.lastWrite) != this.getSaveShare()) {
                MekanismUtils.saveChunk((TileEntity)this.tile());
            }
            if (this.cacheEnergy > 0.0) {
                ((EnergyNetwork)this.getTransmitterNetwork()).electricityStored += this.cacheEnergy;
                this.cacheEnergy = 0.0;
            }
            if (MekanismUtils.useIC2() && !(sides = this.getConnections(PartSidedPipe.ConnectionType.PULL)).isEmpty()) {
                TileEntity[] connectedOutputters = CableUtils.getConnectedOutputters((TileEntity)this.tile());
                for (ForgeDirection side : sides) {
                    double received;
                    TileEntity acceptor;
                    if (connectedOutputters[side.ordinal()] == null || !((acceptor = connectedOutputters[side.ordinal()]) instanceof IEnergySource)) continue;
                    double toDraw = received = ((IEnergySource)acceptor).getOfferedEnergy() * Mekanism.FROM_IC2;
                    if (received > 0.0) {
                        toDraw -= ((EnergyNetwork)this.getTransmitterNetwork()).emit(received);
                    }
                    ((IEnergySource)acceptor).drawEnergy(toDraw * Mekanism.TO_IC2);
                }
            }
        }
        super.update();
    }

    private double getSaveShare() {
        return EnergyNetwork.round(((EnergyNetwork)this.getTransmitterNetwork()).electricityStored * (double)(1.0f / (float)((EnergyNetwork)this.getTransmitterNetwork()).transmitters.size()));
    }

    @Override
    public void refreshTransmitterNetwork() {
        super.refreshTransmitterNetwork();
        if (MekanismUtils.useBuildCraft()) {
            this.reconfigure();
        }
    }

    @Override
    public TransmitterType getTransmitter() {
        return this.tier.type;
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        super.load(nbtTags);
        this.cacheEnergy = nbtTags.func_74769_h("cacheEnergy");
        this.tier = Tier.CableTier.values()[nbtTags.func_74762_e("tier")];
    }

    @Override
    public void save(NBTTagCompound nbtTags) {
        double toSave;
        super.save(nbtTags);
        this.lastWrite = toSave = this.getSaveShare();
        nbtTags.func_74780_a("cacheEnergy", toSave);
        nbtTags.func_74768_a("tier", this.tier.ordinal());
    }

    public String getType() {
        return "mekanism:universal_cable_" + this.tier.name().toLowerCase();
    }

    public static void registerIcons(IIconRegister register) {
        cableIcons.registerCenterIcons(register, new String[]{"UniversalCableBasic", "UniversalCableAdvanced", "UniversalCableElite", "UniversalCableUltimate"});
        cableIcons.registerSideIcons(register, new String[]{"TransmitterSideSmall"});
    }

    @Override
    public void preSingleMerge(EnergyNetwork network) {
        network.electricityStored += this.cacheEnergy;
        this.cacheEnergy = 0.0;
    }

    @Override
    public IIcon getCenterIcon() {
        return cableIcons.getCenterIcon(this.tier.ordinal());
    }

    @Override
    public IIcon getSideIcon() {
        return cableIcons.getSideIcon(0);
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.ENERGY;
    }

    @Override
    public EnergyNetwork createNetworkFromSingleTransmitter(IGridTransmitter<EnergyNetwork> transmitter) {
        return new EnergyNetwork(transmitter);
    }

    @Override
    public EnergyNetwork createNetworkByMergingSet(Set<EnergyNetwork> networks) {
        return new EnergyNetwork(networks);
    }

    @Override
    public boolean isValidAcceptor(TileEntity acceptor, ForgeDirection side) {
        return CableUtils.getConnections((TileEntity)this.tile())[side.ordinal()];
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 pos, float frame, int pass) {
        if (pass == 0 && MekanismClient.fancyUniversalCableRender) {
            RenderPartTransmitter.getInstance().renderContents(this, pos);
        }
    }

    @Override
    public void onChunkUnload() {
        if (!this.world().field_72995_K) {
            ((EnergyNetwork)this.getTransmitterNetwork()).electricityStored -= this.lastWrite;
        }
        super.onChunkUnload();
    }

    @Override
    public int getTransmitterNetworkSize() {
        return ((EnergyNetwork)this.getTransmitterNetwork()).getSize();
    }

    @Override
    public int getTransmitterNetworkAcceptorSize() {
        return ((EnergyNetwork)this.getTransmitterNetwork()).getAcceptorSize();
    }

    @Override
    public String getTransmitterNetworkNeeded() {
        return ((EnergyNetwork)this.getTransmitterNetwork()).getNeededInfo();
    }

    @Override
    public String getTransmitterNetworkFlow() {
        return ((EnergyNetwork)this.getTransmitterNetwork()).getFlowInfo();
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (!simulate) {
            return maxReceive - (int)Math.round(((EnergyNetwork)this.getTransmitterNetwork()).emit((double)maxReceive * Mekanism.FROM_TE) * Mekanism.TO_TE);
        }
        return 0;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.canReceiveEnergy(from);
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int getMaxEnergyStored(ForgeDirection from) {
        return (int)Math.round(((EnergyNetwork)this.getTransmitterNetwork()).getEnergyNeeded() * Mekanism.TO_TE);
    }

    @Override
    public int getCapacity() {
        return this.tier.cableCapacity;
    }

    @Override
    public double transferEnergyToAcceptor(ForgeDirection side, double amount) {
        if (!this.canReceiveEnergy(side)) {
            return 0.0;
        }
        double toUse = Math.min(this.getMaxEnergy() - this.getEnergy(), amount);
        this.setEnergy(this.getEnergy() + toUse);
        return toUse;
    }

    @Override
    public boolean canReceiveEnergy(ForgeDirection side) {
        return this.getConnectionType(side) == PartSidedPipe.ConnectionType.NORMAL || this.getConnectionType(side) == PartSidedPipe.ConnectionType.PULL;
    }

    @Override
    public double getMaxEnergy() {
        return ((EnergyNetwork)this.getTransmitterNetwork()).getCapacity();
    }

    @Override
    public double getEnergy() {
        return ((EnergyNetwork)this.getTransmitterNetwork()).electricityStored;
    }

    @Override
    public void setEnergy(double energy) {
        ((EnergyNetwork)this.getTransmitterNetwork()).electricityStored = energy;
    }

    @Optional.Method(modid="BuildCraftAPI|power")
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        if (((EnergyNetwork)this.getTransmitterNetwork()).getEnergyNeeded() == 0.0) {
            return null;
        }
        return this.powerHandler.getPowerReceiver();
    }

    @Optional.Method(modid="BuildCraftAPI|power")
    public World getWorld() {
        return this.world();
    }

    @Optional.Method(modid="BuildCraftAPI|power")
    private void configure() {
        this.powerHandler = new PowerHandler((IPowerReceptor)this, PowerHandler.Type.STORAGE);
        this.powerHandler.configurePowerPerdition(0, 0);
        this.powerHandler.configure(0.0, 0.0, 0.0, 0.0);
    }

    @Optional.Method(modid="BuildCraftAPI|power")
    private void reconfigure() {
        float needed = (float)(((EnergyNetwork)this.getTransmitterNetwork()).getEnergyNeeded() * Mekanism.TO_BC);
        this.powerHandler.configure(1.0, (double)needed, 0.0, (double)needed);
    }

    @Optional.Method(modid="BuildCraftAPI|power")
    public void doWork(PowerHandler workProvider) {
        if (this.powerHandler.getEnergyStored() > 0.0) {
            ((EnergyNetwork)this.getTransmitterNetwork()).emit(this.powerHandler.getEnergyStored() * Mekanism.FROM_BC);
        }
        this.powerHandler.setEnergy(0.0);
        this.reconfigure();
    }
}

